<?php

/**
 * Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//load parent CSS
if (!function_exists('flicker_child_enqueue_static')) :
    /**
     * flicker_child_enqueue_static
     *
     * @return void
     * @since 0.0.1
     */
    function flicker_child_enqueue_static()
    {
        wp_enqueue_style(
            'flicker-child-style',
            get_stylesheet_directory_uri() . '/style.css',
            array('flicker-style'),
            wp_get_theme()->get('Version')
        );
    }
endif;
add_action('wp_enqueue_scripts', 'flicker_child_enqueue_static', 999);
