<?php

/**
 * View: List Single Event Venue
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/list/event/venue.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://evnt.is/1aiy
 *
 * @version 6.2.0
 * @since 6.2.0 Added the `tec_events_view_venue_after_address` action.
 *
 * @var WP_Post $event The event post object with properties added by the `tribe_get_event` function.
 * @var string  $slug  The slug of the view.
 *
 * @see tribe_get_event() For the format of the event object.
 */

if (!$event->venues->count()) {
	return;
}

$venue                = $event->venues[0];
?>
<address class="tribe-events-calendar-list__event-venue">
	<span class="tribe-events-calendar-list__event-venue-title">
		<?php echo wp_kses_post($venue->post_title); ?>
	</span>
</address>