<?php

/**
 * Single Event Meta (Venue) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/venue.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 */

if (!tribe_get_venue_id()) {
	return;
}

$phone   = tribe_get_phone();
$website = tribe_get_venue_website_link();
$website_title = tribe_events_get_venue_website_title();

?>

<div class="tribe-events-meta-group-venue">
	<?php do_action('tribe_events_single_meta_venue_section_start') ?>
	<div class="event-venue-wrap">
		<strong class="label-venue"> <?php echo esc_html('Place:', 'flicker') ?> </strong>

		<?php if (tribe_address_exists()) : ?>
			<span class="tribe-venue-location">
				<address class="tribe-events-address">
					<?php echo tribe_get_full_address(); ?>

					<?php if (tribe_show_google_map_link()) : ?>
						<?php echo tribe_get_map_link_html(); ?>
					<?php endif; ?>
				</address>
			</span>
		<?php endif; ?>
	</div>
	<?php if (!empty($phone)) : ?>
		<div class="event-venue-wrap">
			<strong class="tribe-venue-tel-label"> <?php esc_html_e('Phone:', 'the-events-calendar') ?> </strong>
			<span class="tribe-venue-tel"> <?php echo $phone ?> </span>
		</div>
	<?php endif ?>

	<?php if (!empty($website)) : ?>
		<?php if (!empty($website_title)) : ?>
			<span class="tribe-venue-url-label"> <?php echo esc_html($website_title) ?> </span>
		<?php endif ?>
		<span class="tribe-venue-url"> <?php echo $website ?> </span>
	<?php endif ?>

	<?php do_action('tribe_events_single_meta_venue_section_end') ?>
</div>