<?php

/**
 * The template for displaying page title in page title section
 *
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (is_search()) :
	$flicker_search_query = esc_html(get_search_query());
	if ((bool) trim($flicker_search_query) === false) :
		echo esc_html__('Search', 'flicker');
	else :
		echo esc_html__('Search Results for: ', 'flicker');
		echo esc_html($flicker_search_query);
	endif;

	return;
endif;

if (is_home()) :
	$flicker_title = flicker_option('blog_page_name', esc_html__('Blog', 'flicker'));
	echo esc_html($flicker_title);

	return;
endif;

if (is_404()) :
	$flicker_title = esc_html__('404', 'flicker');
	echo esc_html($flicker_title);

	return;
endif;

if (function_exists('is_shop')) :
	if (is_shop()) :
		$flicker_title = esc_html__('Shop', 'flicker');
		echo esc_html($flicker_title);

		return;
	endif;
endif;

if (is_singular()) :
	the_title();

	return;
endif;

if (is_archive()) :
	$flicker_hide_tax_name_class = flicker_option('title_hide_taxonomy_name', '') ? 'hide-tax-name' : 'tax-name';
	echo '<span class="' . esc_attr($flicker_hide_tax_name_class) . '">';
	the_archive_title();
	echo '</span>';

	return;
endif;
