<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//options
$flicker_fluid             = flicker_option('header_fluid') ? '-fluid' : '';
$flicker_transparent       = flicker_option('header_transparent') ? 'transparent' : '';
$flicker_absolute          = flicker_option('header_absolute') ? 'absolute' : '';
$flicker_header_top_tall   = flicker_option('header_top_tall') ? 'header-tall' : '';
$flicker_sticky            = flicker_option('header_sticky');
$flicker_header_meta         = flicker_option('header_meta') ? 'show-header-meta' : '';
$flicker_header_background = flicker_option('header_background', '');
$flicker_header_toplogo_bg = flicker_option('header_toplogo_background', 'l');
$flicker_font_size         = flicker_option('header_toplogo_font_size', '');

$flicker_border_top    = flicker_option('header_border_top', '');
$flicker_border_bottom = flicker_option('header_border_bottom', '');

//meta
$flicker_meta                 = flicker_get_theme_meta();
$header_meta                 = flicker_option('header_meta');

$flicker_toggler_side_in_header = flicker_option('header_toggler_menu_side', true);
$flicker_toggler_main_in_header = flicker_option('header_toggler_menu_main', true);

$flicker_header_align_main_menu = flicker_option('header_align_main_menu', '');
$flicker_header_has_menu_class  = has_nav_menu('primary') ? 'has-menu' : 'no-menu';

$header_toplogo = flicker_option('header_toplogo');

if (!empty($header_toplogo)) :
?>
    <div id="toplogo" class="toplogo toplogo-2 <?php echo esc_attr($flicker_font_size . ' ' . $flicker_header_toplogo_bg . ' ' . $flicker_header_top_tall); ?>">
        <div class="container<?php echo esc_attr($flicker_fluid); ?> container-flex">
            <div class="logo-wrap">
                <?php
                get_template_part('template-parts/header/logo/logo', flicker_template_part('logo', '1'));
                ?>
            </div>
            <?php if ((!empty($flicker_meta['phone']) || !empty($flicker_meta['email'])) && !empty($header_meta)) : ?>
                <div class="inline-teasers-wrap">
                <?php endif; ?>
                <?php
                if (!empty($flicker_meta['phone']) && !empty($header_meta)) :
                    $phone_from_meta = $flicker_meta['phone'];
                    $print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta);
                ?>
                    <div class="teaser text-left">
                        <div class="teaser-left">
                            <div class="teaser_icon with_background highlight rounded"><?php flicker_icon('phone'); ?></div>
                        </div>
                        <div class="teaser-body medium">
                            <a class="phone" href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($flicker_meta['phone']); ?></a>
                        </div>
                    </div>
                <?php endif; // header_phone 
                ?>
                <?php
                if (!empty($flicker_meta['email']) && !empty($header_meta)) :
                ?>
                    <div class="teaser text-left">
                        <div class="teaser-left">
                            <div class="teaser_icon with_background highlight rounded"><?php flicker_icon('email'); ?></div>
                        </div>
                        <div class="teaser-body medium">
                            <a href="mailto:<?php echo esc_attr($flicker_meta['email']); ?>"><?php echo wp_kses_post($flicker_meta['email']); ?></a>
                        </div>
                    </div>
                <?php
                endif; //email 
                ?>
                <?php if ((!empty($flicker_meta['phone']) || !empty($flicker_meta['email'])) && !empty($header_meta)) : ?>
                </div><!-- .inline-teasers-wrap -->
            <?php endif; ?>
        </div>
    </div><!-- eof .col- -->
<?php endif; ?>