<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//meta
$flicker_meta                 = flicker_get_theme_meta();

$flicker_fluid                = flicker_option('topline_fluid') ? '-fluid' : '';
$flicker_topline_background   = flicker_option('topline_background', '');
$flicker_font_size            = flicker_option('topline_font_size', '');

$flicker_topline_meta_mail    = flicker_option('topline_meta_mail');
$flicker_topline_meta_phone   = flicker_option('topline_meta_phone');
$flicker_topline_meta_address = flicker_option('topline_meta_address');
$flicker_topline_meta_opening_hours = flicker_option('topline_meta_opening_hours');

?>
<div id="topline" class="topline topline-3 <?php echo esc_attr($flicker_topline_background . ' ' . $flicker_font_size); ?>">
    <div class="container<?php echo esc_attr($flicker_fluid); ?>">
        <?php if (!empty($flicker_meta)) : ?>
            <div>
                <span class="inline-content greylinks medium">
                    <?php
                    if (!empty($flicker_meta['address']) && $flicker_topline_meta_address) :
                    ?>
                        <span class="icon-inline">
                            <?php flicker_icon('map-marker'); ?>
                            <span>
                                <?php if (!empty($flicker_meta['address_label'])) : ?>
                                    <strong><?php echo wp_kses_post($flicker_meta['address_label']); ?></strong>
                                <?php endif; ?>
                                <span><?php echo wp_kses_post($flicker_meta['address']); ?></span>
                            </span>
                        </span>
                    <?php
                    endif; //address
                    if (!empty($flicker_meta['phone']) && $flicker_topline_meta_phone) :
                        $phone_from_meta = $flicker_meta['phone'];
                        $print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta);
                    ?>
                        <span class="icon-inline">
                            <?php flicker_icon('phone'); ?>
                            <span>
                                <?php if (!empty($flicker_meta['phone_label'])) : ?>
                                    <strong><?php echo wp_kses_post($flicker_meta['phone_label']); ?></strong>
                                <?php endif; ?>
                                <a class="phone" href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($flicker_meta['phone']); ?></a>
                            </span>
                        </span>
                    <?php
                    endif; //phone
                    if (!empty($flicker_meta['email']) && $flicker_topline_meta_mail) :
                    ?>
                        <span class="icon-inline">
                            <?php flicker_icon('pencil'); ?>
                            <span>
                                <?php if (!empty($flicker_meta['email_label'])) : ?>
                                    <strong><?php echo wp_kses_post($flicker_meta['email_label']); ?></strong>
                                <?php endif; ?>
                                <a href="mailto:<?php echo esc_attr($flicker_meta['email']); ?>"><?php echo wp_kses_post($flicker_meta['email']); ?></a>
                            </span>
                        </span>
                    <?php
                    endif; //email
                    if (!empty($flicker_meta['opening_hours']) && $flicker_topline_meta_opening_hours) :
                    ?>
                        <span class="icon-inline">
                            <?php flicker_icon('clock'); ?>
                            <span>
                                <?php if (!empty($flicker_meta['opening_hours_label'])) : ?>
                                    <strong><?php echo wp_kses_post($flicker_meta['opening_hours_label']); ?></strong>
                                <?php endif; ?>
                                <span><?php echo wp_kses_post($flicker_meta['opening_hours']); ?></span>
                            </span>
                        </span>
                    <?php
                    endif; //opening_hours
                    ?>
                </span><!-- .site-meta -->
            </div>
        <?php
        endif; //! empty meta
        ?>
        <?php flicker_social_links(); ?>
        <?php
        get_template_part('template-parts/header/header-search');
        ?>
    </div><!-- .container -->
</div><!-- #topline -->