<?php

/**
 * The header top template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//wrapper for topline, header and title
echo '<div id="top-wrap">';

$flicker_intro_position = flicker_option('intro_position', '');
//intro section on front page after header
if (flicker_is_front_page() && 'before' === $flicker_intro_position) :

	get_template_part('template-parts/header/intro');

endif;

$flicker_header_image_url = get_header_image();
if (!empty($flicker_header_image_url)) :
	$flicker_background_image = flicker_section_background_image_array('header_image', true);
?>
	<div id="header-image" class="i <?php echo esc_attr($flicker_background_image['class']); ?>" style="background-image: url('<?php echo esc_url($flicker_background_image['url']); ?> ');">
	<?php
endif; //header_image_url

$flicker_absolute_home_page = flicker_option('header_absolute_home_page', '');
$flicker_header_absolute = flicker_option('header_absolute', '');

if (!empty($flicker_absolute_home_page) && is_front_page() && empty($flicker_header_absolute)) :
	?>
		<div class="header-absolute-wrap">
			<div class="header-absolute-content home-absolute">
			<?php
		endif; //$flicker_header_absolute_home_page 

		if (!empty($flicker_header_absolute)) :
			?>
				<div class="header-absolute-wrap">
					<div class="header-absolute-content">
					<?php
				endif; //$flicker_header_absolute

				//topline header section
				get_template_part('template-parts/header/topline/topline', flicker_template_part('topline', ''));

				//header section
				get_template_part('template-parts/header/header', flicker_template_part('header', '1'));

				if (!empty($flicker_header_absolute)) :
					?>
					</div><!-- .header-absolute-content -->
					<?php
					if (!empty($flicker_absolute_home_page) && is_front_page() && empty($flicker_header_absolute)) :
					?>
				</div><!-- .header-absolute-front-page-content -->
				<?php endif;

					//title section not on front page
					if (flicker_is_title_section_is_shown() && !is_404() && !is_page_template('page-templates/home.php')) :
						get_template_part('template-parts/title/title', flicker_template_part('title', '1'));
					//front page text
					else :
						//TODO homepage fullwidth image
						$flicker_display_header_text = display_header_text();
						if (!empty($flicker_display_header_text)) : ?>
					<h1 class="site-title">
						<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
							<?php echo wp_kses_post(get_bloginfo('name', 'display')); ?>
						</a>
					</h1>
					<?php
							$flicker_description = get_bloginfo('description', 'display');

							if ($flicker_description || is_customize_preview()) : ?>
						<p class="site-description"><?php echo wp_kses_post($flicker_description); ?></p>
			<?php
							endif; //description
						endif; //display_header_text
					endif; //flicker_is_front_page
			?>
			</div><!-- .header-absolute-wrap -->
			<?php
				else :
					//title section not on front page
					if (flicker_is_title_section_is_shown() && !is_404() && !is_page_template('page-templates/home.php')) :
						get_template_part('template-parts/title/title', flicker_template_part('title', '1'));
					//front page text
					else :
						//TODO homepage fullwidth image
						$flicker_display_header_text = display_header_text();
						if (!empty($flicker_display_header_text)) : ?>
					<h1 class="site-title">
						<a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
							<?php echo wp_kses_post(get_bloginfo('name', 'display')); ?>
						</a>
					</h1>
					<?php
							$flicker_description = get_bloginfo('description', 'display');

							if ($flicker_description || is_customize_preview()) : ?>
						<p class="site-description"><?php echo wp_kses_post($flicker_description); ?></p>
			<?php
							endif; //description
						endif; //display_header_text
					endif; //flicker_is_front_page
				endif; //$flicker_header_absolute

				if (!empty($flicker_absolute_home_page) && is_front_page() && empty($flicker_header_absolute)) : ?>
		</div>
	</div>
<?php endif; //$flicker_header_absolute_home_page 

				/**
				 * Fires after the header.
				 *
				 * @since WBPlank 0.0.1
				 */
				do_action('flicker_action_after_header');

				//intro section on front page after header
				if (flicker_is_front_page() && 'after' === $flicker_intro_position) :
					get_template_part('template-parts/header/intro');
				endif;

				if (!empty($flicker_header_image_url)) :
?>
	</div>
	<!--#header-image-->
<?php
				endif; //$flicker_header_image_url

				echo '</div><!--#top-wrap-->';
