<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
//options
$flicker_fluid             = flicker_option('header_fluid') ? '-fluid' : '';
$flicker_transparent       = flicker_option('header_transparent') ? 'transparent' : '';
$flicker_absolute          = flicker_option('header_absolute') ? 'absolute' : '';
$flicker_header_top_tall   = flicker_option('header_top_tall') ? 'header-tall' : '';
$flicker_sticky            = flicker_option('header_sticky');
$flicker_header_background = flicker_option('header_background', '');
$flicker_font_size         = flicker_option('header_font_size', '');

$flicker_border_top    = flicker_option('header_border_top', '');
$flicker_border_bottom = flicker_option('header_border_bottom', '');

$flicker_toggler_side_in_header = flicker_option('header_toggler_menu_side', true);
$flicker_toggler_main_in_header = flicker_option('header_toggler_menu_main', true);

$flicker_header_align_main_menu = flicker_option('header_align_main_menu', '');

//meta
$flicker_meta                 = flicker_get_theme_meta();
$flicker_header_meta          = flicker_option('header_meta');

?>
<header id="header" class="page_header_side ls header-7 <?php echo esc_attr($flicker_header_background . ' ' . $flicker_header_align_main_menu . ' ' . $flicker_font_size . ' ' . $flicker_sticky . ' ' . $flicker_transparent . ' ' . $flicker_absolute); ?>">
    <span class="toggle_menu_side"><span></span></span>
    <div class="scrollbar-macosx">
        <div class="side_header_inner">
            <div class="logo-wrap">
                <?php
                get_template_part('template-parts/header/logo/logo', flicker_template_part('logo', '1'));
                ?>
            </div>
            <div class="header-side-menu">
                <nav class="mainmenu_side_wrapper">
                    <?php wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'menu_class'     => 'nav menu-side-click',
                        'container'      => 'ul'
                    )); ?>
                </nav>
            </div>
            <?php if ((!empty($flicker_meta['phone']) || !empty($flicker_meta['email'])) && !empty($flicker_header_meta)) :
                $phone_from_meta = $flicker_meta['phone'];
                $print_phone = preg_replace("/[^0-9]/", '', $phone_from_meta);
            ?>
                <span class="meta-wrap greylinks">
                    <strong><a class="phone" href="tel:<?php echo esc_attr($print_phone); ?>"><?php echo wp_kses_post($flicker_meta['phone']); ?></a></strong>
                    <a href="mailto:<?php echo esc_attr($flicker_meta['email']); ?>"><?php echo wp_kses_post($flicker_meta['email']); ?></a>
                </span>
            <?php
            endif; //meta 
            ?>
            <?php flicker_social_links(); ?>
        </div><!-- eof .side_header_inner -->
    </div><!-- eof .scrollbar-macosx-->
</header><!-- eof .page_header_side-->