<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
$author_id = get_the_author_meta('ID');
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('bg_teaser text-center vertical-item'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	flicker_post_thumbnail('flicker-default-post');
	?>
	<div class="item-content content-padding i">
		<div class="entry-meta post-meta small-text greylinks">
			<?php
			if (
				!empty(flicker_option('blog_show_date'))
				|| !empty(flicker_option('blog_show_tags'))
				|| !empty(flicker_option('blog_show_views'))
			) :
			?>
				<div class="meta-left">
					<?php
					flicker_entry_meta(true, false, false, true, false, true, true);
					?>
				</div>
			<?php
			endif;
			?>
			<?php
			if (
				!empty(flicker_option('blog_share_facebook', true))
				||
				!empty(flicker_option('blog_share_twitter', true))
				||
				!empty(flicker_option('blog_share_telegram', true))
				||
				!empty(flicker_option('blog_share_pinterest', true))
				||
				!empty(flicker_option('blog_share_linkedin', true))
			) :
				if (function_exists('flicker_share_this')) {
			?>
					<div class="entry-blog-share">
						<?php
						flicker_share_this();
						?>
					</div>
			<?php
				}
			endif;
			?>
		</div><!-- .entry-meta -->
		<header class="entry-header">
			<div class="entry-avatar">
				<?php
				global $post;
				echo get_avatar($post->post_author, 96); ?>
			</div>
			<?php
			if (get_the_title()) :
				the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
			endif;
			?>
		</header><!-- .entry-header -->
		<div class="entry-content" itemprop="text">
			<?php
			the_content(
				esc_html__('', 'flicker')
			);
			wp_link_pages(
				flicker_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
		<hr>
		<div class="entry-meta ">
			<?php
			if (
				!empty(flicker_option('blog_show_author'))
				|| !empty(flicker_option('blog_show_categories'))
				|| !empty(flicker_option('blog_show_comments_link'))
			) :
			?>
				<?php
				flicker_entry_meta(false, true, true, false, true, false, false);
				?>
			<?php
			endif;
			?>
		</div><!-- .entry-meta -->
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->