<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

?>
<div class="grid-item">
    <article id="post-<?php the_ID(); ?>" <?php post_class('content-narrow bg_teaser text-center vertical-item content-padding'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
        <?php
        flicker_post_thumbnail('flicker-square');
        ?>
        <div class="item-content i">
            <?php if (get_the_title()) : ?>
                <?php
                the_title(sprintf('<h3 class="entry-title d-none" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
                ?>
            <?php endif; //get_the_title 
            ?>

            <?php
            the_content(
                flicker_read_more_inside_link_markup()
            );

            wp_link_pages(
                flicker_get_wp_link_pages_atts()
            );
            ?>
        </div><!-- .item-content -->
    </article><!-- #post-<?php the_ID(); ?> -->
</div>