<?php

/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 * @version 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_css_classes = flicker_get_layout_css_classes();

if (empty($flicker_css_classes['aside'])) {
	if (is_customize_preview()) {
		echo '<aside id="aside" class="d-none"></aside>';
	}
	return;
}
$flicker_sidebar_sticky       = flicker_option('main_sidebar_sticky', false);

$flicker_sidebar_margin_right = flicker_option('main_sidebar_margin_right', '');

$flicker_sidebar_sticky_class = !empty($flicker_sidebar_sticky) ? ' sticky' : '';
$flicker_font_size            = flicker_option('sidebar_font_size', '');
$flicker_sidebar_extra_class  = '';
if (is_page_template('page-templates/home.php') || is_front_page()) {
	if (is_active_sidebar('sidebar-home-after-columns')) {
		$flicker_sidebar_extra_class .= 'with-after-columns-sidebar';
	}
}
?>
<aside id="aside" itemtype="https://schema.org/WPSideBar" itemscope="itemscope" class="<?php echo esc_attr($flicker_css_classes['aside'] . ' ' . $flicker_font_size . ' ' . $flicker_sidebar_extra_class); ?> m-lg-<?php echo esc_attr($flicker_sidebar_margin_right) ?>">
	<div class="widgets-wrap<?php echo esc_attr($flicker_sidebar_sticky_class); ?>">

		<?php
		/**
		 * Fires at the top of aside column.
		 *
		 * @since Flicker 0.0.1
		 */
		do_action('flicker_action_top_of_aside_column');


		if (flicker_is_shop()) {
			dynamic_sidebar('shop');
		} else {
			if (is_page_template('page-templates/home.php') || is_front_page()) {
				if (is_active_sidebar('sidebar-home-main')) {
					dynamic_sidebar('sidebar-home-main');
				} else {
					dynamic_sidebar('sidebar-1');
				}
			} else {
				dynamic_sidebar('sidebar-1');
			}
		}


		/**
		 * Fires at the bottom of aside column.
		 *
		 * @since Flicker 0.0.1
		 */
		do_action('flicker_action_bottom_of_aside_column');

		?>

	</div><!-- .widgets-wrap -->
</aside><!-- .column-aside -->