<?php

/**
 * The search template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_show_title   = !flicker_option('title_show_title', '') && get_the_title();

get_header();

?>
<div id="layout" class="layout-search">
	<?php if (!empty($flicker_show_title)) : ?>
		<h1><?php get_template_part('template-parts/title/title-text'); ?></h1>
		<?php
	endif; //show_title

	if (have_posts()) {

		// Load posts loop.
		while (have_posts()) :
			the_post();
			if ('product' === get_post_type() && function_exists('wc_get_template')) :
		?>
				<div class="woo woocommerce columns-1">
					<ul class="products search-results">
						<?php
						wc_get_template('content-product.php');
						?>
					</ul>
				</div>
			<?php
			else :
			?>
				<article id="post-<?php the_ID(); ?>" <?php post_class('content-padding with-background'); ?>>
					<?php

					the_title('<header class="entry-header"><h2 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2></header>');

					if (
						'post' === get_post_type()
					) :
					?>
						<div class="entry-meta post-meta"><?php flicker_entry_meta(true, true, false, true, true, true, true); ?></div><!-- .entry-meta -->
					<?php
					endif; //'post'

					the_excerpt();
					?>
				</article><!-- #post-<?php the_ID(); ?> -->
	<?php
			endif;
		endwhile;

		// Previous/next page navigation.
		the_posts_pagination(
			flicker_get_the_posts_pagination_atts()
		);
	} else {

		// If no content, include the "No posts found" template.
		get_template_part('template-parts/content', 'none');
	}
	?>
</div><!-- #layout -->
<?php

get_footer();
