<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$flicker_layouts           = flicker_get_feed_layout_options( true );
$flicker_gaps              = flicker_get_feed_layout_gap_options( true );
$flicker_sidebar_positions = flicker_get_sidebar_position_options( true );

//options for categories
//returning array of fields
return array(
	'layout'           => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Layout', 'flicker' ),
		'description' => esc_html__( 'Category layout', 'flicker' ),
		'default'     => '',
		'choices'     => $flicker_layouts,
	),
	'gap'              => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Items gap (for grid layouts)', 'flicker' ),
		'description' => esc_html__( 'Gap between elements in pixels', 'flicker' ),
		'default'     => '',
		'choices'     => $flicker_gaps,
	),
	'sidebar_position' => array(
		'type'        => 'select',
		'label'       => esc_html__( 'Sidebar position', 'flicker' ),
		'description' => esc_html__( 'Sidebar position for category', 'flicker' ),
		'default'     => '',
		'choices'     => $flicker_sidebar_positions,
	),
);
