<?php

/**
 * Theme static files
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

/**
 * Enqueue scripts and styles.
 */
//front end styles and scripts
if (!function_exists('flicker_enqueue_static')) :
	function flicker_enqueue_static()
	{

		$min = flicker_option('assets_min') ? 'min/' : '';

		//main theme css file
		wp_enqueue_style('flicker-style', FLICKER_THEME_URI . '/assets/css/' . $min . 'style.css', array(), FLICKER_THEME_VERSION);

		$flicker_colors_string = flicker_get_root_colors_inline_styles_string();
		if (!empty($flicker_colors_string)) :
			wp_add_inline_style(
				'flicker-style',
				wp_kses(
					':root{' . $flicker_colors_string . '}',
					false
				)
			);
		endif;

		$footer_menu_logo = flicker_option('custom_logo');
		if (!empty($footer_menu_logo)) :
			wp_add_inline_style(
				'flicker-style',
				wp_kses(
					'.widget_nav_menu.horizontal-menu.with-logo-img li.menu-item-home a::before{background-image:url(' . esc_url(wp_get_attachment_image_src($footer_menu_logo, 'full')[0]) . ') !important;}',
					false
				)
			);
		endif;

		$footer_menu_logo_inverse = flicker_option('logo_image_inverse', '');
		if (!empty($footer_menu_logo_inverse)) :
			wp_add_inline_style(
				'flicker-style',
				wp_kses(
					'.i .widget_nav_menu.horizontal-menu.with-logo-img li.menu-item-home a::before{background-image:url(' . esc_url($footer_menu_logo_inverse) . ') !important;}',
					false
				)
			);
		endif;

		wp_enqueue_style('font-awesome', FLICKER_THEME_URI . '/assets/css/' . $min . 'all.css', array(), FLICKER_THEME_VERSION);
		wp_enqueue_style('icomoon', FLICKER_THEME_URI . '/assets/css/' . $min . 'icomoon.css', array(), FLICKER_THEME_VERSION);
		wp_enqueue_style('specicons', FLICKER_THEME_URI . '/assets/css/' . $min . 'specicons.css', array(), FLICKER_THEME_VERSION);

		//Woo styles
		if (class_exists('WooCommerce')) {
			wp_enqueue_style('flicker-shop-style', FLICKER_THEME_URI . '/assets/css/' . $min . 'shop.css', array(), FLICKER_THEME_VERSION);
		}

		//custom Google fonts css file and inline styles if option is enabled
		// based on:
		// https://gist.github.com/kailoon/e2dc2a04a8bd5034682c
		// http://themeshaper.com/2014/08/13/how-to-add-google-fonts-to-wordpress-themes/
		$flicker_font_body     = json_decode(flicker_option('font_body', '{"font":"","variant": [],"subset":[]}'));
		$flicker_font_headings = json_decode(flicker_option('font_headings', '{"font":"","variant": [],"subset":[]}'));
		//TODO subsets can exists even if no font selected
		if (!empty($flicker_font_body->font) || !empty($flicker_font_headings->font)) {
			/*
			Translators: If there are characters in your language that are not supported
			by chosen font(s), translate this to 'off'. Do not translate into your own language.
			*/

			if ('off' !== esc_html_x('on', 'Google font: on or off', 'flicker')) {
				$flicker_body_subsets  = array();
				$flicker_font_body_font = '';
				if (!empty($flicker_font_body->font)) {
					$flicker_font_body_font = $flicker_font_body->font;
					if (!empty($flicker_font_body->variant)) {
						$flicker_font_body->font .= ':' . implode(',', $flicker_font_body->variant);
					}
					$flicker_body_subsets  = $flicker_font_body->subset;
				}

				$flicker_headings_subsets  = array();
				$flicker_font_headings_font = '';
				if (!empty($flicker_font_headings->font)) {
					$flicker_font_headings_font = $flicker_font_headings->font;
					if (!empty($flicker_font_headings->variant)) {
						$flicker_font_headings->font .= ':' . implode(',', $flicker_font_headings->variant);
					}
					$flicker_headings_subsets  = $flicker_font_headings->subset;
				}

				$flicker_fonts    = array(
					'body'     => $flicker_font_body->font,
					'headings' => $flicker_font_headings->font,
				);
				$flicker_subsets  = array(
					'body'     => implode(',', $flicker_body_subsets),
					'headings' => implode(',', $flicker_headings_subsets),
				);
				//'Montserrat|Bowlby One|Quattrocento Sans';
				$flicker_fonts_string    = implode('|', array_filter($flicker_fonts));
				$flicker_subsets_string  = implode(',', array_filter($flicker_subsets));

				$flicker_query_args = array(
					'family' => urlencode($flicker_fonts_string),
				);
				if (!empty($flicker_subsets_string)) {
					$flicker_query_args['subset'] = urlencode($flicker_subsets_string);
				}
				$flicker_query_args['display'] = 'swap';
				$flicker_font_url = add_query_arg(
					$flicker_query_args,
					'//fonts.googleapis.com/css'
				);

				//no need to provide anew version for Google fonts link
				wp_enqueue_style('flicker-google-fonts-style', $flicker_font_url, array(), '1.0.0');
				//printing header styles

				$flicker_body_style = (!empty($flicker_font_body_font)) ? 'body,.wp-block-calendar table caption{font-family:"' . $flicker_font_body_font . '";}' : '';

				$flicker_secondary_selectors = array(
					'.logo-text-primary',
					'h1',
					'h2',
					'h3',
					'h4',
					'h5',
					'h6',
					'.top-menu li a',
				);

				$flicker_headings_style = (!empty($flicker_font_headings_font)) ? join(',', $flicker_secondary_selectors) . '{font-family: "' . $flicker_font_headings_font . '"}' : '';

				wp_add_inline_style(
					'flicker-google-fonts-style',
					wp_kses(
						$flicker_body_style . $flicker_headings_style,
						false
					)
				);
			}
		}

		//admin-bar styles for front end
		if (is_admin_bar_showing()) {
			//Add Frontend admin styles
			wp_enqueue_style(
				'flicker-admin-bar-style',
				FLICKER_THEME_URI . '/assets/css/admin-frontend.css',
				array(),
				FLICKER_THEME_VERSION
			);
		}

		//flexslider
		wp_enqueue_script('flexslider', FLICKER_THEME_URI . '/assets/js/vendor/jquery.flexslider-min.js', array('jquery'), FLICKER_THEME_VERSION, true);

		//owl-carousel
		wp_enqueue_script('owl-carousel', FLICKER_THEME_URI . '/assets/js/vendor/owl.carousel.min.js', array('jquery'), FLICKER_THEME_VERSION, true);

		//jquery-numerator
		wp_enqueue_script('jquery-numerator', FLICKER_THEME_URI . '/assets/js/vendor/jquery-numerator.min.js', array('jquery'), FLICKER_THEME_VERSION, true);

		//jquery-twentytwenty
		wp_enqueue_script('twentytwenty', FLICKER_THEME_URI . '/assets/js/vendor/jquery.twentytwenty.js', array('jquery'), FLICKER_THEME_VERSION, true);

		//jquery-event-move
		wp_enqueue_script('event-move', FLICKER_THEME_URI . '/assets/js/vendor/jquery.event.move.js', array('jquery'), FLICKER_THEME_VERSION, true);

		//always load masonry
		wp_enqueue_script('masonry', '', array('imagesloaded'), '', true);

		//photoswipe
		if (is_singular()) {
			wp_enqueue_style(
				'photoswipe',
				FLICKER_THEME_URI . '/assets/vendor/photoswipe/photoswipe.css',
				array(),
				FLICKER_THEME_VERSION
			);
			wp_enqueue_style(
				'photoswipe-skin',
				FLICKER_THEME_URI . '/assets/vendor/photoswipe/default-skin/default-skin.css',
				array('photoswipe'),
				FLICKER_THEME_VERSION
			);
			wp_enqueue_script('photoswipe', FLICKER_THEME_URI . '/assets/vendor/photoswipe/photoswipe.min.js', array(), FLICKER_THEME_VERSION, true);
			wp_enqueue_script('photoswipe-ui', FLICKER_THEME_URI . '/assets/vendor/photoswipe/photoswipe-ui-default.js', array('photoswipe'), FLICKER_THEME_VERSION, true);
		}

		//glightbox
		wp_enqueue_style(
			'glightbox',
			FLICKER_THEME_URI . '/assets/vendor/glightbox/glightbox.min.css',
			array(),
			FLICKER_THEME_VERSION
		);

		wp_enqueue_script('glightbox', FLICKER_THEME_URI . '/assets/vendor/glightbox/glightbox.min.js', array(), FLICKER_THEME_VERSION, true);

		$min_js = !FLICKER_DEV_MODE ? 'min/' : '';
		//main theme script
		wp_enqueue_script('flicker-init-script', FLICKER_THEME_URI . '/assets/js/' . $min_js . 'init.js', array('jquery'), FLICKER_THEME_VERSION, true);

		//animation scripts and styles
		if (flicker_option('animation_enabled', false)) :
			wp_enqueue_script('flicker-animation-script', FLICKER_THEME_URI . '/assets/js/' . $min_js . 'animation.js', array(), FLICKER_THEME_VERSION, true);
			wp_enqueue_style('flicker-animate', FLICKER_THEME_URI . '/assets/css/' . $min . 'animate.css', array(), FLICKER_THEME_VERSION);
		endif;

		//comments script
		if (is_singular() && comments_open() && get_option('thread_comments')) {
			wp_enqueue_script('comment-reply');
		}

		//move jQuery scripts to the footer if customizer option is active and if not user logged in
		if (flicker_option('jquery_to_footer', false) && !is_user_logged_in()) :
			wp_scripts()->add_data('jquery', 'group', 1);
			wp_scripts()->add_data('jquery-core', 'group', 1);
			wp_scripts()->add_data('jquery-migrate', 'group', 1);
		endif;

		//customizer preview
		if (is_customize_preview()) {
			wp_enqueue_script('flicker-customize-preview-script', FLICKER_THEME_URI . '/assets/js/' . $min_js . 'customize-preview.js', array('jquery', 'customize-selective-refresh'), FLICKER_THEME_VERSION, true);
		}
	}
endif;
add_action('wp_enqueue_scripts', 'flicker_enqueue_static');

//enqueue masonry for grid layout
if (!function_exists('flicker_enqueue_masonry')) :
	function flicker_enqueue_masonry()
	{
		wp_enqueue_script('masonry', '', array('imagesloaded'), '', true);
	}
endif;
//enqueue masonry for grid layout action
if (!function_exists('flicker_enqueue_masonry_action')) :
	function flicker_enqueue_masonry_action()
	{
		add_action('wp_enqueue_scripts', 'flicker_enqueue_masonry');
	}
endif;


//Gutenberg script
//https://developer.wordpress.org/block-editor/tutorials/javascript/loading-javascript/
if (!function_exists('flicker_action_enqueue_block_editor_assets')) :
	function flicker_action_enqueue_block_editor_assets($flicker_page)
	{

		$min = !FLICKER_DEV_MODE ? 'min/' : '';

		$deps = array(
			'lodash',
			'wp-i18n',
			'wp-element',
			'wp-components',
			'wp-data',
			'wp-plugins',
			'wp-blocks',
			'wp-dom-ready',
		);
		//v 5.8 has block editor on widgets and throws error when 'edit post' scripts are loaded as a dependency
		$screen = function_exists('get_current_screen') ? get_current_screen() : false;
		if ($screen) {
			if ('widgets' !== $screen->id) {
				$deps[] = 'wp-edit-post';
				$deps[] = 'wp-editor';

				//animation scripts and styles
				if (flicker_option('animation_enabled', false) && empty(flicker_option('animation_disable_for_gutenberg', false))) :
					wp_enqueue_script(
						'gutenberg-animation',
						FLICKER_THEME_URI . '/assets/js/' . $min . 'gutenberg-animation.js',
						$deps,
						FLICKER_THEME_VERSION
					);
				endif;
			}
		}
		wp_enqueue_script(
			'gutenberg',
			FLICKER_THEME_URI . '/assets/js/' . $min . 'gutenberg.js',
			$deps,
			FLICKER_THEME_VERSION
		);
	}
endif;
add_action('enqueue_block_editor_assets', 'flicker_action_enqueue_block_editor_assets');


//login page styles
if (!function_exists('flicker_action_login_enqueue_static')) :
	function flicker_action_login_enqueue_static($flicker_page)
	{
		wp_enqueue_style(
			'flicker-login-page-style',
			FLICKER_THEME_URI . '/assets/css/login-page.css',
			array(),
			FLICKER_THEME_VERSION
		);
		$flicker_colors_string = flicker_get_root_colors_inline_styles_string();
		if (!empty($flicker_colors_string)) :
			wp_add_inline_style(
				'flicker-login-page-style',
				wp_kses(
					':root{' . $flicker_colors_string . '}',
					false
				)
			);
		endif;
	}
endif;
add_action('login_enqueue_scripts', 'flicker_action_login_enqueue_static');

//customizer panel
if (!function_exists('flicker_customizer_js')) :
	function flicker_customizer_js()
	{
		wp_enqueue_style(
			'flicker-customizer-style',
			FLICKER_THEME_URI . '/assets/css/customizer.css',
			array(),
			FLICKER_THEME_VERSION
		);
		$min = !FLICKER_DEV_MODE ? 'min/' : '';
		wp_register_script(
			'flicker-customize-controls',
			FLICKER_THEME_URI . '/assets/js/' . $min . 'customize-controls.js',
			array(),
			FLICKER_THEME_VERSION,
			true
		);
		wp_localize_script('flicker-customize-controls', 'mwtGoogleFonts', flicker_get_google_fonts_array());

		//customizer redirect helpers
		$blog_url = get_post_type_archive_link('post');
		$post     = wp_get_recent_posts(
			array(
				'numberposts' => 1,
				'post_status' => 'publish',
			)
		);
		wp_reset_postdata();
		$post_url   = (!empty($post[0])) ? get_permalink($post[0]['ID']) : $blog_url;
		$search_url = home_url('/') . '?s=';
		$shop_url = esc_html(home_url('/'));
		$checkout_url = esc_html(home_url('/'));
		if (class_exists('WooCommerce')) {
			$shop_url = wc_get_page_permalink('shop');
			$checkout_url = wc_get_page_permalink('checkout');
		}
		wp_localize_script(
			'flicker-customize-controls',
			'flickerCustomizerObject',
			array(
				'homeUrl'     => esc_url_raw(home_url()),
				'blogUrl'     => esc_url_raw($blog_url),
				'postUrl'     => esc_url_raw($post_url),
				'searchUrl'   => esc_url_raw($search_url),
				'shopUrl'     => esc_url_raw($shop_url),
				'checkoutUrl' => esc_url_raw($checkout_url),
				'themeUrl'    => esc_url_raw(FLICKER_THEME_URI),
			)
		);

		wp_enqueue_script('flicker-customize-controls');

		wp_register_script(
			'vue-runtime',
			FLICKER_THEME_URI . '/assets/js/vendor/vue.min.js',
			array(),
			FLICKER_THEME_VERSION,
			true
		);
		wp_enqueue_script('vue-runtime');
	}
endif;
add_action('customize_controls_enqueue_scripts', 'flicker_customizer_js');

//admin styles
if (!function_exists('flicker_action_load_custom_wp_admin_style')) :
	function flicker_action_load_custom_wp_admin_style()
	{
		wp_register_style('flicker-custom-wp-admin-css', FLICKER_THEME_URI . '/assets/css/admin-backend.css', false, FLICKER_THEME_VERSION);
		wp_enqueue_style('flicker-custom-wp-admin-css');
		$flicker_colors_string = flicker_get_root_colors_inline_styles_string();
		if (!empty($flicker_colors_string)) :
			wp_add_inline_style(
				'flicker-custom-wp-admin-css',
				wp_kses(
					':root{' . $flicker_colors_string . '}',
					false
				)
			);
		endif;
	} //flicker_action_load_custom_wp_admin_style()
endif;
add_action('admin_enqueue_scripts', 'flicker_action_load_custom_wp_admin_style');

//comment_date
add_filter('get_comment_date', 'flicker_comment_date');
function flicker_comment_date($date)
{
	$date = date("F d, Y");
	return $date;
}

//demo content on remote hosting
/**
 * @param FW_Ext_Backups_Demo[] $demos
 *
 * @return FW_Ext_Backups_Demo[]
 */
if (!function_exists('flicker_filter_theme_fw_ext_backups_demos')) :

	function flicker_filter_theme_fw_ext_backups_demos($demos)
	{
		$secret_demo_id = FLICKER_REMOTE_DEMO_ID; // as example: '12345678'

		$demo_version_suffix = '-v' . FLICKER_REMOTE_DEMO_VERSION; // '-v1.0.0' (Only for main demo)
		if (class_exists('FW_Ext_Backups_Demo')) :
			$demos_array = array(
				'flicker-demo' . $demo_version_suffix => array(
					'title'        => esc_html__('Flicker Demo', 'flicker'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/flicker-v2/demo/screenshot.png'),
					'preview_link' => esc_url('//webdesign-finder.com/flicker-v2/'),
				),
			);

			// Demo ( Colorized )
			$demo_colorized_id = 'flicker-demo-colorized-' . $secret_demo_id;
			if ($secret_demo_id) {
				$demos_array[$demo_colorized_id] = array(
					'title'        => esc_html__('Flicker Demo (Colorized)', 'flicker'),
					'screenshot'   => esc_url('//webdesign-finder.com/remote-demo-content/flicker-v2/demo/screenshot.png'),
					'preview_link' => esc_url('//webdesign-finder.com/flicker-v2'),
				);
			}

			$download_url = esc_url('http://webdesign-finder.com/remote-demo-content/flicker-v2/demo/');

			foreach ($demos_array as $id => $data) {
				$demo = new FW_Ext_Backups_Demo($id, 'piecemeal', array(
					'url'     => $download_url,
					'file_id' => $id,
				));
				$demo->set_title($data['title']);
				$demo->set_screenshot($data['screenshot']);
				$demo->set_preview_link($data['preview_link']);

				$demos[$demo->get_id()] = $demo;

				unset($demo);
			}

			return $demos;

		endif; //class_exists
	} //flicker_filter_theme_fw_ext_backups_demos()
endif;
add_filter('fw:ext:backups-demo:demos', 'flicker_filter_theme_fw_ext_backups_demos');
