<?php

/**
 * Theme options
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//default values for customizer or other theme options
if (!function_exists('flicker_get_default_options_array')) :
    function flicker_get_default_options_array()
    {

        //fonts choises:
        // Open Sans
        // Open+Sans:300,300i,400,400i,600,600i,700,700i,800,800i&amp;subset=cyrillic,cyrillic-ext,greek,greek-ext,latin-ext,vietnamese
        // Roboto
        // Lato
        // Raleway
        // Montserrat
        // PT Sans
        // Source Sans Pro
        // Oswald
        // Lora
        // Work Sans

        return array(
            'demo_number' => '',
            'colorLight' => '#ffffff',
            'colorFont' => '#818181',
            'colorFontDark' => '#b2b2b2',
            'colorBackground' => '#f5f5f5',
            'colorBackgroundDark' => '#292929',
            'colorBorder' => '#e6e6e6',
            'colorBorderDark' => '#989898',
            'colorDark' => '#1a1a1a',
            'colorDarkGrey' => '#222222',
            'colorGrey' => '#f5f5f5',
            'colorMain' => '#dd4377',
            'colorMain2' => '#10316d',
            'colorMain3' => '#634255',
            'color_meta_icons' => 'meta-icons-main',
            'intro_block_heading' => '',
            'intro_position' => '',
            'intro_layout' => '',
            'intro_fullscreen' => '1',
            'intro_background' => 'i',
            'intro_background_image' => '',
            'intro_background_image_cover' => '1',
            'intro_background_image_fixed' => '',
            'intro_background_image_overlay' => '',
            'intro_image' => '',
            'intro_background_image_scale' => '',
            'intro_image_absolute' => '',
            'intro_image_animation' => '',
            'intro_pre_heading' => '',
            'intro_pre_heading_mt' => '',
            'intro_pre_heading_mb' => '',
            'intro_pre_heading_animation' => '',
            'intro_heading' => '',
            'intro_heading_mt' => '',
            'intro_heading_mb' => '',
            'intro_heading_animation' => '',
            'intro_description' => '',
            'intro_description_mt' => '',
            'intro_description_mb' => '',
            'intro_description_animation' => '',
            'intro_button_text_first' => '',
            'intro_button_url_first' => '',
            'intro_button_first_animation' => '',
            'intro_button_text_second' => '',
            'intro_button_url_second' => '',
            'intro_button_second_animation' => '',
            'intro_buttons_mt' => '',
            'intro_buttons_mb' => '',
            'intro_shortcode' => '',
            'intro_shortcode_mt' => '',
            'intro_shortcode_mb' => '',
            'intro_shortcode_animation' => '',
            'intro_alignment' => 'text-center',
            'intro_extra_padding_top' => '',
            'intro_extra_padding_bottom' => '',
            'intro_social_links' => '1',
            'intro_font_size' => 'fs-20',
            'logo_image_inverse' => '',
            'logo' => '1',
            'logo_primary_text' => 'Flicker',
            'logo_text_secondary' => '',
            'header_top_tall' => '',
            'logo_background' => '',
            'logo_padding_horizontal' => '',
            'preset' => '',
            'main_container_width' => '1170',
            'blog_container_width' => '',
            'blog_single_container_width' => '',
            'boxed' => '',
            'preloader' => 'cover',
            'box_fade_in' => '1',
            'totop' => '1',
            'assets_min' => '',
            'jquery_to_footer' => '',
            'meta_email' => 'rachel_fan@example.com',
            'meta_email_label' => '',
            'meta_phone' => '1-888-652-2588',
            'meta_phone_label' => '',
            'meta_website' => 'https://www.rachelsalverz.com',
            'meta_website_label' => '',
            'meta_address' => '140 Horizon Circle, New York, California',
            'meta_address_label' => '',
            'meta_opening_hours' => '',
            'meta_opening_hours_label' => '',
            'meta_facebook' => '#',
            'meta_twitter' => '#',
            'meta_instagram' => '#',
            'meta_linkedin' => '',
            'meta_youtube' => '#',
            'meta_pinterest' => '',
            'meta_github' => '',
            'header_image_background_image_cover' => '',
            'header_image_background_image_fixed' => '',
            'header_image_background_image_overlay' => '',
            'header' => '1',
            'header_fluid' => '1',
            'header_background' => 'i',
            'header_background_image' => '',
            'header_background_image_cover' => '1',
            'header_background_image_fixed' => '',
            'header_background_image_overlay' => '',
            'header_toplogo' => '',
            'header_toplogo_background' => 'l',
            'header_toplogo_font_size' => '',
            'header_meta' => '1',
            'header_align_main_menu' => 'menu-center',
            'header_toggler_menu_main' => '1',
            'header_absolute_home_page' => '',
            'header_absolute' => '',
            'header_transparent' => '',
            'header_border_top' => '',
            'header_border_bottom' => '',
            'header_font_size' => 'fs-14',
            'header_sticky' => 'always-sticky',
            'header_button_text' => 'Buy Tickets',
            'header_button_url' => '',
            'header_topline_options_heading' => '',
            'topline' => '2',
            'topline_fluid' => '1',
            'topline_background' => 'i',
            'topline_font_size' => 'fs-14',
            'topline_meta_address' => '',
            'topline_meta_phone' => '1',
            'topline_meta_mail' => '1',
            'topline_meta_opening_hours' => '',
            'header_search' => 'button2',
            'title' => '3',
            'title_fluid' => '',
            'title_show_title' => '1',
            'title_show_breadcrumbs' => '1',
            'title_background' => 'l',
            'title_border_top' => '',
            'title_border_bottom' => '',
            'title_extra_padding_top' => '',
            'title_extra_padding_bottom' => '',
            'title_font_size' => 'fs-12',
            'title_hide_taxonomy_name' => '1',
            'title_background_image' => '',
            'title_background_image_cover' => '1',
            'title_background_image_fixed' => '',
            'title_background_image_overlay' => '',
            'main_sidebar_width' => '30',
            'main_gap_width' => '3',
            'main_sidebar_margin_right' => '80',
            'main_sidebar_sticky' => '',
            'main_extra_padding_top' => '',
            'main_extra_padding_bottom' => '',
            'main_font_size' => 'fs-16',
            'sidebar_font_size' => '',
            'main_version' => 'i m',
            '404_heading' => '',
            '404_text_bottom_line' => '',
            '404_background' => 'i',
            '404_background_image' => '',
            '404_background_image_overlay' => '',
            '404_extra_padding_top' => 'pt-8',
            '404_extra_padding_bottom' => 'pb-11',
            'footer_top' => '2',
            'footer_top_fluid' => '',
            'footer_top_subtitle_top' => '',
            'footer_top_subtitle' => '',
            'footer_top_subtitle_mt' => '',
            'footer_top_subtitle_mb' => '',
            'footer_top_subtitle_animation' => '',
            'footer_top_heading' => '',
            'footer_top_heading_mt' => '',
            'footer_top_heading_mb' => '',
            'footer_top_heading_animation' => '',
            'footer_top_description' => '',
            'footer_top_description_mt' => '',
            'footer_top_description_mb' => '',
            'footer_top_description_animation' => '',
            'footer_top_shortcode' => '',
            'footer_top_shortcode_mt' => '',
            'footer_top_shortcode_mb' => '',
            'footer_top_shortcode_animation' => '',
            'footer_top_background' => 'i',
            'footer_top_border_top' => '',
            'footer_top_border_bottom' => '',
            'footer_top_extra_padding_top' => 'pt-10',
            'footer_top_extra_padding_bottom' => 'pb-10',
            'footer_top_font_size' => 'fs-16',
            'footer_top_background_image' => '',
            'footer_top_background_image_cover' => '1',
            'footer_top_background_image_fixed' => '',
            'footer_top_background_image_overlay' => '',
            'footer' => '1',
            'footer_layout_gap' => '50',
            'footer_fluid' => '',
            'footer_background' => 'i',
            'footer_border_top' => 'full',
            'footer_border_bottom' => '',
            'footer_extra_padding_top' => '',
            'footer_extra_padding_bottom' => '',
            'footer_font_size' => 'fs-16',
            'footer_background_image' => '',
            'footer_background_image_cover' => '',
            'footer_background_image_fixed' => '',
            'footer_background_image_overlay' => '',
            'copyright' => '6',
            'copyright_text' => '© Copyright [year] All Rights Reserved',
            'copyright_fluid' => '',
            'copyright_background' => 'i m',
            'copyright_extra_padding_top' => '',
            'copyright_extra_padding_bottom' => '',
            'copyright_font_size' => 'fs-16',
            'copyright_background_image' => '',
            'copyright_background_image_cover' => '',
            'copyright_background_image_fixed' => '',
            'copyright_background_image_overlay' => '',
            'font_body_heading' => '',
            'font_body' => '{"font":"Lato","variant":["100","100italic","300","300italic","regular","italic","700","700italic","900","900italic"],"subset":["latin-ext","latin"]}',
            'font_headings_heading' => '',
            'font_headings' => '{"font":"Changa","variant":["200","300","regular","500","600","700","800"],"subset":["latin-ext","latin"]}',
            'blog_layout' => '',
            'blog_layout_gap' => '50',
            'blog_sidebar_position' => 'right',
            'blog_page_name' => 'News',
            'blog_show_full_text' => '',
            'blog_excerpt_length' => '50',
            'blog_read_more_text' => 'Read More',
            'blog_hide_taxonomy_type_name' => '1',
            'blog_meta_options_heading' => '',
            'blog_hide_meta_icons' => '1',
            'blog_show_author' => '1',
            'blog_show_author_avatar' => '',
            'blog_before_author_word' => 'By:',
            'blog_show_date' => '1',
            'blog_before_date_word' => '',
            'blog_show_categories' => '1',
            'blog_before_categories_word' => '',
            'blog_show_tags' => '',
            'blog_before_tags_word' => '',
            'blog_show_views' => '',
            'blog_before_views_word' => '',
            'blog_show_likes' => '',
            'blog_before_likes_word' => '',
            'blog_show_comments_link' => 'text',
            'blog_share_options_heading' => '',
            'blog_share_facebook' => '',
            'blog_share_twitter' => '',
            'blog_share_telegram' => '',
            'blog_share_pinterest' => '',
            'blog_share_linkedin' => '',
            'blog_single_sidebar_position' => 'no',
            'blog_single_show_author_bio' => '',
            'blog_single_author_bio_about_word' => 'Author',
            'blog_single_post_nav_heading' => '',
            'blog_single_post_nav' => 'arrow',
            'blog_single_post_nav_word_prev' => 'Previous post',
            'blog_single_post_nav_word_next' => 'Next post',
            'blog_single_related_posts_heading' => '',
            'blog_single_related_posts' => 'grid',
            'blog_single_related_posts_title' => 'Related Posts',
            'blog_single_related_posts_number' => '3',
            'blog_single_meta_options_heading' => '',
            'blog_single_hide_meta_icons' => '1',
            'blog_single_show_author' => '',
            'blog_single_show_author_avatar' => '',
            'blog_single_before_author_word' => 'By:',
            'blog_single_show_date' => '',
            'blog_single_before_date_word' => '',
            'blog_single_show_categories' => '1',
            'blog_single_before_categories_word' => '',
            'blog_single_show_tags' => '1',
            'blog_single_before_tags_word' => '',
            'blog_single_show_views' => '',
            'blog_single_before_views_word' => '',
            'blog_single_show_likes' => '',
            'blog_single_show_comments_link' => 'text',
            'blog_single_comments_title_reply' => '',
            'blog_single_share_options_heading' => '',
            'blog_single_share_facebook' => '',
            'blog_single_share_twitter' => '',
            'blog_single_share_telegram' => '',
            'blog_single_share_pinterest' => '',
            'blog_single_share_linkedin' => '',
            'animation_enabled' => '1',
            'animation_sidebar_widgets' => '',
            'animation_footer_top_widgets' => '',
            'animation_footer_widgets' => '',
            'animation_feed_posts' => '',
            'animation_feed_posts_thumbnail' => '',
            'shop_sidebar_position' => 'left',
            'product_sidebar_position' => 'no',
            'header_cart_dropdown' => '1',
            'product_simple_add_to_cart_hide_button' => '',
            'product_show_category' => '',
            'product_show_rating' => '1',
            'product_show_short_description' => '1',
            'product_show_thumbnail_add_to_cart' => '',
            'product_show_cart_thumbnail_link' => '',
            'product_share_facebook' => '1',
            'product_share_twitter' => '',
            'product_share_telegram' => '',
            'product_share_pinterest' => '1',
            'product_share_linkedin' => '',
        );
    }
endif;

//get theme option from default or from customizer
if (!function_exists('flicker_option')) :
    function flicker_option($flicker_option_name, $flicker_default_value = '')
    {
        //get theme defaults
        $flicker_defaults = flicker_get_default_options_array();

        //lowest priority is basic default value from theme defaults
        $flicker_return = (!empty($flicker_defaults[$flicker_option_name])) ? $flicker_defaults[$flicker_option_name] : $flicker_default_value;

        unset($flicker_defaults);

        //theme_mods are higher - if not empty - overriding value from theme default
        $flicker_return = get_theme_mod($flicker_option_name, $flicker_return);

        if (isset($_GET[$flicker_option_name])) {
            $flicker_return = sanitize_text_field($_GET[$flicker_option_name]);
        }

        return $flicker_return;
    }
endif;

//layout options array. Used global in customizer and for categories
if (!function_exists('flicker_get_feed_layout_options')) :
    function flicker_get_feed_layout_options($flicker_category = false)
    {
        if (empty($flicker_category)) {
            $flicker_first_element = esc_html__('Default - Top featured image', 'flicker');
        } else {
            $flicker_first_element = esc_html__('Inherit from Customizer settings', 'flicker');
        }

        $flicker_return = apply_filters(
            'flicker_feed_layout_options',
            array(
                ''                                => $flicker_first_element,
                'cols 3 masonry'               => esc_html__('Grid', 'flicker'),
            )
        );

        return $flicker_return;
    }
endif;

//gap options array. Used global in customizer and for categories
if (!function_exists('flicker_get_feed_layout_gap_options')) :
    function flicker_get_feed_layout_gap_options($flicker_category = false)
    {
        if (empty($flicker_category)) {
            $flicker_first_element = esc_html__('Default - none', 'flicker');
        } else {
            $flicker_first_element = esc_html__('Inherit from Customizer settings', 'flicker');
        }

        $flicker_return = apply_filters(
            'flicker_feed_layout_gap_options',
            array(
                ''   => $flicker_first_element,
                '1'  => esc_html__('1px', 'flicker'),
                '2'  => esc_html__('2px', 'flicker'),
                '3'  => esc_html__('3px', 'flicker'),
                '4'  => esc_html__('4px', 'flicker'),
                '5'  => esc_html__('5px', 'flicker'),
                '10' => esc_html__('10px', 'flicker'),
                '15' => esc_html__('15px', 'flicker'),
                '20' => esc_html__('20px', 'flicker'),
                '30' => esc_html__('30px', 'flicker'),
                '40' => esc_html__('40px', 'flicker'),
                '50' => esc_html__('50px', 'flicker'),
                '60' => esc_html__('60px', 'flicker'),
            )
        );

        return $flicker_return;
    }
endif;


//layout options array. Used global in customizer and for single posts
if (!function_exists('flicker_get_post_layout_options')) :
    function flicker_get_post_layout_options($flicker_category = false)
    {
        if (empty($flicker_category)) {
            $flicker_first_element = esc_html__('Default - top featured image', 'flicker');
        } else {
            $flicker_first_element = esc_html__('Inherit from Customizer settings', 'flicker');
        }

        $flicker_return = apply_filters(
            'flicker_post_layout_options',
            array(
                ''                    => $flicker_first_element,
                'wide-image'          => esc_html__('Wide featured image', 'flicker'),
                'meta-top'            => esc_html__('Post meta above featured image', 'flicker'),
                'meta-image'          => esc_html__('Post meta on featured image', 'flicker'),
                'meta-side'           => esc_html__('Side post meta', 'flicker'),
                'bottom-meta'         => esc_html__('Bottom post meta', 'flicker'),
                'title-section-image' => esc_html__('Title section featured image', 'flicker'),
            )
        );

        return $flicker_return;
    }
endif;


//sidebar options array. Used global in customizer and for categories
if (!function_exists('flicker_get_sidebar_position_options')) :
    function flicker_get_sidebar_position_options($flicker_category = false)
    {
        if (empty($flicker_category)) {
            $flicker_first_element = esc_html__('Default', 'flicker');
        } else {
            $flicker_first_element = esc_html__('Inherit from Customizer settings', 'flicker');
        }

        $flicker_return = array(
            'right' => esc_html__('Right sidebar', 'flicker'),
            'left'  => esc_html__('Left sidebar', 'flicker'),
            'no'    => esc_html__('No sidebar', 'flicker'),
        );

        if ($flicker_category) {
            $flicker_return = array($flicker_first_element) + $flicker_return;
        }

        return $flicker_return;
    }
endif;

//animation options array.
if (!function_exists('flicker_get_animation_options')) :
    function flicker_get_animation_options()
    {

        $flicker_return = array(
            ''             => esc_html__('None', 'flicker'),
            'bounce'       => esc_html__('bounce', 'flicker'),
            'flash'        => esc_html__('flash', 'flicker'),
            'pulse'        => esc_html__('pulse', 'flicker'),
            'rubberBand'   => esc_html__('rubberBand', 'flicker'),
            'shake'        => esc_html__('shake', 'flicker'),
            'headShake'    => esc_html__('headShake', 'flicker'),
            'swing'        => esc_html__('swing', 'flicker'),
            'tada'         => esc_html__('tada', 'flicker'),
            'wobble'       => esc_html__('wobble', 'flicker'),
            'jello'        => esc_html__('jello', 'flicker'),
            'heartBeat'    => esc_html__('heartBeat', 'flicker'),
            'bounceIn'     => esc_html__('bounceIn', 'flicker'),
            'fadeInFlicker'       => esc_html__('fadeIn', 'flicker'),
            'fadeInDown'   => esc_html__('fadeInDown', 'flicker'),
            'fadeInLeft'   => esc_html__('fadeInLeft', 'flicker'),
            'fadeInRight'  => esc_html__('fadeInRight', 'flicker'),
            'fadeInUp'     => esc_html__('fadeInUp', 'flicker'),
            'flip'         => esc_html__('flip', 'flicker'),
            'flipInX'      => esc_html__('flipInX', 'flicker'),
            'flipInY'      => esc_html__('flipInY', 'flicker'),
            'lightSpeedIn' => esc_html__('lightSpeedIn', 'flicker'),
            'jackInTheBox' => esc_html__('jackInTheBox', 'flicker'),
            'zoomIn'       => esc_html__('zoomIn', 'flicker'),
        );

        return $flicker_return;
    }
endif;

if (!class_exists('Flicker_Color')) {
    class Flicker_Color
    {
        public $hex;
        public $rgb;
        public $hsl;

        public function __construct($hex)
        {
            $hex = str_replace("#", "", $hex);
            $this->hex = $hex;
            $this->rgb = $this->hexToRgb($this->hex);
            $this->hsl = $this->toHSL($this->rgb);
        }
        public function back()
        {
            $this->rgb = $this->HSLtoRGB($this->hsl);
            $this->hex = $this->rgb2hex($this->rgb);
        }
        public function adjust_hue($newVal)
        {
            $this->hsl[0] += $newVal;
            $this->back();
        }
        public function saturate($newVal)
        {
            $this->hsl[1] += $newVal;
            $this->back();
        }
        public function desaturate($newVal)
        {
            $this->hsl[1] -= $newVal;
            $this->back();
        }
        public function lighten($newVal)
        {
            $this->hsl[2] += $newVal;
            $this->back();
        }
        public function darken($newVal)
        {
            $this->hsl[2] -= $newVal;
            $this->back();
        }
        public function get_all()
        {
            return array(
                'hex' => $this->hex,
                'rgb' => $this->rgb,
                'hls' => $this->hsl,
            );
        }
        public function hexToRgb($hex)
        {
            if (strlen($hex) == 3) {
                $r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
                $g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
                $b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
            } else {
                $r = hexdec(substr($hex, 0, 2));
                $g = hexdec(substr($hex, 2, 2));
                $b = hexdec(substr($hex, 4, 2));
            }
            $rgb = array($r, $g, $b);
            return $rgb; // returns an array with the rgb values
        }
        public function rgbString()
        {
            return implode(", ", $this->rgb);
        }
        public function toHSL($rgb)
        {
            $red = $rgb[0];
            $green = $rgb[1];
            $blue = $rgb[2];
            $max = max($red, $green, $blue);
            $min = min($red, $green, $blue);

            $lightness = $max + $min;

            if ($max === $min) {
                $saturation = $hue = 0;
            } else {
                $diff = $max - $min;

                if ($lightness < 255) $saturation = $diff / $lightness;
                else $saturation = $diff / (510 - $lightness);

                if ($max === $red) $hue = 60 * ($green - $blue) / $diff;
                elseif ($max === $green) $hue = 60 * ($blue - $red) / $diff + 120;
                elseif ($max === $blue) $hue = 60 * ($red - $green) / $diff + 240;
            }

            return array(fmod($hue, 360), $saturation * 100, $lightness / 5.1);
        }
        public function hueToRGB($p, $q, $decHue)
        {
            if ($decHue < 0) $decHue += 1;
            else if ($decHue > 1) $decHue -= 1;

            if ($decHue * 6 < 1) return $p + ($q - $p) * $decHue * 6;
            if ($decHue * 2 < 1) return $q;
            if ($decHue * 3 < 2) return $p + ($q - $p) * (2 / 3 - $decHue) * 6;

            return $p;
        }
        // hue from 0 to 360, saturation and lightness from 0 to 100
        public function HSLtoRGB($hsl)
        {
            $hue = $hsl[0];
            $saturation = $hsl[1];
            $lightness = $hsl[2];
            if ($hue < 0) $hue += 360;

            $decHue = $hue / 360;
            $decSaturation = min(100, max(0, $saturation)) / 100;
            $decLightness = min(100, max(0, $lightness)) / 100;

            $q = $decLightness <= 0.5 ? $decLightness * ($decSaturation + 1) : $decLightness + $decSaturation - $decLightness * $decSaturation;
            $p = $decLightness * 2 - $q;

            $red = $this->hueToRGB($p, $q, $decHue + 1 / 3) * 255;
            $green = $this->hueToRGB($p, $q, $decHue) * 255;
            $blue = $this->hueToRGB($p, $q, $decHue - 1 / 3) * 255;

            return array(round($red), round($green), round($blue));
        }
        function rgb2hex($rgb)
        {
            $hex = '';
            $hex .= str_pad(dechex($rgb[0]), 2, "0", STR_PAD_LEFT);
            $hex .= str_pad(dechex($rgb[1]), 2, "0", STR_PAD_LEFT);
            $hex .= str_pad(dechex($rgb[2]), 2, "0", STR_PAD_LEFT);

            return $hex; // returns the hex value including the number sign (#)
        }
    }
}

if (!function_exists('sanitize_rgba_color')) {
    function sanitize_rgba_color($color)
    {
        if (empty($color) || is_array($color)) {
            return 'rgba(0,0,0,0)';
        }

        // If string does not start with 'rgba', then treat as hex
        // sanitize the hex color and finally convert hex to rgba
        if (false === strpos($color, 'rgba')) {
            return sanitize_hex_color($color);
        }

        // By now we know the string is formatted as an rgba color so we need to further sanitize it.
        $color = str_replace(' ', '', $color);
        sscanf($color, 'rgba(%d,%d,%d,%f)', $red, $green, $blue, $alpha);

        return 'rgba(' . $red . ',' . $green . ',' . $blue . ',' . $alpha . ')';
    }
}

//get :root colors inline styles string
if (!function_exists('flicker_get_root_colors_inline_styles_string')) :
    function flicker_get_root_colors_inline_styles_string()
    {
        //colors
        $flicker_colors_string = '';
        // colorLight
        // colorFont
        // colorFontDark
        // colorBackground
        // colorBackgroundDark
        // colorBorder
        // colorBorderDark
        // colorDark
        // colorDarkGrey
        // colorGrey
        // colorMain
        // colorMain2
        // colorMain3

        $flicker_colors_string .= flicker_option('colorLight', '') ? '--colorLight:' . sanitize_hex_color(flicker_option('colorLight', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorFont', '') ? '--colorFont:' . sanitize_hex_color(flicker_option('colorFont', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorFontDark', '') ? '--colorFontDark:' . sanitize_hex_color(flicker_option('colorFontDark', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorBackground', '') ? '--colorBackground:' . sanitize_hex_color(flicker_option('colorBackground', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorBackgroundDark', '') ? '--colorBackgroundDark:' . sanitize_hex_color(flicker_option('colorBackgroundDark', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorBorder', '') ? '--colorBorder:' . sanitize_hex_color(flicker_option('colorBorder', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorBorderDark', '') ? '--colorBorderDark:' . sanitize_hex_color(flicker_option('colorBorderDark', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorDark', '') ? '--colorDark:' . sanitize_hex_color(flicker_option('colorDark', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorDarkGrey', '') ? '--colorDarkGrey:' . sanitize_hex_color(flicker_option('colorDarkGrey', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorGrey', '') ? '--colorGrey:' . sanitize_hex_color(flicker_option('colorGrey', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorMain', '') ? '--colorMain:' . sanitize_hex_color(flicker_option('colorMain', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorMain2', '') ? '--colorMain2:' . sanitize_hex_color(flicker_option('colorMain2', '')) . ';' : '';
        $flicker_colors_string .= flicker_option('colorMain3', '') ? '--colorMain3:' . sanitize_hex_color(flicker_option('colorMain3', '')) . ';' : '';

        //RGB Colors
        // colorMainRGB
        $colorMainRGB = new Flicker_Color(flicker_option('colorMain', ''));
        $colorMainRGB = $colorMainRGB->rgbString();
        $flicker_colors_string .= '--colorMainRGB:' . $colorMainRGB . ';';

        // colorMain2RGB
        $colorMain2RGB = new Flicker_Color(flicker_option('colorMain2', ''));
        $colorMain2RGB = $colorMain2RGB->rgbString();
        $flicker_colors_string .= '--colorMain2RGB:' . $colorMain2RGB . ';';

        // colorMain3RGB
        $colorMain3RGB = new Flicker_Color(flicker_option('colorMain3', ''));
        $colorMain3RGB = $colorMain3RGB->rgbString();
        $flicker_colors_string .= '--colorMain3RGB:' . $colorMain3RGB . ';';

        // colorFontRGB
        $colorFontRGB = new Flicker_Color(flicker_option('colorFont', ''));
        $colorFontRGB = $colorFontRGB->rgbString();
        $flicker_colors_string .= '--colorFontRGB:' . $colorFontRGB . ';';

        // colorFontDarkRGB
        $colorFontDarkRGB = new Flicker_Color(flicker_option('colorFontDark', ''));
        $colorFontDarkRGB = $colorFontDarkRGB->rgbString();
        $flicker_colors_string .= '--colorFontDarkRGB:' . $colorFontDarkRGB . ';';

        // colorDarkGreyRGB
        $colorDarkGreyRGB = new Flicker_Color(flicker_option('colorDarkGrey', ''));
        $colorDarkGreyRGB = $colorDarkGreyRGB->rgbString();
        $flicker_colors_string .= '--colorDarkGreyRGB:' . $colorDarkGreyRGB . ';';

        // colorGreyRGB
        $colorGreyRGB = new Flicker_Color(flicker_option('colorGrey', ''));
        $colorGreyRGB = $colorGreyRGB->rgbString();
        $flicker_colors_string .= '--colorGreyRGB:' . $colorGreyRGB . ';';

        // colorDarkRGB
        $colorDarkRGB = new Flicker_Color(flicker_option('colorDark', ''));
        $colorDarkRGB = $colorDarkRGB->rgbString();
        $flicker_colors_string .= '--colorDarkRGB:' . $colorDarkRGB . ';';

        // colorLightRGB
        $colorLightRGB = new Flicker_Color(flicker_option('colorLight', ''));
        $colorLightRGB = $colorLightRGB->rgbString();
        $flicker_colors_string .= '--colorLightRGB:' . $colorLightRGB . ';';

        // colorBackgroundRGB
        $colorBackgroundRGB = new Flicker_Color(flicker_option('colorBackground', ''));
        $colorBackgroundRGB = $colorBackgroundRGB->rgbString();
        $flicker_colors_string .= '--colorBackgroundRGB:' . $colorBackgroundRGB . ';';

        // colorBackgroundDarkRGB
        $colorBackgroundDarkRGB = new Flicker_Color(flicker_option('colorBackgroundDark', ''));
        $colorBackgroundDarkRGB = $colorBackgroundDarkRGB->rgbString();
        $flicker_colors_string .= '--colorBackgroundDarkRGB:' . $colorBackgroundDarkRGB . ';';

        // colorBorderRGB
        $colorBorderRGB = new Flicker_Color(flicker_option('colorBorder', ''));
        $colorBorderRGB = $colorBorderRGB->rgbString();
        $flicker_colors_string .= '--colorBorderRGB:' . $colorBorderRGB . ';';

        // colorBorderDarkRGB
        $colorBorderDarkRGB = new Flicker_Color(flicker_option('colorBorderDark', ''));
        $colorBorderDarkRGB = $colorBorderDarkRGB->rgbString();
        $flicker_colors_string .= '--colorBorderDarkRGB:' . $colorBorderDarkRGB . ';';

        // font
        $fontBody       = '';
        $fontSecondary   = '';

        $seedone_font_body     = json_decode(flicker_option('font_body', '{"font":"","variant": [],"subset":[]}'));
        $seedone_font_secondary = json_decode(flicker_option('font_headings', '{"font":"","variant": [],"subset":[]}'));

        $seedone_font_body_font = '';
        if (!empty($seedone_font_body->font)) {
            $seedone_font_body_font = $seedone_font_body->font;
        }
        $fontBody = "--fontBody: \"{$seedone_font_body_font}\" !important;";

        $seedone_font_secondary_font = '';
        if (!empty($seedone_font_secondary->font)) {
            $seedone_font_secondary_font = $seedone_font_secondary->font;
        }
        $fontSecondary = "--fontSecondary: \"{$seedone_font_secondary_font}\" !important;";

        $flicker_colors_string .= $fontBody;
        $flicker_colors_string .= $fontSecondary;

        return $flicker_colors_string;
    }
endif;
