<?php

/**
 * The 404 page template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_404_heading          = flicker_option('404_heading', '');
$flicker_404_text_bottom_line = flicker_option('404_text_bottom_line', '');
$flicker_background           = flicker_option('404_background', '');
$flicker_background_image     = flicker_option('404_background_image', '');
$flicker_overlay 		       = flicker_option('404_background_image_overlay', '');

$flicker_extra_padding_top    = flicker_option('404_extra_padding_top', '');
$flicker_extra_padding_bottom = flicker_option('404_extra_padding_bottom', '');

if (!empty($flicker_overlay)) {
	$flicker_overlay = ' background-overlay ' . $flicker_overlay;
}

get_header();

?>
<div id="main" class="main section-404 <?php echo esc_attr($flicker_background . ' background-cover cover-center ' . $flicker_overlay); ?>" <?php echo (!empty($flicker_background_image)) ? 'style="background-image: url(' . esc_url($flicker_background_image) . ');"' : ''; ?>>
	<div class="container <?php echo esc_attr($flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
		<main>
			<div id="layout" class="text-center">
				<div class="content-wrap">
					<h2 class="text-404">
						<?php echo (!empty($flicker_404_heading)) ? esc_html($flicker_404_heading) : esc_html_e("404", 'flicker'); ?>
					</h2>
					<h3>
						<?php echo (!empty($flicker_404_text_bottom_line)) ? esc_html($flicker_404_text_bottom_line) : esc_html_e("Oops, page not found!", 'flicker'); ?>
					</h3>
					<p>
						<?php esc_html_e('You can search what interested:', 'flicker'); ?>
					</p>
					<div class="widget widget_search">
						<?php get_search_form(); ?>
					</div>
					<p class="topmargin_20">
						<?php esc_html_e('or', 'flicker'); ?>
					</p>
					<a href="<?php echo get_home_url(); ?>" class="theme_button color1 min_width_button">
						<?php esc_html_e('Back To Homepage', 'flicker'); ?>
					</a>
				</div><!--eof #content-wrap -->
			</div><!-- #layout -->
		</main>
	</div><!-- .container -->
</div><!-- #main -->
<?php
get_footer();
