<?php

/**
 * The title section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_fluid             = flicker_option('title_fluid') ? '-fluid' : '';
$flicker_show_title       = flicker_option('title_show_title', '');
$flicker_show_breadcrumbs = flicker_breadcrumbs_enabled();

$flicker_title_background     = flicker_option('title_background', '');
$flicker_extra_padding_top    = flicker_option('title_extra_padding_top', '');
$flicker_extra_padding_bottom = flicker_option('title_extra_padding_bottom', '');
$flicker_border_top           = flicker_option('title_border_top', '');
$flicker_border_bottom        = flicker_option('title_border_bottom', '');
$flicker_font_size            = flicker_option('title_font_size', '');
$flicker_background_image     = flicker_section_background_image_array('title');

?>
<section id="title" class="title title-6 title-inline <?php echo esc_attr($flicker_title_background . ' ' . $flicker_font_size . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
	<?php
	if ('full' === $flicker_border_top) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<div class="container<?php echo esc_attr($flicker_fluid); ?> <?php echo esc_attr($flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
		<?php
		if ('container' === $flicker_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		if (!empty($flicker_show_title)) {
		?>
			<h1 itemprop="headline"><?php get_template_part('template-parts/title/title-text'); ?></h1>
		<?php
		} //show_title
		if (!empty($flicker_show_breadcrumbs)) {
			flicker_breadcrumbs();
		}
		if ('container' === $flicker_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
	</div><!-- .container -->
	<?php
	if ('full' === $flicker_border_bottom) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
</section><!-- #title -->