<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//meta
$flicker_meta                 = flicker_get_theme_meta();

$flicker_fluid                = flicker_option('topline_fluid') ? '-fluid' : '';
$flicker_topline_background   = flicker_option('topline_background', '');
$flicker_font_size            = flicker_option('topline_font_size', '');

$flicker_topline_link_1       = flicker_option('topline_link_1');
$flicker_topline_link_1_URL   = flicker_option('topline_link_1_url');
$flicker_topline_link_2       = flicker_option('topline_link_2');
$flicker_topline_link_2_URL   = flicker_option('topline_link_2_url');

?>
<div id="topline" class="topline topline-2 <?php echo esc_attr($flicker_topline_background . ' ' . $flicker_font_size); ?>">
    <div class="container<?php echo esc_attr($flicker_fluid); ?>">
        <?php if (
            !empty(flicker_option('meta_facebook'))
            ||
            !empty(flicker_option('meta_twitter'))
            ||
            !empty(flicker_option('meta_instagram'))
            ||
            !empty(flicker_option('meta_linkedin'))
            ||
            !empty(flicker_option('meta_youtube'))
            ||
            !empty(flicker_option('meta_pinterest'))
            ||
            !empty(flicker_option('meta_github'))
        ) { ?>
            <div class="social-links-wrap greylinks">
                <span class="small-text"><?php echo esc_html('follow us:', 'flicker'); ?></span>
                <?php flicker_social_links(); ?>
            </div>
        <?php }; ?>
        <div class="inline-content greylinks">
            <?php if (class_exists('WooCommerce')) : ?>
                <div class="small-text">
                    <?php if (!is_user_logged_in()) : ?>
                        <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>"><?php echo esc_html__('Login / Register', 'flicker'); ?>
                        </a>
                    <?php else : ?>
                        <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_myaccount_page_id'))); ?>"><?php echo esc_html__('My account', 'flicker'); ?>
                        </a>
                    <?php endif; ?>
                </div>
                <div>
                    <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="cart-button">
                        <?php if (WC()->cart->get_cart_contents_count()) : ?>
                            <i class="fa fa-shopping-basket" aria-hidden="true"></i>
                        <?php
                            echo '<span class="total-price">' . WC()->cart->get_cart_subtotal() . '</span>';
                        else : ?>
                            <i class="fa fa-shopping-basket empty" aria-hidden="true"></i>
                        <?php endif; ?>
                    </a>
                </div>
            <?php endif; ?>
            <?php
            get_template_part('template-parts/header/header-search');
            ?>
        </div>
    </div><!-- .container -->
</div><!-- #topline -->