<?php

/**
 * The logo template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$args = !empty($args) ? $args : array();
$div = !empty($args['div']) ? 'div' : 'a';

$flicker_custom_logo         = flicker_option('custom_logo');
$flicker_logo_white          = (!empty(flicker_option('logo_image_inverse'))) ? flicker_option('logo_image_inverse') : '';
$flicker_logo_image_class    = (!empty($flicker_custom_logo) || !empty($flicker_logo_white)) ? 'with-image' : 'no-image';
$flicker_logo_text_primary   = flicker_option('logo_primary_text');
$flicker_logo_text_secondary = flicker_option('logo_text_secondary');
$flicker_logo_background     = flicker_option('logo_background');
$flicker_logo_x_padding      = flicker_option('logo_padding_horizontal');
$flicker_logo_padding_class  = (!empty($flicker_logo_x_padding)) ? 'px' : '';

//if no text - get blog name for primary text
if (empty($flicker_logo_text_primary) && empty($flicker_logo_text_secondary) && empty($flicker_custom_logo)) {
	$flicker_logo_text_primary = get_bloginfo('name');
}
?>
<<?php echo esc_html($div); ?> class="logo logo-between <?php echo esc_attr($flicker_logo_image_class . ' ' . $flicker_logo_background . ' ' . $flicker_logo_padding_class); ?>" href="<?php echo esc_url(home_url('/')); ?>" rel="home" itemprop="url">
	<?php if (!empty($flicker_logo_text_primary)) : ?>
		<span class="logo-text-primary">
			<?php echo wp_kses_post($flicker_logo_text_primary); ?>
		</span><!-- .logo-text-primary -->
		<?php
	endif;

	//image
	if (flicker_option('header_background') === 'l' || flicker_option('header_background') === 'l m' || flicker_option('header_background') === '') :
		echo wp_get_attachment_image($flicker_custom_logo, 'full');
	else :
		if (!empty($flicker_logo_white)) :
		?>
			<img src="<?php echo esc_url($flicker_logo_white); ?>" alt="<?php esc_attr_e('white logo', 'flicker'); ?>">
		<?php
		endif; //logo_white
	endif; //image
	if (!empty($flicker_logo_text_secondary)) :
		?>
		<span class="logo-text-secondary">
			<?php echo wp_kses_post($flicker_logo_text_secondary); ?>
		</span><!-- .logo-text-secondary -->
	<?php endif; ?>
</<?php echo esc_html($div); ?>><!-- .logo -->