<?php

/**
 * The header search template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_search = flicker_option('header_search', '');
//button
$flicker_button_text    = flicker_option('header_button_text', '');
$flicker_button_url     = flicker_option('header_button_url', '');



if (empty($flicker_search)) {
	return;
}

switch ($flicker_search):
	case 'button':
?>
		<div class="header-search">
			<button id="search_toggle" aria-controls="search_dropdown" aria-expanded="false" aria-label="<?php esc_attr_e('Search Dropdown Toggler', 'flicker'); ?>">
				<?php
				flicker_icon('magnify');
				?>
			</button>
		</div><!-- .header-search -->
	<?php
		break;

	case 'button2':
	?>
	
		<div class="header-search">
			<div class="dropdown">
				<button id="search_toggle_topline" aria-controls="search_toggle_topline" aria-expanded="false" aria-label="<?php esc_attr_e('Search Dropdown Toggler', 'flicker'); ?>">
					<?php flicker_icon('magnify'); ?>
				</button>
				<div id="search_dropdown_topline">
					<?php get_search_form(); ?>
				</div><!-- #search_dropdown -->
				<button id="search_modal_close_topline" class="search-btn" aria-controls="search_dropdown_topline" aria-expanded="true" aria-label="<?php esc_attr_e('Search Toggler', 'flicker'); ?>">
					<span></span>
				</button>
			</div>
		</div><!-- .header-search -->
		<?php
            if ($flicker_button_text) : ?>
                <div class="btn-wrap">
                    <a href="<?php echo esc_attr($flicker_button_url) ?>" target="_self" class="theme_button color1">
                        <span><?php echo esc_html($flicker_button_text); ?></span>
                    </a>
                </div>
            <?php endif; ?>
	<?php
		break;

		//form
	default:
	?>
		<div class="header-search">
			<?php get_search_form(); ?>
		</div><!-- .header-search -->
<?php
endswitch;
