<?php
/**
 * The footer section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

//this footer displays only widgets so if has no widgets - it will be hidden
if ( ! is_active_sidebar( 'sidebar-footer' ) ) {
	if( is_customize_preview() ) {
		echo '<footer id="footer" class="d-none"></footer>';
	}
	return;
}

$flicker_fluid = flicker_option( 'footer_fluid' ) ? '-fluid' : '';

$flicker_footer_background    = flicker_option( 'footer_background', '' );
$flicker_extra_padding_top    = flicker_option( 'footer_extra_padding_top', '' );
$flicker_extra_padding_bottom = flicker_option( 'footer_extra_padding_bottom', '' );

$flicker_border_top        = flicker_option( 'footer_border_top', '' );
$flicker_border_bottom     = flicker_option( 'footer_border_bottom', '' );
$flicker_font_size         = flicker_option( 'footer_font_size', '' );
$flicker_footer_layout_gap = flicker_option( 'footer_layout_gap', '' );

$flicker_background_image = flicker_section_background_image_array( 'footer' );
?>
<footer id="footer"
		class="footer footer-7 <?php echo esc_attr( $flicker_footer_background . ' ' . $flicker_font_size . ' ' . $flicker_background_image['class'] ); ?>"
	<?php echo ( ! empty( $flicker_background_image['url'] ) ) ? 'style="background-image: url(' . esc_url( $flicker_background_image['url'] ) . ');"' : ''; ?>
>
	<?php
	if ( 'full' === $flicker_border_top ) {
		echo wp_kses_post( '<hr class="section-hr">' );
	}
	?>
	<div class="container<?php echo esc_attr( $flicker_fluid . ' ' . $flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom ); ?>">
		<?php
		if ( 'container' === $flicker_border_top ) {
			echo wp_kses_post( '<hr class="section-hr">' );
		}

		?>
		<div class="layout-cols-3 <?php echo esc_attr( 'layout-gap-' . $flicker_footer_layout_gap ); ?>">
			<aside class="footer-widgets grid-wrapper second-third-narrow">
				<?php
				dynamic_sidebar( 'sidebar-footer' );
				?>
			</aside><!-- .footer-widgets> -->
		</div>
		<?php

		if ( 'container' === $flicker_border_bottom ) {
			echo wp_kses_post( '<hr class="section-hr">' );
		}
		?>
	</div><!-- .container -->
	<?php
	if ( 'full' === $flicker_border_bottom ) {
		echo wp_kses_post( '<hr class="section-hr">' );
	}
	?>
</footer><!-- #footer -->
