<?php

/**
 * The copyright section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_fluid = flicker_option('copyright_fluid') ? '-fluid' : '';

$flicker_text = flicker_option('copyright_text', '');
if (empty($flicker_text)) {
	$flicker_text = get_bloginfo('name', 'display');
}

$flicker_copyright_background = flicker_option('copyright_background', '');
$flicker_extra_padding_top    = flicker_option('copyright_extra_padding_top');
$flicker_extra_padding_bottom = flicker_option('copyright_extra_padding_bottom');
$flicker_font_size            = flicker_option('copyright_font_size', '');


$flicker_background_image = flicker_section_background_image_array('copyright'); ?>
<div id="copyright" class="copyright <?php echo esc_attr($flicker_copyright_background . ' ' . $flicker_font_size . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
	<div class="container<?php echo esc_attr($flicker_fluid . ' ' . $flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
		<div class="cols-3">
			<div class="copyright-text color-dark">
				<?php echo wp_kses_post(flicker_get_copyright_text($flicker_text)); ?>
			</div>

			<?php

			flicker_social_links();

			if (has_nav_menu('copyright')) :
			?>
				<nav class="copyright-navigation" aria-label="<?php esc_attr_e('Copyright Menu', 'flicker'); ?>">
					<?php
					wp_nav_menu(
						array(
							'theme_location' => 'copyright',
							'menu_class'     => 'copyright-menu',
							'depth'          => 1,
							'container'      => false,
						)
					);
					?>
				</nav><!-- .copyright-navigation -->
			<?php endif; ?>
		</div><!-- .cols-2 -->
	</div><!-- .container -->

</div><!-- #copyright -->