document.addEventListener("DOMContentLoaded", function () {
    function showDiv(id) {
        // Hide all divs
        document.querySelectorAll(".contentmusic").forEach(div => {
            div.style.display = "none";
        });

        // Show the clicked div
        document.getElementById(id).style.display = "block";
    }

    // Attach click events to buttons
    document.querySelectorAll("[data-target]").forEach(button => {
        button.addEventListener("click", function () {
            showDiv(this.getAttribute("data-target"));
        });
    });

    // Show the first div initially
    let firstDiv = document.querySelector(".contentmusic");
    if (firstDiv) {
        firstDiv.style.display = "block";
    }
});


jQuery(window).on("load", function () {
    jQuery(".cue-playlist").removeClass("max-width-480 max-width-380 max-width-300 max-width-200");
});

