<?php

/**
 * Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

//load parent CSS
if (!function_exists('flicker_child_enqueue_static')) :
    /**
     * flicker_child_enqueue_static
     *
     * @return void
     * @since 0.0.1
     */
    function flicker_child_enqueue_static()
    {
        wp_enqueue_style(
            'flicker-child-style',
            get_stylesheet_directory_uri() . '/style.css',
            array('flicker-style'),
            wp_get_theme()->get('Version')
        );
    }
endif;
add_action('wp_enqueue_scripts', 'flicker_child_enqueue_static', 999);

function enqueue_custom_scripts() {
    wp_enqueue_script('custom-script', get_stylesheet_directory_uri() . '/script.js', array(), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

if (!function_exists('flicker_action_flush_rewrite_rules')) :
    function flicker_action_flush_rewrite_rules()
    {
        flush_rewrite_rules();
        if (class_exists('\Elementor\Utils')) {
            \Elementor\Utils::replace_urls('http://your-old-url.com', site_url());
        }
    }
endif;
add_action('fw:ext:backups:tasks:finish:id:demo-content-install', 'flicker_action_flush_rewrite_rules');

//del <p> and <br/> form
add_filter('wpcf7_autop_or_not', '__return_false');

//remove render block
remove_action('render_block', 'wp_render_layout_support_flag', 10, 2);

define('FLICKER_THEME_VERSION', wp_get_theme()->get('Version'));

//https://developer.wordpress.org/themes/basics/linking-theme-files-directories/#linking-to-theme-directories
define('FLICKER_THEME_URI', get_parent_theme_file_uri());
define('FLICKER_THEME_PATH', get_parent_theme_file_path());


// You may request this 'FLICKER_REMOTE_DEMO_ID' value from this theme author to get a colorized demo content.
// See the Theme support service contacts information.
define('FLICKER_REMOTE_DEMO_ID', ''); // as example: '12345678'
define('FLICKER_REMOTE_DEMO_VERSION', '1.0.0');
define('FLICKER_DEV_MODE', false);

//THEME SETUP
//theme support
//image sizes
//register menus
//register sidebars
require_once FLICKER_THEME_PATH . '/inc/setup.php';

//THEME OPTIONS helpers and default options
require_once FLICKER_THEME_PATH . '/inc/options.php';

//STATIC ASSETS
require_once FLICKER_THEME_PATH . '/inc/static.php';

//HTML OUTPUT FILTERS
require_once FLICKER_THEME_PATH . '/inc/output-filters.php';

//WooCommerce support
if (class_exists('WooCommerce')) {
    require_once FLICKER_THEME_PATH . '/inc/woocommerce.php';
}

//only for front end

//TEMPLATE HELPERS
require_once FLICKER_THEME_PATH . '/inc/template-helpers.php';


//only for admin
if (is_admin()) {

    //TGM plugin activation and demo-content
    require_once FLICKER_THEME_PATH . '/inc/tgm-plugin-activation/plugins.php';
}

//only for customizer
if (is_customize_preview() || FLICKER_DEV_MODE) {

    //CUSTOMIZER INIT
    require_once FLICKER_THEME_PATH . '/inc/customizer/google-fonts.php';
    require_once FLICKER_THEME_PATH . '/inc/customizer.php';
}

if (FLICKER_DEV_MODE) :
    require_once FLICKER_THEME_PATH . '/dev/extensions/functions.php';
endif;
