<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! defined( 'UB' ) ) {
	define( 'UB', true );
}


add_action('tgmpa_register', 'ub_unyson_demo_tgmpa_register_action' );
//different plugins for different demos progress
if ( ! function_exists( 'ub_unyson_demo_tgmpa_register_action' ) ) :
	function ub_unyson_demo_tgmpa_register_action() {
		global $ub_global_backup_demo;
		$demo = isset( $_POST['demo'] ) ? esc_attr( $_POST['demo'] ) : '';
		$all_demos = $ub_global_backup_demo->get_demos();

		if ( ! empty( $demo ) && isset( $all_demos[ $demo ] ) ) {
			tgmpa( $all_demos[ $demo ]->get_plugins() , array( 'id' => $demo ) );
		}
	}
endif;

//different plugins for different demos progress
if ( ! function_exists( 'ub_unyson_demo_get_required_demo_plugins' ) ) :
	function ub_unyson_demo_get_required_demo_plugins( $demo_number = 'demo-1', $plugins=array() ) {
		//get TGMPA instance
		$tgmpa = call_user_func( array( get_class( $GLOBALS['tgmpa'] ), 'get_instance' ) );

		//registering all plugins if they are not in the default stack
		foreach( $plugins as $plugin ) {
			$tgmpa->register( $plugin );
		}

		$plugins_to_install_and_activate = array(
			'all'      => array(), // Meaning: all plugins which still have open actions.
			'install'  => array(),
			'update'   => array(),
			'activate' => array(),
		);

		foreach( $plugins as $plugin ) {
			if ( ! $tgmpa->can_plugin_activate( $plugin['slug'] ) && $tgmpa->is_plugin_installed( $plugin['slug'] ) && false === $tgmpa->does_plugin_have_update( $plugin['slug'] ) ) {
//			if ( $tgmpa->is_plugin_active( $plugin['slug'] ) && false === $tgmpa->does_plugin_have_update( $plugin['slug'] ) ) {
				// No need to display plugins if they are installed, up-to-date and active.
				continue;
			}
			if ( ! $tgmpa->is_plugin_installed( $plugin['slug'] ) ) {
				$plugins_to_install_and_activate['install'][ $plugin['slug'] ] = $plugin;
			} else {
				if ( false !== $tgmpa->does_plugin_have_update( $plugin['slug'] ) ) {
					$plugins_to_install_and_activate['update'][ $plugin['slug'] ] = $plugin;
				}

				if ( $tgmpa->can_plugin_activate( $plugin['slug'] ) ) {
					$plugins_to_install_and_activate['activate'][ $plugin['slug'] ] = $plugin;
				}
			}
		}
		return $plugins_to_install_and_activate;
	}
endif; //ub_unyson_demo_get_required_demo_plugins


if ( ! function_exists( 'ub_unyson_demo_get_demo_install_notice_html' ) ) :
	function ub_unyson_demo_get_demo_install_notice_html( $demo_number = 0, $demo_plugins = array() ) {
		$plugins = ub_unyson_demo_get_required_demo_plugins( $demo_number, $demo_plugins );
		$notice_html = '';
		$data_install = array();
		$data_activate = array();
		if( ! empty( $plugins['install'] ) || ! empty( $plugins['activate'] ) ) {
			$notice_html .= '<div class="ub-required-plugins"><strong>' . esc_html__( 'Required plugins:' , 'ub' ) . '</strong></div>';
			foreach ( $plugins['install'] as $plugin ) {
				if( empty( $plugin['name'] ) ) {
					continue;
				}
				$notice_html .= '<div class="ub-plugin-install">' . esc_html( $plugin['name'] ) . ' - <span class="demo-required-plugin-' . esc_attr( $plugin['slug'] ) . '">' . esc_html__( 'Install' , 'ub' ) . '</span></div>';
				$data_install[] = $plugin['slug'];
			}
			foreach ( $plugins['activate'] as $plugin ) {
				if( empty( $plugin['name'] ) ) {
					continue;
				}
				$notice_html .= '<div class="ub-plugin-activate">' . esc_html($plugin['name'] ) . ' - <span class="demo-required-plugin-' . esc_attr( $plugin['slug'] ) . '">' . esc_html__( 'Activate' , 'ub' ) . '</span></div>';
				$data_activate[] = $plugin['slug'];
			}
			$notice_html .= '<br><div class="demo-required-plugins-button-wrap"><button class="demo-required-plugins-install-plugins-button button button-primary"' .
			                ' data-toinstall="' . esc_attr( join(',', $data_install) ) . '"' .
			                ' data-toactivate="' . esc_attr( join( ',', $data_activate ) ) . '"' .
			                ' data-todemo="' . esc_attr( $demo_number ). '">' .
			                esc_html__( 'Install and Activate plugins' , 'ub' ) .
			                '</button><span class="spinner"></span></div>';
		}
		return $notice_html;
	}
endif; //ub_unyson_demo_get_demo_install_notice_html

//process ajax call to install plugins
add_action( 'wp_ajax_ub_install_and_activate_plugins', 'ub_wp_ajax_install_and_activate_plugins' );
if( ! function_exists( 'ub_wp_ajax_install_and_activate_plugins' ) ) :
	function ub_wp_ajax_install_and_activate_plugins() {
		if ( ! check_ajax_referer( 'ub_unyson_demo_nonce', 'wpnonce' ) ) {
			wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'Forbidden', 'ub' ) ) );
		}
		if ( empty( $_POST['slug'] ) || ( empty( $_POST['plugins_activate'] ) && empty( $_POST['plugins_install'] ) ) ) {
			wp_send_json_error( array( 'error' => 1, 'message' => esc_html__( 'No Plugins to Process', 'ub' ) ) );
		}

		$demo = ! empty( $_POST['demo'] ) ? esc_attr( $_POST['demo'] ) : '';


		$json = array();
		$plugins = array();
		// send back some json we use to hit up TGM
		$plugins['activate'] = ! empty( $_POST['plugins_activate'] ) ? $_POST['plugins_activate'] : array();
		$plugins['install'] = ! empty( $_POST['plugins_install'] ) ? $_POST['plugins_install'] : array();
		// what are we doing with this plugin?
		//activating - is default
		$json = array(
			'url'           => admin_url( 'themes.php?page=tgmpa-install-plugins' ),
			'plugin'        => $_POST['plugins_activate'],
			'tgmpa-page'    => 'tgmpa-install-plugins',
			'plugin_status' => 'all',
			'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
			'action'        => 'tgmpa-bulk-activate',
			'action2'       => - 1,
			'message'       => esc_html__( 'Activating Plugin...', 'ub' ),
			//load all plugins, not only default
			'ub_all_plugins' => 1,
			'demo' => $demo
		);
		//every plugin to install is separate call
		//override activation here
		foreach ( $plugins['install'] as $slug ) {
			if (  $slug === $_POST['slug'] ) {
				$json = array(
					'url'           => admin_url( 'themes.php?page=tgmpa-install-plugins' ),
					'plugin'        => array( $slug ),
					'tgmpa-page'    => 'tgmpa-install-plugins',
					'plugin_status' => 'all',
					'_wpnonce'      => wp_create_nonce( 'bulk-plugins' ),
					'action'        => 'tgmpa-bulk-install',
					'action2'       => - 1,
					'message'       => esc_html__( 'Installing Plugin...', 'ub' ),
					//load all plugins, not only default
					'ub_all_plugins' => 1,
					'demo' => $demo
				);
				break;
			}
		}

		if ( $json ) {
			$json['hash'] = md5( serialize( $json ) ); // used for checking if duplicates happen, move to next plugin
			wp_send_json( $json );
		} else {
			wp_send_json( array( 'done' => 1, 'message' => esc_html__( 'Success', 'ub' ) ) );
		}
		wp_die();
	}
endif; //ub_wp_ajax_install_and_activate_plugins


//////////////////////////////////
//demo content on remote hosting//
//example function              //
//////////////////////////////////
/**
 * @param UB_Ext_Backups_Demo[] $demos
 *
 * @return UB_Ext_Backups_Demo[]
 */
if ( ! function_exists( 'ub_filter_theme_ub_ext_backups_demos' ) ) :

	function ub_filter_theme_ub_ext_backups_demos( $demos ) {
		$version = '1.0.0';

		$demo_version_suffix = '-v' . $version;  // result: '-v1.0.0'

		// this 'demo-id' should be inserted to remote config file
		// result: 'ub-demo-v1.0.0'
		$demo_id = 'ub-demo' . $demo_version_suffix;

		$demos_array = array(
			$demo_id => array(
				'title'        => esc_html__( 'Demo', 'ub' ),
				'screenshot'   => esc_url('http://domain.com/demo/screenshot.png'),
				'preview_link' => esc_url('http://domain.com/slug/'),
				'plugins' => array(
					array (
						'name'             => 'MailChimp',
						'slug'             => 'mailchimp-for-wp',
						'required'         => true,
					),
					array(
						'name'             => 'WooCommerce',
						'slug'             => 'woocommerce',
						'required'         => false,
					),
					array (
						'name'      => 'Envato Market',
						'slug'      => 'envato-market',
						'source'    => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
						'required'  => true, // please do not turn to false!
					),
				)
			),
		);

		// You may request this demo id from this theme author to get a colorized demo content. See the author contacts information.
		$secret_demo_id = ''; // as example: '12345678'

		// this 'demo-id' should be inserted to remote config
		// result: 'ub-demo-colorized-12345678-v1.0.0'
		$demo_id   = 'ub-demo-colorized-' . $secret_demo_id . $demo_version_suffix;

		if ( $secret_demo_id ) {
			$demos_array[$demo_id] = array(
				'title'        => esc_html__( 'Demo (Colorized)', 'ub' ),
				'screenshot'   => esc_url('http://domain.com/demo/screenshot.png'),
				'preview_link' => esc_url('http://domain.com/slug/'),
				'plugins' => array(
					array (
						'name'             => 'MailChimp',
						'slug'             => 'mailchimp-for-wp',
						'required'         => true,
					),
					array(
						'name'             => 'WooCommerce',
						'slug'             => 'woocommerce',
						'required'         => false,
					),
					array (
						'name'      => 'Envato Market',
						'slug'      => 'envato-market',
						'source'    => esc_url('https://envato.github.io/wp-envato-market/dist/envato-market.zip'),
						'required'  => true, // please do not turn to false!
					),
				)
			);
		}

		// remote demo URL
		$download_url = esc_url('http://domain.com/ub/demo/');

		foreach ( $demos_array as $id => $data ) {
			$demo = new UB_Ext_Backups_Demo( $id, 'piecemeal', array(
				'url'     => $download_url,
				'file_id' => $id,
			) );
			$demo->set_title( $data['title'] );
			$demo->set_screenshot( $data['screenshot'] );
			$demo->set_preview_link( $data['preview_link'] );
			if  ( method_exists($demo, 'set_plugins' ) ) {
				$demo->set_plugins( $data['plugins'] );
			}

			$demos[ $demo->get_id() ] = $demo;

			unset( $demo );
		}

		return $demos;

	} //ub_filter_theme_ub_ext_backups_demos()
endif;
//add_filter( 'fw:ext:backups-demo:demos', 'ub_filter_theme_ub_ext_backups_demos' );
