<?php if (!defined('UB')) die('Forbidden');
/**
 * @var string $archives_html
 */
?>

<?php
//$backups = ub_ext( 'backups' ); /** @var UB_Extension_Backups $backups */
//$page_url = $backups->get_page_url();
?>
<h2><?php esc_html_e('Backup', 'ub') ?> <span id="ub-ext-backups-status"></span></h2>

<div>
	<?php if ( !class_exists('ZipArchive') ): ?>
		<div class="error below-h2">
			<p>
				<strong><?php _e( 'Important', 'ub' ); ?></strong>:
				<?php printf(
					__( 'You need to activate %s.', 'ub' ),
					'<a href="http://php.net/manual/en/book.zip.php" target="_blank">'. __('zip extension', 'ub') .'</a>'
				); ?>
			</p>
		</div>
	<?php endif; ?>

	<?php if ($http_loopback_warning = ub_ext_backups_loopback_test()) : ?>
		<div class="error">
			<p><strong><?php _e( 'Important', 'ub' ); ?>:</strong> <?php echo $http_loopback_warning; ?></p>
		</div>
		<script type="text/javascript">var ub_ext_backups_loopback_failed = true;</script>
	<?php endif; ?>

	<div class="ub-ext-backups-description">
		<ul>
			<?php if (ub_ext_backups_current_user_can_full()): ?>
			<li>
				<span class="description">
				<strong><?php esc_html_e('Full Backup', 'ub'); ?></strong>
				- <?php esc_html_e('will save your themes, plugins, uploads and full database.'); ?>
				</span>
			</li>
			<?php endif; ?>
			<li>
				<span class="description">
				<strong><?php esc_html_e('Content Backup', 'ub'); ?></strong>
				- <?php esc_html_e('will save your uploads and database without private data like users, admin email, etc.'); ?>
				</span>
			</li>
		</ul>
	</div>

	<div id="ub-ext-backups-schedule-status"></div>

	<div>
		&nbsp;
		<?php if (ub_ext_backups_current_user_can_full()): ?>
		<a href="#" onclick="return false;" id="ub-ext-backups-full-backup-now"
		   class="button ub-ext-backups-backup-now" data-full="1"><?php esc_html_e('Create Full Backup Now', 'ub') ?></a>
		&nbsp;
		<?php endif; ?>
		<a href="#" onclick="return false;" id="ub-ext-backups-content-backup-now"
		   class="button ub-ext-backups-backup-now" data-full=""><?php esc_html_e('Create Content Backup Now', 'ub'); ?></a>
	</div>
</div>

<br>
<h3><?php _e( 'Archives', 'ub' ) ?></h3>

<div id="ub-ext-backups-archives"><?php echo $archives_html; ?></div>

<br>
<?php do_action('ub_ext_backups_page_footer'); ?>