<?php if (!defined('UB')) die('Forbidden');
/**
 * @var array $log
 */
?>

<?php if ($log): ?>
	<div id="ub-ext-backups-log-show-button">
		<a href="#" onclick="return false;" class="button-view"><?php esc_html_e('View Activity Log', 'ub'); ?></a>
		<a href="#" onclick="return false;" class="button-hide"><?php esc_html_e('Hide Activity Log', 'ub'); ?></a>
	</div>
	<div id="ub-ext-backups-log-list">
		<ul>
		<?php foreach ($log as $l): ?>
			<?php
			switch (isset($l['type']) ? $l['type'] : '') {
				case 'success': $class = 'ub-text-success'; break;
				case 'info':    $class = 'ub-text-info'; break;
				case 'warning': $class = 'ub-text-warning'; break;
				case 'error':   $class = 'ub-text-danger'; break;
				default:        $class = ''; break;
			}
			?>
			<li>
				<em><?php printf(esc_html__('%s ago', 'ub'), human_time_diff($l['time'])); ?></em>
				<span class="<?php echo esc_attr($class) ?>"><?php echo esc_html($l['title']); ?></span>
			</li>
		<?php endforeach ?>
		</ul>
	</div>
<?php endif; ?>



