<?php
/**
 * Widget Theme meta view file
 *
 * @package Flicker
 * @since 0.0.1
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = ( ! empty( $mwt_text_center ) ) ? 'text-center' : '';
$mwt_pt_class     = ( ! empty( $mwt_pt ) ) ? 'mt-' . $mwt_pt : '';
$mwt_pb_class     = ( ! empty( $mwt_pb ) ) ? 'mb-' . $mwt_pb : '';


echo wp_kses_post( str_replace( 'class="', 'class="widget-fullwidth ', $mwt_args['before_widget'] ) );
echo '<div class="widget-theme-spacer ' . esc_attr( $mwt_css_class . ' ' . $mwt_center_class . ' ' . $mwt_pt_class . ' ' . $mwt_pb_class ) . '">';
if ( $mwt_title ) {
	echo wp_kses_post( $mwt_args['before_title'] . $mwt_title . $mwt_args['after_title'] );
}
if ( $mwt_sub_title ) {
	echo '<p class="sub-title">' . wp_kses_post( $mwt_sub_title ) . '</p><!-- .sub-title-->';
}

if ( 'hr' === $mwt_layout ) {
	echo '<hr>';
}
?>
	</div><!-- .widget-theme-spacer -->
<?php
echo wp_kses_post( $mwt_args['after_widget'] );
