<?php

/**
 * Widget Posts view file
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post(str_replace('class="', 'class="widget-fullwidth posts-featured ', $mwt_args['before_widget']));
echo '<div class="posts-featured ' . esc_attr($mwt_css_class . ' layout-' . $mwt_layout . ' layout-gap-' . $mwt_gap . ' ' . $mwt_center_class) . '">';
if ($mwt_title) {
	echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_sub_title) {
	echo '<p class="sub-title">' . wp_kses_post($mwt_sub_title) . '</p><!-- .sub-title-->';
}
if (!empty($mwt_cat_name) && !empty($mwt_show_cat)) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post($mwt_cat_name) . '</span></h4>';
}
?>
<div class="posts-wrap d-grid grid-3-cols">
	<?php
	$mwt_count = count($mwt_r->posts) - 1;
	foreach ($mwt_r->posts as $mwt_index => $mwt_post) :
		$mwt_post_title     = get_the_title($mwt_post->ID);
		$mwt_post_thumbnail = get_the_post_thumbnail($mwt_post->ID, 'thumbnail');
		$mwt_title          = (!empty($mwt_post_title)) ? $mwt_post_title : esc_html__('(no title)', 'mwt-widgets');

		//first and second elements is featured
		if (0 === $mwt_index || 1 === $mwt_index) :
	?>
			<div class="posts-featured-item <?php echo esc_attr((!empty($mwt_post_thumbnail)) ? 'has-post-thumbnail' : 'no-post-thumbnail'); ?>">
				<?php if (!empty($mwt_post_thumbnail)) : ?>
					<div class="content-absolute">
						<a class="posts-list-thumbnail" href="<?php the_permalink($mwt_post->ID); ?>">
							<?php
							echo get_the_post_thumbnail($mwt_post->ID, 'large');
							flicker_post_format_icon(get_post_format($mwt_post->ID));
							?>
						</a>
					<?php endif; ?>
					<div class="overlap-content">
						<h5 class="post-title">
							<a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
						</h5>
						<?php if ($mwt_show_date) : ?>
							<footer class="entry-footer">
								<span class="icon-inline post-date">
									<span><?php echo get_the_date('', $mwt_post->ID); ?></span>
								</span>
							</footer>
						<?php endif; ?>
					</div><!-- .overlap-content -->
					<?php if (!empty($mwt_post_thumbnail)) : ?>
					</div><!-- .content-absolute -->
				<?php endif; ?>
			</div><!-- .posts-featured-item -->
			<?php
		// not featured items
		else :
			//open UL for second post - first not featured post
			if (2 === $mwt_index) :
			?>
				<div class="widget-posts-secondary">
					<ul class="posts-list">
					<?php endif; //first not featured post 
					?>
					<li class="<?php echo esc_attr(!empty($mwt_post_thumbnail) ? 'list-has-post-thumbnail' : 'no-post-thumbnail'); ?>">
						<?php if (!empty($mwt_post_thumbnail)) : ?>
							<a class="posts-list-thumbnail" href="<?php the_permalink($mwt_post->ID); ?>">
								<?php
								echo wp_kses_post($mwt_post_thumbnail);
								flicker_post_format_icon(get_post_format($mwt_post->ID));
								?>
							</a>
						<?php endif; ?>
						<div class="item-content">
							<h5 class="post-title">
								<a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
							</h5>
							<?php if (!empty($mwt_show_date)) : ?>
								<span class="icon-inline post-date">
									<span><?php echo get_the_date('', $mwt_post->ID); ?></span>
								</span>
							<?php endif; ?>
						</div>
					</li>
				<?php
			endif; //0 === $mwt_index || 1 === $mwt_index
			if ($mwt_index === $mwt_count && $mwt_count > 1) :
				?>
					</ul><!-- .posts-list -->
				</div><!-- .posts-secondary -->
		<?php
			endif; //count
		endforeach;
		?>
</div><!-- .posts-wrap -->
<?php if (!empty($mwt_read_all)) : ?>
	<span class="read-all-link">
		<a href="<?php echo esc_url($mwt_read_all_url); ?>">
			<?php echo esc_html($mwt_read_all); ?>
		</a>
	</span>
<?php endif; //$mwt_read_all 
?>
</div><!-- .posts-featured -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
