<?php

/**
 * Widget Posts view file
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post($mwt_args['before_widget']);
echo '<div class="widget-posts-default ' . esc_attr($mwt_css_class . ' layout-' . $mwt_layout . ' layout-gap-' . $mwt_gap . ' ' . $mwt_center_class) . '">';
if ($mwt_title) {
	echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_sub_title) {
	echo '<p class="sub-title">' . wp_kses_post($mwt_sub_title) . '</p><!-- .sub-title-->';
}
if (!empty($mwt_cat_name) && !empty($mwt_show_cat)) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post($mwt_cat_name) . '</span></h4>';
}
?>
<ul class="posts-list">
	<?php
	foreach ($mwt_r->posts as $mwt_post) :
		$mwt_post_title     = get_the_title($mwt_post->ID);
		$mwt_post_thumbnail = get_the_post_thumbnail($mwt_post->ID, 'thumbnail');
		$mwt_title          = (!empty($mwt_post_title)) ? $mwt_post_title : esc_html__('(no title)', 'mwt-widgets');
	?>
		<li class="<?php echo esc_attr((!empty($mwt_post_thumbnail)) ? 'list-has-post-thumbnail' : 'no-post-thumbnail'); ?>">
			<?php if (!empty($mwt_post_thumbnail)) : ?>
				<a class="posts-list-thumbnail" href="<?php the_permalink($mwt_post->ID); ?>">
					<?php
					echo wp_kses_post($mwt_post_thumbnail);
					flicker_post_format_icon(get_post_format($mwt_post->ID));
					?>
				</a>
			<?php endif; ?>
			<div class="item-content">
				<h4 class="post-title">
					<a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
				</h4>
				<?php if (!empty($mwt_show_date)) : ?>
					<div class="icon-inline-wrap">
						<span class="icon-inline post-date highlight">
							<span><?php echo get_the_date('m.d.y', $mwt_post->ID); ?></span>
						</span>
					</div>
				<?php endif; ?>
			</div>
		</li>
	<?php endforeach; ?>
</ul>
<?php if (!empty($mwt_read_all)) : ?>
	<span class="read-all-link">
		<a href="<?php echo esc_url($mwt_read_all_url); ?>">
			<?php echo esc_html($mwt_read_all); ?>
		</a>
	</span>
<?php endif; //$mwt_read_all 
?>
</div><!-- .widget-posts-default -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
