<?php

/**
 * Widget Posts view file
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post(str_replace('class="', 'class="widget-fullwidth ', $mwt_args['before_widget']));
echo '<div class="widget-posts-gird grid-absolute layout-cols-' . esc_attr($mwt_columns . ' layout-' . $mwt_layout . ' layout-gap-' . $mwt_gap . ' ' . $mwt_css_class . $mwt_center_class) . '">';
if ($mwt_title) {
	echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_sub_title) {
	echo '<p class="sub-title">' . wp_kses_post($mwt_sub_title) . '</p><!-- .sub-title-->';
}
if (!empty($mwt_cat_name) && !empty($mwt_show_cat)) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post($mwt_cat_name) . '</span></h4>';
}
?>
<div class="grid-wrapper">
	<?php
	foreach ($mwt_r->posts as $mwt_post) :
		$mwt_post_title     = get_the_title($mwt_post->ID);
		$mwt_title          = (!empty($mwt_post_title)) ? $mwt_post_title : esc_html__('(no title)', 'mwt-widgets');
		$mwt_post_thumbnail = get_the_post_thumbnail($mwt_post->ID, 'flicker-square-half');
		$mwt_post_class     = (!empty($mwt_post_thumbnail)) ? 'content-absolute' : '';
	?>
		<div class="grid-item">
			<article <?php post_class('', $mwt_post->ID); ?>>
				<?php if (!empty($mwt_post_thumbnail)) : ?>
					<div class="content-absolute">
						<div class="posts-list-thumbnail">
							<?php
							echo wp_kses_post($mwt_post_thumbnail);
							flicker_post_format_icon(get_post_format($mwt_post->ID));
							?>
							<a class="abs-link" href="<?php the_permalink($mwt_post->ID); ?>"></a>
						</div>
						<div class="overlap-content">
							<h5 class="post-title">
								<a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
							</h5>
							<?php if (!empty($mwt_show_date)) : ?>
								<footer class="entry-footer">
									<span class="icon-inline post-date">
										<span><?php echo get_the_date('', $mwt_post->ID); ?></span>
									</span>
								</footer>
							<?php endif; ?>
						</div><!-- .content-overlap -->
					</div><!-- .content-absolute -->
				<?php else : //no post thumbnail 
				?>
					<div class="item-content">
						<h5 class="post-title">
							<a href="<?php the_permalink($mwt_post->ID); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
						</h5>
						<?php if (!empty($mwt_show_date)) : ?>
							<footer class="entry-footer">
								<span class="icon-inline post-date">
									<span><?php echo get_the_date('', $mwt_post->ID); ?></span>
								</span>
							</footer>
						<?php endif; //show_date 
						?>
					</div>
				<?php endif; //empty post_thumbnail 
				?>
			</article>
		</div><!-- .grid-item -->
	<?php endforeach; ?>
</div>
<?php if (!empty($mwt_read_all)) : ?>
	<span class="read-all-link">
		<a href="<?php echo esc_url($mwt_read_all_url); ?>">
			<?php echo esc_html($mwt_read_all); ?>
		</a>
	</span>
<?php endif; //$mwt_read_all 
?>
</div><!-- .widget-posts-grid -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
