<?php

/**
 * Widget Posts view file
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post(str_replace('class="', 'class="widget-fullwidth posts-single ', $mwt_args['before_widget']));
echo '<div class="posts-single ' . esc_attr(' layout-' . $mwt_layout . ' ' . $mwt_css_class . $mwt_center_class) . '">';
if ($mwt_title) {
	echo wp_kses_post($mwt_args['before_title'] . $mwt_title . $mwt_args['after_title']);
}
if ($mwt_sub_title) {
	echo '<p class="sub-title">' . wp_kses_post($mwt_sub_title) . '</p><!-- .sub-title-->';
}
if (!empty($mwt_cat_name) && !empty($mwt_show_cat)) {
	echo '<h4 class="widget-posts-category-name"><span>' . wp_kses_post($mwt_cat_name) . '</span></h4>';
}
?>
<div class="posts-single-wrap">
	<?php
	while ($mwt_r->have_posts()) :
		$mwt_r->the_post();
		$mwt_id             = get_the_ID();
		$mwt_post_title     = get_the_title($mwt_id);
		$mwt_title          = (!empty($mwt_post_title)) ? $mwt_post_title : esc_html__('(no title)', 'mwt-widgets');
		$mwt_post_thumbnail = get_the_post_thumbnail($mwt_id, 'post-thumbnail');
		$mwt_post_class     = (!empty($mwt_post_thumbnail)) ? 'posts-single-item has-post-thumbnail content-absolute' : 'posts-single-item no-post-thumbnail';
	?>
		<article <?php post_class(); ?>>
			<div class="<?php echo esc_attr($mwt_post_class); ?>">

				<?php if (!empty($mwt_post_thumbnail)) : ?>
					<a class="posts-list-thumbnail" href="<?php the_permalink($mwt_id); ?>">
						<?php
						echo get_the_post_thumbnail($mwt_id, 'flicker-square');
						flicker_post_format_icon(get_post_format($mwt_id));
						?>
					</a>
					<div class="overlap-content">
						<h5 class="post-title">
							<a href="<?php the_permalink($mwt_id); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
						</h5>
						<?php if ($mwt_show_date) : ?>
							<footer class="entry-footer">
								<span class="icon-inline">
									<span><?php echo get_the_date('', $mwt_id); ?></span>
								</span>
							</footer>
						<?php
						endif; //$mwt_show_date
						the_excerpt();
						?>
					</div>
				<?php else : ?>
					<h5 class="post-title">
						<a href="<?php the_permalink($mwt_id); ?>"><?php echo wp_kses_post($mwt_title); ?></a>
					</h5>
					<?php if ($mwt_show_date) : ?>
						<footer class="entry-footer">
							<span class="icon-inline">
								<span><?php echo get_the_date('', $mwt_id); ?></span>
							</span>
						</footer>
					<?php
					endif; //$mwt_show_date
					the_excerpt();
					?>
				<?php endif; //$mwt_post_thumbnail 
				?>
			</div><!-- <?php echo esc_attr($mwt_post_class); ?> -->
		</article>
	<?php
	endwhile;
	wp_reset_postdata();
	?>
</div><!-- .posts-single-wrap -->
<?php if (!empty($mwt_read_all)) : ?>
	<span class="read-all-link">
		<a href="<?php echo esc_url($mwt_read_all_url); ?>">
			<?php echo esc_html($mwt_read_all); ?>
		</a>
	</span>
<?php endif; //$mwt_read_all 
?>
</div><!-- .posts-single -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
