<?php

/**
 * Widget Theme meta view file
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

// if our theme is not active - return
if (!function_exists('flicker_get_theme_meta')) {
    return;
}

//meta
$mwt_meta = flicker_get_theme_meta();

$mwt_center_class = (!empty($mwt_text_center)) ? ' text-center' : '';

echo wp_kses_post($mwt_args['before_widget']);
echo '<div class="widget-theme-meta-default footer-top-style ' . esc_attr($mwt_css_class . $mwt_center_class) . '">';

if ($mwt_image_uri) {
    echo '<div class="theme-meta-img wp-block-image"><img src="' . esc_url($mwt_image_uri) . '" alt="' . esc_attr($mwt_title) . '"></div>';
}

if (!empty($mwt_show_social_links) && function_exists('flicker_social_links')) :
?>
    <?php flicker_social_links(); ?>
<?php endif; //social_links 
?>
</div><!-- .widget-theme-meta-default -->
<?php
echo wp_kses_post($mwt_args['after_widget']);
