<?php

/**
 * Widget API: MWT_Widget_Theme_Meta class
 *
 * @package Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

//this widget make sense only for Flicker theme - it shows content from theme customizer settings
//TODO process layout
if ('flicker' !== get_template()) :
	return;
endif;


if (!class_exists('MWT_Widget_Theme_Meta')) :

	class MWT_Widget_Theme_Meta extends WP_Widget
	{

		/**
		 * Sets up a new Recent Posts widget instance.
		 *
		 * @since 0.0.1
		 */
		public function __construct()
		{
			$mwt_widget_ops = array(
				'classname'                   => 'widget_theme_meta',
				'description'                 => esc_html__('Theme meta from customizer settings.', 'mwt-widgets'),
				'customize_selective_refresh' => true,
			);

			add_action('admin_print_scripts-widgets.php', array($this, 'enqueue_admin_scripts'));

			parent::__construct('theme-meta', esc_html__('Theme Meta', 'mwt-widgets'), $mwt_widget_ops);
			$this->alt_option_name = 'widget_theme_meta';
		}

		/**
		 * Loads the required scripts and styles for the widget control.
		 */
		public function enqueue_admin_scripts()
		{
			wp_enqueue_media();
			$mwt_prefix = MWT_WIDGETS_PLUGIN_URL . '/assets/';
			if (defined('FLICKER_DEV_MODE')) {
				if (FLICKER_DEV_MODE) {
					$mwt_prefix = FLICKER_THEME_URI . '/dev/extensions/mwt-widgets/assets/';
				}
			}
			wp_enqueue_script(
				'flicker-widgets-admin-script',
				$mwt_prefix . 'js/media.js',
				array('jquery'),
				'0.0.1',
				true
			);
		}

		/**
		 * Outputs the content for the current Custom Posts widget instance.
		 *
		 * @param array $mwt_args Display arguments including 'before_title', 'after_title',
		 *                        'before_widget', and 'after_widget'.
		 * @param array $mwt_instance Settings for the current Custom Posts widget instance.
		 */
		public function widget($mwt_args, $mwt_instance)
		{
			if (!isset($mwt_args['widget_id'])) {
				$mwt_args['widget_id'] = $this->id;
			}

			$mwt_title = (!empty($mwt_instance['title'])) ? $mwt_instance['title'] : '';

			/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
			$mwt_title = apply_filters('widget_title', $mwt_title, $mwt_instance, $this->id_base);

			$mwt_image_uri = (!empty($mwt_instance['image_uri'])) ? $mwt_instance['image_uri'] : '';
			$mwt_sub_title = (!empty($mwt_instance['sub_title'])) ? $mwt_instance['sub_title'] : '';

			$mwt_show_address       = isset($mwt_instance['show_address']) ? $mwt_instance['show_address'] : false;
			$mwt_show_email         = isset($mwt_instance['show_email']) ? $mwt_instance['show_email'] : false;
			$mwt_show_phone         = isset($mwt_instance['show_phone']) ? $mwt_instance['show_phone'] : false;
			$mwt_show_website         = isset($mwt_instance['show_website']) ? $mwt_instance['show_website'] : false;
			$mwt_show_opening_hours = isset($mwt_instance['show_opening_hours']) ? $mwt_instance['show_opening_hours'] : false;
			$mwt_show_social_links  = isset($mwt_instance['show_social_links']) ? $mwt_instance['show_social_links'] : false;
			$mwt_text_center        = isset($mwt_instance['text_center']) ? $mwt_instance['text_center'] : false;
			$mwt_layout             = (!empty($mwt_instance['layout'])) ? esc_attr($mwt_instance['layout']) : 'default';
			$mwt_css_class          = (!empty($mwt_instance['css_class'])) ? sanitize_text_field($mwt_instance['css_class']) : '';

			$mwt_filepath = MWT_WIDGETS_PLUGIN_PATH . 'widgets/meta/views/' . $mwt_layout . '.php';

			if (file_exists($mwt_filepath)) {
				include $mwt_filepath;
			} else {
				esc_html_e('View not found: ', 'mwt-widgets');
				echo '<strong>' . esc_html($mwt_filepath) . '</strong>';
			}
		}

		/**
		 * Handles updating the settings for the current Recent Posts widget instance.
		 *
		 * @param array $mwt_new_instance New settings for this instance as input by the user via
		 *                            WP_Widget::form().
		 * @param array $mwt_old_instance Old settings for this instance.
		 *
		 * @return array Updated settings to save.
		 */
		public function update($mwt_new_instance, $mwt_old_instance)
		{
			$mwt_instance                       = $mwt_old_instance;
			$mwt_instance['title']              = sanitize_text_field($mwt_new_instance['title']);
			$mwt_instance['image_uri']          = esc_url($mwt_new_instance['image_uri']);
			$mwt_instance['sub_title']          = sanitize_text_field($mwt_new_instance['sub_title']);
			$mwt_instance['show_address']       = isset($mwt_new_instance['show_address']) ? (bool) $mwt_new_instance['show_address'] : false;
			$mwt_instance['show_email']         = isset($mwt_new_instance['show_email']) ? (bool) $mwt_new_instance['show_email'] : false;
			$mwt_instance['show_phone']         = isset($mwt_new_instance['show_phone']) ? (bool) $mwt_new_instance['show_phone'] : false;
			$mwt_instance['show_website']         = isset($mwt_new_instance['show_website']) ? (bool) $mwt_new_instance['show_website'] : false;
			$mwt_instance['show_opening_hours'] = isset($mwt_new_instance['show_opening_hours']) ? (bool) $mwt_new_instance['show_opening_hours'] : false;
			$mwt_instance['show_social_links']  = isset($mwt_new_instance['show_social_links']) ? (bool) $mwt_new_instance['show_social_links'] : false;
			$mwt_instance['text_center']        = isset($mwt_new_instance['text_center']) ? (bool) $mwt_new_instance['text_center'] : false;
			$mwt_instance['layout']             = esc_attr($mwt_new_instance['layout']);
			$mwt_instance['css_class']          = sanitize_text_field($mwt_new_instance['css_class']);

			return $mwt_instance;
		}

		/**
		 * Outputs the settings form for the Recent Posts widget.
		 *
		 * @param array $mwt_instance Current settings.
		 */
		public function form($mwt_instance)
		{
			$mwt_title              = isset($mwt_instance['title']) ? esc_attr($mwt_instance['title']) : '';
			$mwt_image_uri          = isset($mwt_instance['image_uri']) ? esc_url($mwt_instance['image_uri']) : '';
			$mwt_sub_title          = isset($mwt_instance['sub_title']) ? esc_attr($mwt_instance['sub_title']) : '';
			$mwt_show_address       = isset($mwt_instance['show_address']) ? (bool) $mwt_instance['show_address'] : false;
			$mwt_show_email         = isset($mwt_instance['show_email']) ? (bool) $mwt_instance['show_email'] : false;
			$mwt_show_phone         = isset($mwt_instance['show_phone']) ? (bool) $mwt_instance['show_phone'] : false;
			$mwt_show_website         = isset($mwt_instance['show_website']) ? (bool) $mwt_instance['show_website'] : false;
			$mwt_show_opening_hours = isset($mwt_instance['show_opening_hours']) ? (bool) $mwt_instance['show_opening_hours'] : false;
			$mwt_show_social_links  = isset($mwt_instance['show_social_links']) ? (bool) $mwt_instance['show_social_links'] : false;
			$mwt_text_center        = isset($mwt_instance['text_center']) ? (bool) $mwt_instance['text_center'] : false;
			$mwt_layout             = isset($mwt_instance['layout']) ? esc_attr($mwt_instance['layout']) : 'default';
			$mwt_css_class          = isset($mwt_instance['css_class']) ? sanitize_text_field($mwt_instance['css_class']) : '';
?>
			<p>
				<label for="<?php echo esc_attr($this->get_field_id('title')); ?>"><?php esc_html_e('Title:', 'mwt-widgets'); ?></label>
				<input class="widefat" id="<?php echo esc_attr($this->get_field_id('title')); ?>" name="<?php echo esc_attr($this->get_field_name('title')); ?>" type="text" value="<?php echo esc_attr($mwt_title); ?>" />
			</p>

			<div class="flicker-meta-widget-media">
				<div>
					<label for="<?php echo esc_attr($this->get_field_id('image_uri')); ?>_img"><?php esc_html_e('Image:', 'mwt-widgets'); ?></label>
				</div>
				<div>
					<img class="<?php echo esc_attr($this->get_field_id('image_uri')); ?>_img" src="<?php echo (!empty($mwt_image_uri)) ? esc_url($mwt_image_uri) : ''; ?>" style="max-width:100%;" />
				</div>
				<input type="text" class="widefat <?php echo esc_attr($this->get_field_id('image_uri')); ?>_url" name="<?php echo esc_attr($this->get_field_name('image_uri')); ?>" value="<?php echo esc_attr($mwt_image_uri); ?>" hidden />
				<div>
					<button type="button" id="<?php echo esc_attr($this->get_field_id('image_uri')); ?>" class="dashicons-before dashicons-upload button button-primary flicker_meta_widget_upload_media"></button>
					<button type="button" id="<?php echo esc_attr($this->get_field_id('image_uri')); ?>_remove" class="dashicons-before dashicons-dismiss button flicker_meta_widget_remove_media"></button>
				</div>
			</div>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('sub_title')); ?>"><?php esc_html_e('Sub Title:', 'mwt-widgets'); ?></label>
				<textarea class="widefat" id="<?php echo esc_attr($this->get_field_id('sub_title')); ?>" name="<?php echo esc_attr($this->get_field_name('sub_title')); ?>"><?php echo esc_html($mwt_sub_title); ?></textarea>
			</p>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('layout')); ?>"><?php esc_html_e('Widgets layout:', 'mwt-widgets'); ?></label>
				<select name="<?php echo esc_attr($this->get_field_name('layout')); ?>" id="<?php echo esc_attr($this->get_field_id('layout')); ?>" class="widefat">
					<option value="default" <?php selected($mwt_layout, 'default'); ?>><?php esc_html_e('Default list', 'mwt-widgets'); ?></option>
					<option value="footer-top" <?php selected($mwt_layout, 'footer-top'); ?>><?php esc_html_e('Image and Social Icons Only', 'mwt-widgets'); ?></option>
					<option value="social-icons-only" <?php selected($mwt_layout, 'social-icons-only'); ?>><?php esc_html_e('Social Icons Only', 'mwt-widgets'); ?></option>
					<option value="social-icons-only-alt" <?php selected($mwt_layout, 'social-icons-only-alt'); ?>><?php esc_html_e('Social Icons Only Alt', 'mwt-widgets'); ?></option>
				</select>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_show_address); ?> id="<?php echo esc_attr($this->get_field_id('show_address')); ?>" name="<?php echo esc_attr($this->get_field_name('show_address')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('show_address')); ?>"><?php esc_html_e('Display address if set?', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_show_email); ?> id="<?php echo esc_attr($this->get_field_id('show_email')); ?>" name="<?php echo esc_attr($this->get_field_name('show_email')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('show_email')); ?>"><?php esc_html_e('Display email if set?', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_show_phone); ?> id="<?php echo esc_attr($this->get_field_id('show_phone')); ?>" name="<?php echo esc_attr($this->get_field_name('show_phone')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('show_phone')); ?>"><?php esc_html_e('Display phone if set?', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_show_website); ?> id="<?php echo esc_attr($this->get_field_id('show_website')); ?>" name="<?php echo esc_attr($this->get_field_name('show_website')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('show_website')); ?>"><?php esc_html_e('Display website if set?', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_show_opening_hours); ?> id="<?php echo esc_attr($this->get_field_id('show_opening_hours')); ?>" name="<?php echo esc_attr($this->get_field_name('show_opening_hours')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('show_opening_hours')); ?>"><?php esc_html_e('Display opening hours if set?', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_show_social_links); ?> id="<?php echo esc_attr($this->get_field_id('show_social_links')); ?>" name="<?php echo esc_attr($this->get_field_name('show_social_links')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('show_social_links')); ?>"><?php esc_html_e('Display social links if set?', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<input class="checkbox" type="checkbox" <?php checked($mwt_text_center); ?> id="<?php echo esc_attr($this->get_field_id('text_center')); ?>" name="<?php echo esc_attr($this->get_field_name('text_center')); ?>" />
				<label for="<?php echo esc_attr($this->get_field_id('text_center')); ?>"><?php esc_html_e('Center alignment', 'mwt-widgets'); ?></label>
			</p>

			<p>
				<label for="<?php echo esc_attr($this->get_field_id('css_class')); ?>"><?php esc_html_e('Custom CSS class:', 'mwt-widgets'); ?></label>
				<input class="widefat" id="<?php echo esc_attr($this->get_field_id('css_class')); ?>" name="<?php echo esc_attr($this->get_field_name('css_class')); ?>" type="text" value="<?php echo esc_attr($mwt_css_class); ?>" />
			</p>
<?php
		}
	}

endif; //class_exists


if (!function_exists('flicker_theme_register_widget_theme_meta')) :
	function flicker_theme_register_widget_theme_meta()
	{
		register_widget('MWT_Widget_Theme_Meta');
	}
endif;
add_action('widgets_init', 'flicker_theme_register_widget_theme_meta');
