<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Elementor MWT Team Carousel Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

class Elementor_MWT_Team_Carousel extends \Elementor\Widget_Base

{

	/**
	 * Retrieve Widget Dependent JS.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array JS script handles.
	 */
	public function get_script_depends()
	{
		return ['team-carousel-script'];
	}

	/**
	 * Retrieve Widget Dependent CSS.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array CSS style handles.
	 */
	public function get_style_depends()
	{
		return ['owl-carousel-style'];
		return ['team-carousel-style'];
	}

	/**
	 * Get widget name.
	 *
	 * Retrieve list widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'team-carousel';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve list widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return esc_html__('MWT Team Carousel', 'mwt-addons-for-elementor');
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the list widget belongs to.
	 *
	 * @since 1.0.0
	 * @access public
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['mwt'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve image carousel widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords()
	{
		return ['mwt', 'image', 'photo', 'visual', 'team', 'carousel', 'slider'];
	}

	/**
	 * Register list widget controls.
	 *
	 * Add input fields to allow the user to customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls()
	{

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__('Carousel Items', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		/* Start repeater */

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image',
			[
				'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'item_name',
			[
				'label' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'default' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'item_name_link',
			[
				'label'       => __('Title Link', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::URL,
				'placeholder' => 'https://example.com/',
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'item_position',
			[
				'label'       => __('Position', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'placeholder' => esc_html__('Position', 'mwt-addons-for-elementor'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'item_description',
			[
				'label'       => __('Description', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('Description', 'mwt-addons-for-elementor'),
				'label_block' => true,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'member_social_enable',
			[
				'label'     => __('Enable Social Icons', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'default'   => 'yes',
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'member_facebook',
			[
				'label'       => __('Facebook', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'default'     => '#',
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_twitter',
			[
				'label'       => __('Twitter', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'default'     => '#',
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_linkedin',
			[
				'label'       => __('LinkedIn', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_youtube',
			[
				'label'       => __('YouTube', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_instagram',
			[
				'label'       => __('Instagram', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'default'     => '#',
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_skype',
			[
				'label'       => __('Skype', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_pinterest',
			[
				'label'       => __('Pinterest', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_dribbble',
			[
				'label'       => __('Dribbble', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'default'     => '#',
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_behance',
			[
				'label'       => __('Behance', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_whatsapp',
			[
				'label'       => __('WhatsApp', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		$repeater->add_control(
			'member_telegram',
			[
				'label'       => __('Telegram', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'dynamic'     => ['active' => true],
				'label_block' => true,
				'condition'   => [
					'member_social_enable' => 'yes',
				],
			]
		);

		/* End repeater */

		$this->add_control(
			'team-list',
			[
				'label' => esc_html__('Members', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'image' => '',
						'item_name' => esc_html__('Name 1', 'mwt-addons-for-elementor'),
						'item_name_link' => '',
						'item_position' => '',
						'item_description' => '',
						'member_social_enable' => '',
						'member_facebook' => 'https://www.facebook.com/',
						'member_twitter' => 'https://twitter.com/',
						'member_linkedin' => '',
						'member_google'    => '',
						'member_youtube'   => '',
						'member_instagram' => 'https://www.instagram.com/',
						'member_skype'     => '',
						'member_pinterest' => '',
						'member_dribbble'  => '',
						'member_behance'   => '',
						'member_whatsapp'  => '',
						'member_telegram'  => '',
					],
					[
						'image' => '',
						'item_name' => esc_html__('Name 2', 'mwt-addons-for-elementor'),
						'item_name_link' => '',
						'item_position' => '',
						'item_description' => '',
						'member_social_enable' => '',
						'member_facebook' => 'https://www.facebook.com/',
						'member_twitter' => 'https://twitter.com/',
						'member_linkedin' => '',
						'member_google'    => '',
						'member_youtube'   => '',
						'member_instagram' => 'https://www.instagram.com/',
						'member_skype'     => '',
						'member_pinterest' => '',
						'member_dribbble'  => '',
						'member_behance'   => '',
						'member_whatsapp'  => '',
						'member_telegram'  => '',
					],
					[
						'image' => '',
						'item_name' => esc_html__('Name 3', 'mwt-addons-for-elementor'),
						'item_name_link' => '',
						'item_position' => '',
						'item_description' => '',
						'member_social_enable' => '',
						'member_facebook' => 'https://www.facebook.com/',
						'member_twitter' => 'https://twitter.com/',
						'member_linkedin' => '',
						'member_google'    => '',
						'member_youtube'   => '',
						'member_instagram' => 'https://www.instagram.com/',
						'member_skype'     => '',
						'member_pinterest' => '',
						'member_dribbble'  => '',
						'member_behance'   => '',
						'member_whatsapp'  => '',
						'member_telegram'  => '',
					],
				],
				'title_field' => '{{{ item_name }}}',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail',
				'separator' => 'none',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'carousel_settings',
			[
				'label' => __('Carousel Settings', 'mwt-addons-for-elementor'),
			]
		);

		$this->add_control(
			'data_loop',
			[
				'label'   => __('Loop', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_autoplay',
			[
				'label'   => __('Autoplay', 'mwt-addons-for-elementor'),
				'description' => esc_html__('Slide will start automatically', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);


		$this->add_control(
			'data_autoplaytimeout',
			[
				'label' => esc_html__('Autoplay Speed (ms)', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'default' => 3000,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_center',
			[
				'label'   => __('Centered Carousel?', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		//Slides to Scroll

		$this->add_control(
			'data_responsive_lg',
			[
				'label' => esc_html__('Desktop Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 8,
				'step' => 1,
				'default' => 3,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_responsive_sm',
			[
				'label' => esc_html__('Tabs Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 8,
				'step' => 1,
				'default' => 2,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_responsive_xs',
			[
				'label' => esc_html__('Mobile Slides', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 8,
				'step' => 1,
				'default' => 1,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_margin',
			[
				'label' => esc_html__('Item Gap (px)', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::NUMBER,
				'min' => 0,
				'max' => 60,
				'step' => 1,
				'default' => 15,
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'data_nav',
			[
				'label'   => __('Navigation', 'mwt-addons-for-elementor'),
				'type'    => \Elementor\Controls_Manager::SWITCHER,
				'default' => 'yes',
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		// style
		$this->start_controls_section(
			'style_item_section',
			[
				'label' => esc_html__('Items', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_bg_color',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .owl-carousel-item' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'testimonials_item_align',
			[
				'label'     => __('Alignment', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => [
					'left' => [
						'title' => __('Left', 'mwt-addons-for-elementor'),
						'icon'  => 'eicon-text-align-left',
					],
					'center'     => [
						'title' => __('Center', 'mwt-addons-for-elementor'),
						'icon'  => 'eicon-text-align-center',
					],
					'right'   => [
						'title' => __('Right', 'mwt-addons-for-elementor'),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'Left',
				'selectors' => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-content-wrap' => 'text-align: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'item_padding',
			[
				'label'      => __('Padding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .mwt-elementor-team-carousel-content-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'item_border_radius',
			[
				'label'      => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .owl-carousel-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .owl-carousel.team-slider .owl-carousel-item .mwt-elementor-team-carousel-image-wrap img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} 0 0;',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_image',
			[
				'label' => esc_html__('Image', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'image_hover_overlay_color',
			[
				'label' => esc_html__('Hover Overlay Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-carousel.team-slider .owl-carousel-item .mwt-elementor-team-carousel-image-wrap::before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_name_section',
			[
				'label' => esc_html__('Name', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'name_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-name' => 'color: {{VALUE}};',
					'{{WRAPPER}} a.mwt-elementor-team-carousel-name' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'name_color_active',
			[
				'label' => esc_html__('Color Hover', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} a.mwt-elementor-team-carousel-name:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'name_typography',
				'selector' =>
				'{{WRAPPER}} .mwt-elementor-team-carousel-name, {{WRAPPER}} .mwt-elementor-team-carousel-name > a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'label' => esc_html__('Text Shadow', 'mwt-addons-for-elementor'),
				'name' => 'name_shadow',
				'selector' => '{{WRAPPER}} .mwt-elementor-team-carousel-name',
			]
		);

		$this->add_responsive_control(
			'name_bottom_spacing',
			[
				'label'      => __('Bottom Spacing', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-name'  => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_position_section',
			[
				'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'position_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-position' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'position_typography',
				'selector' =>
				'{{WRAPPER}} .mwt-elementor-team-carousel-position',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'label' => esc_html__('Text Shadow', 'mwt-addons-for-elementor'),
				'name' => 'position_shadow',
				'selector' => '{{WRAPPER}} .mwt-elementor-team-carousel-position',
			]
		);

		$this->add_responsive_control(
			'position_bottom_spacing',
			[
				'label'      => __('Bottom Spacing', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-position'  => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_description_section',
			[
				'label' => esc_html__('Description', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'description_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-description' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
				'name' => 'description_typography',
				'selector' =>
				'{{WRAPPER}} .mwt-elementor-team-carousel-description',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Text_Shadow::get_type(),
			[
				'label' => esc_html__('Text Shadow', 'mwt-addons-for-elementor'),
				'name' => 'description_shadow',
				'selector' => '{{WRAPPER}} .mwt-elementor-team-carousel-description',
			]
		);

		$this->add_responsive_control(
			'description_bottom_spacing',
			[
				'label'      => __('Bottom Spacing', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .mwt-elementor-team-carousel-description'  => 'margin-bottom: {{SIZE}}{{UNIT}}',
				],
			]
		);

		$this->end_controls_section();

		//soc icons style
		$this->start_controls_section(
			'social_icon_style',
			[
				'label'     => __('Social Icons', 'mwt-addons-for-elementor'),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'social_size',
			[
				'label'       => __('Size', 'mwt-addons-for-elementor'),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => ['px', 'em', '%'],
				'label_block' => true,
				'selectors'   => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'social_default_colors',
			[
				'label'        => __('Brands Default Colors', 'mwt-addons-for-elementor'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'prefix_class' => 'members-defaults-',
			]
		);

		$this->add_control(
			'social_color',
			[
				'label'     => __('Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item i'  => 'color: {{VALUE}};',
				],
				'condition' => [
					'social_default_colors!'   => 'yes',
				],
			]
		);

		$this->add_control(
			'social_default_hover_colors',
			[
				'label'        => __('Brands Default Hover Colors', 'mwt-addons-for-elementor'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'prefix_class' => 'members-defaults-hover-',
			]
		);

		$this->add_control(
			'social_hover_color',
			[
				'label'     => __('Hover Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item:hover i'  => 'color: {{VALUE}}',
				],
				'condition' => [
					'social_default_hover_colors!'   => 'yes',
				],
			]
		);

		$this->add_control(
			'social_default_background',
			[
				'label'        => __('Brands Default Background Colors', 'mwt-addons-for-elementor'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'prefix_class' => 'members-defaults-background-',
			]
		);

		$this->add_control(
			'social_background',
			[
				'label'     => __('Background Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item a'  => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'social_default_background!'   => 'yes',
				],
			]
		);

		$this->add_control(
			'social_default_hover_background',
			[
				'label'        => __('Brands Default Hover Background Colors', 'mwt-addons-for-elementor'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'prefix_class' => 'members-defaults-hover-background-',
			]
		);

		$this->add_control(
			'social_hover_background',
			[
				'label'     => __('Hover Background Color', 'mwt-addons-for-elementor'),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container li.members-list-item:hover a'  => 'background-color: {{VALUE}}',
				],
				'condition' => [
					'social_default_hover_background!'   => 'yes',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'social_border',
				'selector' => '{{WRAPPER}} .owl-team-carousel-container .members-list-item a',
			]
		);

		$this->add_responsive_control(
			'social_radius',
			[
				'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
				],
			]
		);

		$this->add_responsive_control(
			'social_margin',
			[
				'label'      => __('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'social_padding',
			[
				'label'      => __('Padding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .members-list-item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'style_navigation_section',
			[
				'label' => esc_html__('Navigation', 'mwt-addons-for-elementor'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'data_nav' => 'yes',
				],
			]
		);

		$this->add_control(
			'nav_layout',
			[
				'label' => esc_html__('Navigation Layout', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'layout-1',
				'options' => [
					'nav-layout-1' => esc_html__('Layout 1', 'mwt-addons-for-elementor'),
					'nav-layout-2' => esc_html__('Layout 2', 'mwt-addons-for-elementor'),
				],
				'frontend_available' => true,
			]
		);

		$this->add_responsive_control(
			'nav_icon_size',
			[
				'label'      => __('Icon Size', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range'      => [
					'px' => [
						'min'  => 12,
						'max'  => 40,
						'step' => 1,
					],
				],
				'default'    => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button:after' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'navigation_color',
			[
				'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'navigation_color_hover',
			[
				'label' => esc_html__('Color Hover', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button:hover:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'navigation_bg_color',
			[
				'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'navigation_bg_color_hover',
			[
				'label' => esc_html__('Background Color Hover', 'mwt-addons-for-elementor'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'navigation_border_radius_1',
			[
				'label'      => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button.owl-prev' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button.owl-next' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'nav_layout' => 'nav-layout-1',
				],
			]
		);

		$this->add_responsive_control(
			'navigation_padding',
			[
				'label'      => esc_html__('Pdding', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'nav_layout' => 'nav-layout-1',
				],
			]
		);

		$this->add_responsive_control(
			'navigation_margin',
			[
				'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'nav_layout' => 'nav-layout-1',
				],
			]
		);

		$this->add_control(
			'navigation_border_radius_2',
			[
				'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', 'em', '%'],
				'selectors'  => [
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button.owl-prev'  => 'border-top-right-radius: {{SIZE}}{{UNIT}}; border-bottom-right-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .owl-team-carousel-container .team-slider .owl-nav > button.owl-next'  => 'border-top-left-radius: {{SIZE}}{{UNIT}}; border-bottom-left-radius: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'nav_layout' => 'nav-layout-2',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render list widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();

		$unique_id = uniqid();

		if (empty($settings['team-list'])) {
			return;
		} ?>
		<div class="owl-team-carousel-container">
			<?php
			$data_loop = ($settings['data_loop'] === 'yes') ? 'true' : 'false';
			$data_autoplay = ($settings['data_autoplay'] === 'yes') ? 'true' : 'false';
			$data_center = ($settings['data_center'] === 'yes') ? 'true' : 'false';
			$data_nav = ($settings['data_nav'] === 'yes') ? 'true' : 'false';
			?>
			<div id="widget_portfolio_carousel_<?php echo esc_attr($unique_id); ?>" class="owl-carousel team-slider <?php echo esc_attr($settings['nav_layout']); ?>" data-loop="<?php echo esc_attr($data_loop) ?>" data-autoplay="<?php echo esc_attr($data_autoplay) ?>" data-autoplaytimeout="<?php echo esc_attr($settings['data_autoplaytimeout']) ?>" data-center="<?php echo esc_attr($data_center) ?>" data-nav="<?php echo esc_attr($data_nav) ?>" data-margin="<?php echo esc_attr($settings['data_margin']) ?>" data-responsive-lg="<?php echo esc_attr($settings['data_responsive_lg']) ?>" data-responsive-sm="<?php echo esc_attr($settings['data_responsive_sm']) ?>" data-responsive-xs="<?php echo esc_attr($settings['data_responsive_xs']) ?>">
				<?php
				foreach ($settings['team-list'] as $index => $item) { ?>
					<div class="owl-carousel-item">
						<div class="mwt-elementor-team-carousel-image-wrap">
							<?php
							$image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'thumbnail', $settings);
							if (!$image_url && isset($item['image']['url'])) {
								$image_url = $item['image']['url'];
							}
							if (!empty($item['item_name'])) {
								$image_alt = $item['item_name'];
							} else {
								$image_alt = 'This is a title';
							}
							$image_html = '<img class="slide-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr($image_alt) . '" />';
							echo wp_kses_post($image_html);
							?>
							<?php
							$name_link = $settings['team-list'][$index]['item_name_link']['url'];
							if (!empty($name_link)) { ?>
								<a href="<?php echo esc_attr($name_link) ?>" class="mwt-elementor-team-carousel-media-link"></a>
							<?php } ?>
						</div>
						<?php
						$name = $settings['team-list'][$index]['item_name'];
						$position = $settings['team-list'][$index]['item_position'];
						$description = $settings['team-list'][$index]['item_description'];
						?>
						<div class="mwt-elementor-team-carousel-content-wrap">
							<?php
							if (!empty($name_link)) { ?>
								<a href="<?php echo esc_attr($name_link) ?>" class="mwt-elementor-team-carousel-name">
									<?php echo $name; ?>
								</a>
							<?php } else { ?>
								<div class="mwt-elementor-team-carousel-name">
									<?php echo $name; ?>
								</div>
							<?php } ?>
							<?php if (!empty($position)) { ?>
								<div class="mwt-elementor-team-carousel-position">
									<?php echo $position; ?>
								</div>
							<?php } ?>
							<?php if (!empty($description)) { ?>
								<div class="mwt-elementor-team-carousel-description">
									<?php echo $description; ?>
								</div>
							<?php } ?>
							<?php
							$social_sites = array(
								'facebook'  => 'fa fa-facebook-f',
								'twitter'   => 'ico-Twitter',
								'linkedin'  => 'fa fa-linkedin',
								'youtube'   => 'fa fa-youtube-play',
								'instagram' => 'fa fa-instagram',
								'skype'     => 'fa fa-skype',
								'pinterest' => 'fa fa-pinterest',
								'dribbble'  => 'fa fa-dribbble',
								'behance'   => 'fa fa-behance',
								'whatsapp'  => 'fa fa-whatsapp',
								'telegram'  => 'fa fa-telegram',
							);
							?>
							<ul class="member-social-list">
								<?php
								foreach ($social_sites as $site => $icon) {
									$value = $item['member_' . $site];

									if (!empty($value)) {
										$icon_class = sprintf('elementor-icon members-list-item members-%s', $site); ?>
										<li class="<?php echo esc_attr($icon_class); ?>">
											<a href="<?php echo esc_url($value); ?>" target="_blank">
												<i class="<?php echo esc_attr($icon); ?>"></i>
											</a>
										</li>
								<?php
									}
								} ?>
							</ul>
						</div>
					</div>
				<?php } ?>
			</div>
		</div>
<?php }
}
