<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 * Elementor MWT Main Slider Widget.
 *
 * Elementor widget that inserts an embbedable content into the page, from any given URL.
 *
 * @since 1.0.0
 */

class Elementor_MWT_Main_Slider extends \Elementor\Widget_Base

{

    /**
     * Retrieve Widget Dependent JS.
     *
     * @since 1.0.0
     * @access public
     * @return array JS script handles.
     */
    public function get_script_depends()
    {
        return ['main-slider-script'];
    }

    /**
     * Retrieve Widget Dependent CSS.
     *
     * @since 1.0.0
     * @access public
     * @return array CSS style handles.
     */
    public function get_style_depends()
    {
        return ['main-slider-style'];
    }

    /**
     * Get widget name.
     *
     * Retrieve list widget name.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'main-slider';
    }

    /**
     * Get widget title.
     *
     * Retrieve list widget title.
     *
     * @since 1.0.0
     * @access public
     * @return string Widget title.
     */
    public function get_title()
    {
        return esc_html__('MWT Main Slider', 'mwt-addons-for-elementor');
    }

    /**
     * Get widget categories.
     *
     * Retrieve the list of categories the list widget belongs to.
     *
     * @since 1.0.0
     * @access public
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['mwt'];
    }

    /**
     * Get widget icon.
     *
     * Retrieve image carousel widget icon.
     *
     * @since 1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'eicon-slides';
    }

    /**
     * Get widget keywords.
     *
     * Retrieve the list of keywords the widget belongs to.
     *
     * @since 2.1.0
     * @access public
     *
     * @return array Widget keywords.
     */
    public function get_keywords()
    {
        return ['mwt', 'image', 'photo', 'main', 'visual', 'carousel', 'slider'];
    }

    /**
     * Register list widget controls.
     *
     * Add input fields to allow the user to customize the widget settings.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function register_controls()
    {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Slider', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        /* Start repeater */

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'media_type',
            [
                'label' => esc_html__('Select', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'mwt-addons-for-elementor'),
                    'video' => esc_html__('Video', 'mwt-addons-for-elementor'),
                ],
                'frontend_available' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__('Choose Background Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'media_type' => 'image',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'video',
            [
                'label' => esc_html__('Choose Video', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'media_types' => ['video'],
                'condition' => [
                    'media_type' => 'video',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'add_background_text',
            [
                'label'     => __('Add Background Text', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $repeater->add_control(
            'background_text',
            [
                'label' => esc_html__('Background Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your background text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'add_background_text' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'background_text_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_background_text' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'background_text_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_background_text' => 'yes',
                    'background_text_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'hr',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'add_background_text' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'add_image_layer_middle',
            [
                'label'     => __('Add Image Layer', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
            ]
        );

        $repeater->add_control(
            'image_layer_middle',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_image_layer_middle_position',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'layer_middle_center' => esc_html__('Center', 'mwt-addons-for-elementor'),
                    'layer_middle_top'    => esc_html__('Top', 'mwt-addons-for-elementor'),
                    'layer_middle_bottom' => esc_html__('Bottom', 'mwt-addons-for-elementor'),
                ],
                'default' => 'layer_middle_center',
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_middle_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_middle_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'image_layer_middle_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'hr_1',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'add_image_layer_upper',
            [
                'label'     => __('Add Image Layer', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_upper',
            [
                'label' => esc_html__('Choose Image', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_image_layer_upper_position',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'layer_middle_center' => esc_html__('Center', 'mwt-addons-for-elementor'),
                    'layer_middle_top'    => esc_html__('Top', 'mwt-addons-for-elementor'),
                    'layer_middle_bottom' => esc_html__('Bottom', 'mwt-addons-for-elementor'),
                ],
                'default' => 'layer_middle_center',
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_upper_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'image_layer_upper_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'add_image_layer_middle' => 'yes',
                    'add_image_layer_upper' => 'yes',
                    'image_layer_upper_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $repeater->add_control(
            'hr_2',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_overlay',
            [
                'label' => esc_html__('Overlay', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'none'              => esc_html__('None', 'mwt-addons-for-elementor'),
                    'overlay-1'  => esc_html__('Overlay 1', 'mwt-addons-for-elementor'),
                    'overlay-2'  => esc_html__('Overlay 2', 'mwt-addons-for-elementor'),
                    'overlay-3'  => esc_html__('Overlay 3', 'mwt-addons-for-elementor'),
                ],
                'default' => 'none',
            ]
        );

        $repeater->add_control(
            'slide_layer_1',
            [
                'label' => esc_html__('Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_1_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h3',
            ]
        );

        $repeater->add_control(
            'hr_3',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_2',
            [
                'label' => esc_html__('Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_2_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h1',
            ]
        );

        $repeater->add_control(
            'hr_4',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_3',
            [
                'label' => esc_html__('Layer #3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your title here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_3_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'h2',
            ]
        );

        $repeater->add_control(
            'hr_5',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_4',
            [
                'label' => esc_html__('Layer #4', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_4_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_6',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_5',
            [
                'label' => esc_html__('Layer #5', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_5_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_7',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_6',
            [
                'label' => esc_html__('Layer #6', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_6_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_8',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_layer_7',
            [
                'label' => esc_html__('Layer #7', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_layer_7_tag',
            [
                'label' => esc_html__('HTML Tag', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                    'span' => 'span',
                    'p' => 'p',
                ],
                'default' => 'div',
            ]
        );

        $repeater->add_control(
            'hr_9',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $repeater->add_control(
            'slide_button',
            [
                'label' => esc_html__('Button Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_button_link',
            [
                'label'       => __('Button Link', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://example.com/',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        $repeater->add_control(
            'slide_button_2',
            [
                'label' => esc_html__('Button 2 Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $repeater->add_control(
            'slide_button_2_link',
            [
                'label'       => __('Button 2 Link', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => 'https://example.com/',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
            ]
        );

        /* End repeater */

        $this->add_control(
            'main_slider',
            [
                'label' => esc_html__('Slider Items', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'slide_layer_1' => esc_html__('Slide #1', 'mwt-addons-for-elementor'),
                    ],
                    [
                        'slide_layer_1' => esc_html__('Slide #2', 'mwt-addons-for-elementor'),
                    ],
                ],
                'title_field' => '{{{ slide_layer_1 }}}',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'main_slider_thumbnail',
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_settings',
            [
                'label' => __('Slider Settings', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'data_slideshow',
            [
                'label' => esc_html__('Autoplay', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_speed',
            [
                'label' => esc_html__('Speed (ms)', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 5000,
                'frontend_available' => true,
                'condition' => [
                    'data_slideshow' => 'yes',
                ]
            ]
        );

        $this->add_control(
            'data_animationloop',
            [
                'label' => esc_html__('Loop', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_animation',
            [
                'label' => esc_html__('Animation Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'fade',
                'options' => [
                    'fade'  => esc_html__('Fade', 'mwt-addons-for-elementor'),
                    'slide' => esc_html__('Slide', 'mwt-addons-for-elementor'),
                ],
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_pauseonhover',
            [
                'label' => esc_html__('Pause on Hover', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'data_nav',
            [
                'label'   => __('Navigation', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'separator' => 'before',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'scroll_button_show',
            [
                'label'   => __('Scroll Button', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'yes',
                'separator' => 'before',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'scroll_button_link',
            [
                'label'       => __('Scroll Button Link', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::URL,
                'placeholder' => '#example',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'scroll_button_show' => 'yes'
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'icons_section',
            [
                'label' => __('Social Icons', 'mwt-addons-for-elementor'),
            ]
        );


        $this->add_control(
            'icon_social_enable',
            [
                'label'     => __('Enable Social Icons', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::SWITCHER,
                'default'   => 'no',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'icon_facebook',
            [
                'label'       => __('Facebook', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'default'     => '#',
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_twitter',
            [
                'label'       => __('Twitter', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'default'     => '#',
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_linkedin',
            [
                'label'       => __('LinkedIn', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_youtube',
            [
                'label'       => __('YouTube', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_instagram',
            [
                'label'       => __('Instagram', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'default'     => '#',
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_pinterest',
            [
                'label'       => __('Pinterest', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_dribbble',
            [
                'label'       => __('Dribbble', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_behance',
            [
                'label'       => __('Behance', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->add_control(
            'icon_telegram',
            [
                'label'       => __('Telegram', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::TEXT,
                'dynamic'     => ['active' => true],
                'label_block' => true,
                'condition'   => [
                    'icon_social_enable' => 'yes',
                ],
                'ai' => [
                    'active' => false,
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'animation_section',
            [
                'label' => __('Entrance Animation', 'mwt-addons-for-elementor'),
            ]
        );

        $entrance_animation = [
            ''             => esc_html__('None', 'mwt-addons-for-elementor'),
            'bounce'       => esc_html__('bounce', 'mwt-addons-for-elementor'),
            'flash'        => esc_html__('flash', 'mwt-addons-for-elementor'),
            'pulse'        => esc_html__('pulse', 'mwt-addons-for-elementor'),
            'rubberBand'   => esc_html__('rubberBand', 'mwt-addons-for-elementor'),
            'shake'        => esc_html__('shake', 'mwt-addons-for-elementor'),
            'headShake'    => esc_html__('headShake', 'mwt-addons-for-elementor'),
            'swing'        => esc_html__('swing', 'mwt-addons-for-elementor'),
            'tada'         => esc_html__('tada', 'mwt-addons-for-elementor'),
            'wobble'       => esc_html__('wobble', 'mwt-addons-for-elementor'),
            'jello'        => esc_html__('jello', 'mwt-addons-for-elementor'),
            'heartBeat'    => esc_html__('heartBeat', 'mwt-addons-for-elementor'),
            'bounceIn'     => esc_html__('bounceIn', 'mwt-addons-for-elementor'),
            'fadeIn'       => esc_html__('fadeIn', 'mwt-addons-for-elementor'),
            'fadeIn2'       => esc_html__('fadeIn2', 'mwt-addons-for-elementor'),
            'fadeInDown'   => esc_html__('fadeInDown', 'mwt-addons-for-elementor'),
            'fadeInLeft'   => esc_html__('fadeInLeft', 'mwt-addons-for-elementor'),
            'fadeInRight'  => esc_html__('fadeInRight', 'mwt-addons-for-elementor'),
            'fadeInRight2'  => esc_html__('fadeInRight2', 'mwt-addons-for-elementor'),
            'fadeInUp'     => esc_html__('fadeInUp', 'mwt-addons-for-elementor'),
            'flip'         => esc_html__('flip', 'mwt-addons-for-elementor'),
            'flipInX'      => esc_html__('flipInX', 'mwt-addons-for-elementor'),
            'flipInY'      => esc_html__('flipInY', 'mwt-addons-for-elementor'),
            'lightSpeedIn' => esc_html__('lightSpeedIn', 'mwt-addons-for-elementor'),
            'jackInTheBox' => esc_html__('jackInTheBox', 'mwt-addons-for-elementor'),
            'zoomIn'       => esc_html__('zoomIn', 'mwt-addons-for-elementor'),
            'pullUp'       => esc_html__('pullUp', 'mwt-addons-for-elementor'),
        ];

        $animation_duration = [
            'slower'   => esc_html__('Slower', 'mwt-addons-for-elementor'),
            'slow'   => esc_html__('Slow', 'mwt-addons-for-elementor'),
            ''   => esc_html__('Normal', 'mwt-addons-for-elementor'),
            'fast'   => esc_html__('Fast', 'mwt-addons-for-elementor'),
            'faster'   => esc_html__('Faster', 'mwt-addons-for-elementor'),
        ];

        $this->add_control(
            'slide_layer_1_image_animation',
            [
                'label' => esc_html__('Image Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_1_image_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_image_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_1_image_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_image_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_2_image_animation',
            [
                'label' => esc_html__('Image Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_2_image_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_image_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_2_image_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_image_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_1_animation',
            [
                'label' => esc_html__('Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_1_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_1_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_1_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_divider_animation',
            [
                'label' => esc_html__('Divider', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_divider_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_divider_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_divider_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_divider_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_2_animation',
            [
                'label' => esc_html__('Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_2_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_2_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_2_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_3_animation',
            [
                'label' => esc_html__('Layer #3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_3_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_3_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_3_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_3_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_4_animation',
            [
                'label' => esc_html__('Layer #4', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_4_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_4_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_4_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_4_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_5_animation',
            [
                'label' => esc_html__('Layer #5', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_5_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_5_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_5_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_5_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_6_animation',
            [
                'label' => esc_html__('Layer #6', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_6_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_6_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_6_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_6_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_7_animation',
            [
                'label' => esc_html__('Layer #7', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_layer_7_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_7_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_layer_7_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_layer_7_animation!' => '',
                ],
            ]
        );

        $this->add_control(
            'slide_button_animation',
            [
                'label' => esc_html__('Button', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $entrance_animation,
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'slide_button_animation_duration',
            [
                'label' => esc_html__('Animation Duration', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $animation_duration,
                'frontend_available' => true,
                'condition' => [
                    'slide_button_animation!' => '',
                ]
            ]
        );

        $this->add_control(
            'slide_button_animation_delay',
            [
                'label' => esc_html__('Animation Delay', 'mwt-addons-for-elementor') . ' (ms)',
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 0,
                'step' => 100,
                'default' => 0,
                'frontend_available' => true,
                'condition' => [
                    'slide_button_animation!' => '',
                ],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_slider_section',
            [
                'label' => esc_html__('Slider', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slider_content_width',
            [
                'label' => esc_html__('Content Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    'boxed' => esc_html__('Boxed', 'mwt-addons-for-elementor'),
                    'full_width' => esc_html__('Full Width', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_responsive_control(
            'content_width',
            [
                'label' => esc_html__('Width', 'elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 1600,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1170,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .container' => 'max-width: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slider_content_width' => ['boxed'],
                ],
            ]
        );

        $this->add_responsive_control(
            'content_height',
            [
                'label' => esc_html__('Height', 'elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 500,
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1000,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slides > li' => 'min-height: {{SIZE}}{{UNIT}}; max-height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slides > li img' => 'min-height: {{SIZE}}{{UNIT}}; max-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_slide_section',
            [
                'label' => esc_html__('Slide', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'slide_description_custom_width',
            [
                'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('Default', 'mwt-addons-for-elementor'),
                    'initial' => esc_html__('Custom', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_description_custom_width_initial',
            [
                'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'default' => [
                    'unit' => '%',
                ],
                'range' => [
                    'px' => [
                        'min' => 320,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slide_description' => 'max-width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'slide_description_custom_width' => 'initial',
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_description_align',
            [
                'label' => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .slide_description_wrapper' => 'justify-content: {{VALUE}};',
                ],
                'condition' => [
                    'slide_description_custom_width' => 'initial',
                ],
            ]
        );

        $this->add_control(
            'background_text',
            [
                'label' => esc_html__('Background Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'background_text_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .silde-title-full p' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'background_text_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-container .silde-title-full p',
            ]
        );

        $this->add_control(
            'background_text_bg',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .silde-title-full' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_1',
            [
                'label' => esc_html__('Layer #1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_1_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-1' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_1_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-1',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_1_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-1' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_1_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_show_divider',
            [
                'label' => esc_html__('Show Divider', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'mwt-addons-for-elementor'),
                'label_off' => esc_html__('Hide', 'mwt-addons-for-elementor'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_divider_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-divider .divider-separator' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'width',
            [
                'label' => esc_html__('Width', 'elementor'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'rem', 'vw', 'custom'],
                'range' => [
                    'px' => [
                        'max' => 1000,
                    ],
                ],
                'default' => [
                    'size' => 100,
                    'unit' => '%',
                ],
                'tablet_default' => [
                    'unit' => '%',
                ],
                'mobile_default' => [
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-divider .divider-separator' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => esc_html__('Alignment', 'elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'top' => [
                        'title' => esc_html__('Center', 'elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-divider .divider-separator' => 'margin: 0 auto; margin-{{VALUE}}: 0',
                ],
            ]
        );


        $this->add_control(
            'slide_layer_2',
            [
                'label' => esc_html__('Layer #2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_2_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_2_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-2',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_2_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-2' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_2_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_3',
            [
                'label' => esc_html__('Layer #3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_3_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_3_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-3',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_3_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-3' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_3_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-3' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_4',
            [
                'label' => esc_html__('Layer #4', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_4_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-4' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_4_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-4',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_4_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-4' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_4_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-4' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_5',
            [
                'label' => esc_html__('Layer #5', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_5_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-5' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_5_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-5',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_5_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-5' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_5_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-5' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_6',
            [
                'label' => esc_html__('Layer #6', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_6_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-6' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_6_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-6',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_6_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-6' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_6_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-6' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_layer_7',
            [
                'label' => esc_html__('Layer #7', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_layer_7_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-7' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_layer_7_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-layer-7',
            ]
        );

        $this->add_responsive_control(
            'slide_layer_7_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-7' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_layer_7_bottom_spacing',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-layer-7' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button',
            [
                'label' => esc_html__('Button', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_button_layout',
            [
                'label' => esc_html__('Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'button',
                'options' => [
                    'button' => esc_html__('Button', 'mwt-addons-for-elementor'),
                    'simple-link' => esc_html__('Simple Link', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_button_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-button',
            ]
        );

        $this->start_controls_tabs(
            'slide_button_style_tabs'
        );

        $this->start_controls_tab(
            'slide_button_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'textdomain'),
            ]
        );

        $this->add_control(
            'slide_button_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_background_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_line_background_color',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'simple-link'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slide_button_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'textdomain'),
            ]
        );

        $this->add_control(
            'slide_button_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_background_color_hover',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_line_background_color_hover',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'simple-link'
                ]
            ]
        );

        $this->add_control(
            'slide_button_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'button'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'slide_button_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-button',
                'condition' => [
                    'slide_button_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_layout' => 'button'
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_button_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_button_min_width',
            [
                'label'      => __('Min Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button'  => 'min-width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'slide_button_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2',
            [
                'label' => esc_html__('Button 2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'slide_button_2_layout',
            [
                'label' => esc_html__('Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'button',
                'options' => [
                    'button' => esc_html__('Button', 'mwt-addons-for-elementor'),
                    'simple-link' => esc_html__('Simple Link', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'slide_button_2_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-button-2',
            ]
        );

        $this->start_controls_tabs(
            'slide_button_2_style_tabs'
        );

        $this->start_controls_tab(
            'slide_button_2_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'textdomain'),
            ]
        );

        $this->add_control(
            'slide_button_2_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_background_color',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_line_background_color',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'simple-link'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'slide_button_2_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'textdomain'),
            ]
        );

        $this->add_control(
            'slide_button_2_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slide_button_2_background_color_hover',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_line_background_color_hover',
            [
                'label'     => __('Line Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover::before' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'simple-link'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'button'
                ]
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'slide_button_2_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-button-2',
                'condition' => [
                    'slide_button_2_layout' => 'button'
                ]
            ]
        );

        $this->add_control(
            'slide_button_2_border_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2'  => 'border-radius: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'button'
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_button_2_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'slide_button_2_min_width',
            [
                'label'      => __('Min Width', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-button-2'  => 'min-width: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'slide_button_2_layout' => 'button'
                ]
            ]
        );

        $this->add_responsive_control(
            'slide_buttons_align',
            [
                'label' => esc_html__('Alignment', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-buttons-wrap' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_overlay',
            [
                'label' => esc_html__('Overlay', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'overlay_1_color',
            [
                'label' => esc_html__('Overlay 1', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container li.overlay-1::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'overlay_2_color',
            [
                'label' => esc_html__('Overlay 2', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container li.overlay-2::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'overlay_3_color',
            [
                'label' => esc_html__('Overlay 3', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container li.overlay-3::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'slider_mask',
            [
                'label' => esc_html__('Mask', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => [
                    '' => esc_html__('None', 'mwt-addons-for-elementor'),
                    'slider-mask-1' => esc_html__('Layout 1', 'mwt-addons-for-elementor'),
                    'slider-mask-2' => esc_html__('Layout 2', 'mwt-addons-for-elementor'),
                    'slider-mask-3' => esc_html__('Layout 3', 'mwt-addons-for-elementor'),
                ],
                'separator' => 'before',
                'frontend_available' => true,
            ]
        );

        $this->end_controls_section();

        //soc icons style
        $this->start_controls_section(
            'social_icon_style',
            [
                'label'     => __('Social Icons', 'mwt-addons-for-elementor'),
                'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'icon_social_enable' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'social_icon_in_content',
            [
                'label'   => __('In Content Area', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'separator' => 'before',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'social_icon_orientation_h',
            [
                'label' => esc_html__('Horizontal Orientation', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .slider-social-list' => '{{VALUE}}: 0;',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_icons_size',
            [
                'label'       => __('Size', 'mwt-addons-for-elementor'),
                'type'        => \Elementor\Controls_Manager::SLIDER,
                'size_units'  => ['px', 'em', '%'],
                'label_block' => true,
                'range'       => [
                    'px' => [
                        'min' => 1,
                        'max' => 48,
                    ],
                ],
                'default'    => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors'   => [
                    '{{WRAPPER}} .slider-list-item i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'social_divider',
            [
                'label'   => __('Divider', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'separator' => 'before',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'social_divider_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-social-list li:not(:last-child)::after' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'social_divider' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'social_divider_weight',
            [
                'label'      => __('Weight', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 1,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .slider-social-list li:not(:last-child)::after'  => 'height: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'social_divider' => 'yes'
                ]
            ]
        );

        $this->start_controls_tabs(
            'social_icons_style_tabs'
        );

        $this->start_controls_tab(
            'social_icons_style_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'social_default_colors',
            [
                'label'        => __('Brands Default Colors', 'mwt-addons-for-elementor'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'prefix_class' => 'icon-defaults-',
            ]
        );

        $this->add_control(
            'social_color',
            [
                'label'     => __('Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-list-item i'  => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'social_default_colors!'   => 'yes',
                ],
            ]
        );

        $this->add_control(
            'social_default_background',
            [
                'label'        => __('Brands Default Background Colors', 'mwt-addons-for-elementor'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'prefix_class' => 'icon-defaults-background-',
                'condition' => [
                    'social_divider!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'social_background',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-list-item a'  => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'social_divider!' => 'yes',
                    'social_default_background!'   => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'social_icons_style_hover_tab',
            [
                'label' => esc_html__('Hover', 'textdomain'),
            ]
        );

        $this->add_control(
            'social_default_hover_colors',
            [
                'label'        => __('Brands Default Colors', 'mwt-addons-for-elementor'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'prefix_class' => 'icon-defaults-hover-',
            ]
        );

        $this->add_control(
            'social_hover_color',
            [
                'label'     => __('Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .slider-list-item:hover i'  => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'social_default_hover_colors!'   => 'yes',
                ],
            ]
        );

        $this->add_control(
            'social_default_hover_background',
            [
                'label'        => __('Brands Default Background Colors', 'mwt-addons-for-elementor'),
                'type'         => \Elementor\Controls_Manager::SWITCHER,
                'prefix_class' => 'icon-defaults-hover-background-',
                'condition' => [
                    'social_divider!' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'social_hover_background',
            [
                'label'     => __('Background Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} li.slider-list-item:hover a'  => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'social_divider!' => 'yes',
                    'social_default_hover_background!'   => 'yes',
                ],
            ]
        );

        $this->add_control(
            'social_hover_border_color',
            [
                'label'     => __('Border Color', 'mwt-addons-for-elementor'),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} li.slider-list-item:hover a'  => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'social_divider!' => 'yes',
                    'social_default_hover_background!'   => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'social_border',
                'selector' => '{{WRAPPER}} .slider-list-item a',
                'condition' => [
                    'social_divider!' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'social_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-list-item a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
                'condition' => [
                    'social_divider!' => 'yes'
                ]
            ]
        );

        $this->add_responsive_control(
            'social_margin',
            [
                'label'      => __('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-list-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'social_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .slider-list-item a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'social_icons_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'social_icons_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'social_icons_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_scroll_section',
            [
                'label' => esc_html__('Scroll Button', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'scroll_button_show' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'scroll_button_layout',
            [
                'label' => esc_html__('Type', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'layout-1',
                'options' => [
                    'layout-1' => esc_html__('Layout #1', 'mwt-addons-for-elementor'),
                    'layout-2' => esc_html__('Layout #2', 'mwt-addons-for-elementor'),
                    'layout-3' => esc_html__('Layout #3', 'mwt-addons-for-elementor'),
                ],
            ]
        );

        $this->add_control(
            'scroll_button_text',
            [
                'label' => esc_html__('Scroll Button Text', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__('Type your text here', 'mwt-addons-for-elementor'),
                'default' => '',
                'label_block' => true,
                'dynamic' => [
                    'active' => true,
                ],
                'ai' => [
                    'active' => false,
                ],
                'condition' => [
                    'scroll_button_layout' => 'layout-2'
                ]
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__('Typography', 'mwt-addons-for-elementor'),
                'name' => 'scroll_button_typography',
                'selector' =>
                '{{WRAPPER}} .mwt-elementor-main-slider-scroll-text a',
                'condition' => [
                    'scroll_button_layout' => 'layout-2'
                ]
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_size',
            [
                'label'      => __('Size', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 8,
                        'max' => 60,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 16,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon .icon-mouse.svg-icon svg'  => 'min-width: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon-chevron .icon-chevron-down.svg-icon svg'  => 'min-width: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'scroll_button_layout' => ['layout-1', 'layout-3'],
                ]
            ]
        );

        $this->add_control(
            'scroll_icon_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon .icon-mouse.svg-icon svg' => 'fill: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-text a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon-chevron .icon-chevron-down.svg-icon svg' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'scroll_icon_bg_color',
            [
                'label' => esc_html__('Color Background', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon-chevron .icon-chevron-down' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'scroll_button_layout' => 'layout-3',
                ]
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_position',
            [
                'label'      => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon'  => 'bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'scroll_button_layout' => 'layout-1'
                ]
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_position_x',
            [
                'label'      => esc_html__('Position X', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 50,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-text'  => 'left: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon-chevron a'  => 'left: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'scroll_button_layout' => ['layout-2', 'layout-3']
                ]
            ]
        );

        $this->add_responsive_control(
            'scroll_icon_position_y',
            [
                'label'      => esc_html__('Position Y', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => -100,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 30,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-text'  => 'top: {{SIZE}}{{UNIT}}',
                    '{{WRAPPER}} .mwt-elementor-main-slider-scroll-icon-chevron a'  => 'bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'scroll_button_layout' => ['layout-2', 'layout-3']
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_navigation_section',
            [
                'label' => esc_html__('Navigation', 'mwt-addons-for-elementor'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'data_nav' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'nav_layout',
            [
                'label' => esc_html__('Layout', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HIDDEN,
                'default' => 'nav-layout-1',
                'options' => [
                    'nav-layout-1' => esc_html__('Layout 1', 'mwt-addons-for-elementor'),
                    'nav-layout-2' => esc_html__('Layout 2', 'mwt-addons-for-elementor'),
                    'nav-layout-3' => esc_html__('Layout 3', 'mwt-addons-for-elementor'),
                    'nav-layout-4' => esc_html__('Layout 4', 'mwt-addons-for-elementor'),
                    'nav-layout-5' => esc_html__('Layout 5', 'mwt-addons-for-elementor'),
                    'nav-layout-6' => esc_html__('Layout 6', 'mwt-addons-for-elementor'),
                ],
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'navigation_arrows',
            [
                'label' => esc_html__('Arrows', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'navigation_arrows_size',
            [
                'label'      => __('Size', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 8,
                        'max' => 60,
                        'step' => 1,
                    ],
                    'em' => [
                        'min' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a::before'  => 'min-width: {{SIZE}}{{UNIT}}; min-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'style_navigation_arrows_tabs'
        );

        $this->start_controls_tab(
            'style_navigation_arrows_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'navigation_arrows_color',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_arrows_bg_color',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_navigation_arrows_hover_tab',
            [
                'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'navigation_arrows_color_hover',
            [
                'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a:hover::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_arrows_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_arrows_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'navigation_arrows_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a',
            ]
        );

        $this->add_responsive_control(
            'navigation_arrows_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_arrows_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_arrows_margin',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_arrows_offset',
            [
                'label'      => esc_html__('Offset', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 500,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav .flex-prev'  => 'left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-direction-nav .flex-next'  => 'right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_arrows_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'navigation_arrows_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'navigation_arrows_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots',
            [
                'label' => esc_html__('Dots', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs(
            'style_navigation_dots_tabs'
        );

        $this->start_controls_tab(
            'style_navigation_dots_normal_tab',
            [
                'label' => esc_html__('Normal', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_navigation_dots_hover_tab',
            [
                'label' => esc_html__('Hover', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots_border_color_hover',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'style_navigation_dots_active_tab',
            [
                'label' => esc_html__('Active', 'mwt-addons-for-elementor'),
            ]
        );

        $this->add_control(
            'navigation_dots_bg_color_active',
            [
                'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a.flex-active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'navigation_dots_border_color_active',
            [
                'label' => esc_html__('Border Color', 'mwt-addons-for-elementor'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a.flex-active' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name'     => 'navigation_dots_border',
                'selector' => '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a',
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_radius',
            [
                'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_padding',
            [
                'label'      => __('Padding', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_dots_margin',
            [
                'label'      => esc_html__('Margin', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'navigation_position',
            [
                'label'      => esc_html__('Position', 'mwt-addons-for-elementor'),
                'type'       => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 60,
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mwt-elementor-main-slider-container .flexslider.nav-layout-1 .flex-control-nav'  => 'bottom: {{SIZE}}{{UNIT}}',
                ],
                'condition' => [
                    'nav_layout' => 'nav-layout-1',
                ],
            ]
        );

        $this->add_control(
            'navigation_hide_on_tablet',
            [
                'label' => esc_html__('Hide On Tablet', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
            ]
        );

        $this->add_control(
            'navigation_hide_on_mobile',
            [
                'label' => esc_html__('Hide On Mobile', 'mwt-addons-for-elementor'),
                'type'    => \Elementor\Controls_Manager::SWITCHER,
                'default' => 'no',
                'frontend_available' => true,
                'condition' => [
                    'navigation_hide_on_tablet!' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    /**
     * Render list widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();

        if (empty($settings['main_slider'])) {
            return;
        }
?>
        <div class="mwt-elementor-main-slider-container">
            <?php
            $social_icon_in_content = ('yes' === $settings['social_icon_in_content']) ? 'social-icon-in-content' : '';
            $nav_layout = (isset($settings['nav_layout'])) ? $settings['nav_layout'] : '';
            $nav_h_orientation = (isset($settings['navigation_horizontal_orientation'])) ? 'nav-h-orientation-' . $settings['navigation_horizontal_orientation'] : '';  //social_icons_hide_on_tablet
            //hide
            $nav_hide_on_tablet = ('yes' === ($settings['navigation_hide_on_tablet'])) ? 'nav-hide-tablet' : '';
            $nav_hide_on_mobile = ('yes' === ($settings['navigation_hide_on_mobile'])) ? 'nav-hide-mobile' : '';
            $nav_arrows_hide_on_tablet = ('yes' === ($settings['navigation_arrows_hide_on_tablet'])) ? 'nav-arrows-hide-tablet' : '';
            $nav_arrows_hide_on_mobile = ('yes' === ($settings['navigation_arrows_hide_on_mobile'])) ? 'nav-arrows-hide-mobile' : '';
            $social_icons_hide_on_tablet = ('yes' === ($settings['social_icons_hide_on_tablet'])) ? 'soc-icons-hide-tablet' : '';
            $social_icons_hide_on_mobile = ('yes' === ($settings['social_icons_hide_on_mobile'])) ? 'soc-icons-hide-mobile' : '';

            $slider_mask = (isset($settings['slider_mask'])) ? $settings['slider_mask'] : '';
            $slideshow = ('yes' === ($settings['data_slideshow'])) ? true : false;
            $loop = ('yes' === ($settings['data_animationloop'])) ? true : false;
            $pauseonhover = ('yes' === ($settings['data_pauseonhover'])) ? true : false;

            //animation duration  
            $slide_layer_1_image_animation_duration = (!empty($settings['slide_layer_1_image_animation_duration'])) ? $settings['slide_layer_1_image_animation_duration'] : '';
            $slide_layer_2_image_animation_duration = (!empty($settings['slide_layer_2_image_animation_duration'])) ? $settings['slide_layer_2_image_animation_duration'] : '';
            $slide_layer_1_animation_duration = (!empty($settings['slide_layer_1_animation_duration'])) ? $settings['slide_layer_1_animation_duration'] : '';
            $slide_divider_animation_duration = (!empty($settings['slide_divider_animation_duration'])) ? $settings['slide_divider_animation_duration'] : '';
            $slide_layer_2_animation_duration = (!empty($settings['slide_layer_2_animation_duration'])) ? $settings['slide_layer_2_animation_duration'] : '';
            $slide_layer_3_animation_duration = (!empty($settings['slide_layer_3_animation_duration'])) ? $settings['slide_layer_3_animation_duration'] : '';
            $slide_layer_4_animation_duration = (!empty($settings['slide_layer_4_animation_duration'])) ? $settings['slide_layer_4_animation_duration'] : '';
            $slide_layer_5_animation_duration = (!empty($settings['slide_layer_5_animation_duration'])) ? $settings['slide_layer_5_animation_duration'] : '';
            $slide_layer_6_animation_duration = (!empty($settings['slide_layer_6_animation_duration'])) ? $settings['slide_layer_6_animation_duration'] : '';
            $slide_layer_7_animation_duration = (!empty($settings['slide_layer_7_animation_duration'])) ? $settings['slide_layer_7_animation_duration'] : '';
            $slide_button_animation_duration = (!empty($settings['slide_button_animation_duration'])) ? $settings['slide_button_animation_duration'] : '';

            //animation delay  
            $layer1imagedelay = (!empty($settings['slide_layer_1_image_animation_delay'])) ? $settings['slide_layer_1_image_animation_delay'] : '';
            $layer2imagedelay = (!empty($settings['slide_layer_2_image_animation_delay'])) ? $settings['slide_layer_2_image_animation_delay'] : '';
            $layer1delay = (!empty($settings['slide_layer_1_animation_delay'])) ? $settings['slide_layer_1_animation_delay'] : '';
            $dividerdelay = (!empty($settings['slide_divider_animation_delay'])) ? $settings['slide_divider_animation_delay'] : '';
            $layer2delay = (!empty($settings['slide_layer_2_animation_delay'])) ? $settings['slide_layer_2_animation_delay'] : '';
            $layer3delay = (!empty($settings['slide_layer_3_animation_delay'])) ? $settings['slide_layer_3_animation_delay'] : '';
            $layer4delay = (!empty($settings['slide_layer_4_animation_delay'])) ? $settings['slide_layer_4_animation_delay'] : '';
            $layer5delay = (!empty($settings['slide_layer_5_animation_delay'])) ? $settings['slide_layer_5_animation_delay'] : '';
            $layer6delay = (!empty($settings['slide_layer_6_animation_delay'])) ? $settings['slide_layer_6_animation_delay'] : '';
            $layer7delay = (!empty($settings['slide_layer_7_animation_delay'])) ? $settings['slide_layer_7_animation_delay'] : '';
            $buttondelay = (!empty($settings['slide_button_animation_delay'])) ? $settings['slide_button_animation_delay'] : '';
            ?>
            <div class="flexslider main-slider <?php echo esc_attr($social_icon_in_content . ' ' . $nav_layout . ' ' . $nav_h_orientation . ' ' . $nav_arrows_hide_on_tablet . ' ' . $nav_arrows_hide_on_mobile . ' ' . $nav_hide_on_tablet . ' ' . $nav_hide_on_mobile . ' ' . $slider_mask); ?>" data-slideshow="<?php echo esc_attr($slideshow) ?>" data-slideshowspeed="<?php echo esc_attr($settings['data_speed']) ?>" data-animationloop="<?php echo esc_attr($loop) ?>" data-animation="<?php echo esc_attr($settings['data_animation']) ?>" data-pauseonhover="<?php echo esc_attr($pauseonhover) ?>" data-nav="<?php echo esc_attr($settings['data_nav']) ?>" data-dots="<?php echo esc_attr($settings['data_nav']) ?>" data-layer1animation="<?php echo esc_attr($settings['slide_layer_1_animation']) ?>" data-divideranimation="<?php echo esc_attr($settings['slide_divider_animation']) ?>" data-layer2animation="<?php echo esc_attr($settings['slide_layer_2_animation']) ?>" data-layer3animation="<?php echo esc_attr($settings['slide_layer_3_animation']) ?>" data-layer4animation="<?php echo esc_attr($settings['slide_layer_4_animation']) ?>" data-layer5animation="<?php echo esc_attr($settings['slide_layer_5_animation']) ?>" data-layer6animation="<?php echo esc_attr($settings['slide_layer_6_animation']) ?>" data-layer7animation="<?php echo esc_attr($settings['slide_layer_7_animation']) ?>" data-buttonanimation="<?php echo esc_attr($settings['slide_button_animation']) ?>" data-layer1imageanimation="<?php echo esc_attr($settings['slide_layer_1_image_animation']) ?>" data-layer2imageanimation="<?php echo esc_attr($settings['slide_layer_2_image_animation']) ?>" data-layer1imagedelay="<?php echo esc_attr($layer1imagedelay) ?>" data-layer2imagedelay="<?php echo esc_attr($layer2imagedelay) ?>" data-layer1delay="<?php echo esc_attr($layer1delay) ?>" data-dividerdelay="<?php echo esc_attr($dividerdelay) ?>" data-layer2delay="<?php echo esc_attr($layer2delay) ?>" data-layer3delay="<?php echo esc_attr($layer3delay) ?>" data-layer4delay="<?php echo esc_attr($layer4delay) ?>" data-layer5delay="<?php echo esc_attr($layer5delay) ?>" data-layer6delay="<?php echo esc_attr($layer6delay) ?>" data-layer7delay="<?php echo esc_attr($layer7delay) ?>" data-buttondelay="<?php echo esc_attr($buttondelay) ?>">
                <ul class="slides">
                    <?php
                    foreach ($settings['main_slider'] as $index => $item) {
                        $overlay = ('none' !== $item['slide_overlay']) ? $item['slide_overlay'] : '';
                    ?>
                        <li class="<?php echo esc_attr($overlay) ?>">
                            <?php if (!empty($item['background_text'])) {
                                $bg_text_hide_on_tablet = ('yes' === ($item['background_text_hide_on_tablet'])) ? 'bg-text-hide-tablet' : '';
                                $bg_text_hide_on_mobile = ('yes' === ($item['background_text_hide_on_mobile'])) ? 'bg-text-hide-mobile' : '';
                            ?>
                                <div class="silde-title-full <?php echo esc_attr($bg_text_hide_on_tablet . ' ' . $bg_text_hide_on_mobile) ?>">
                                    <p><?php echo wp_kses_post($item['background_text']) ?></p>
                                </div>
                            <?php } ?>
                            <?php
                            $media_type = $item['media_type'];
                            //image
                            $size = [
                                'image_size' => 'custom',
                                'image_custom_dimension' => [
                                    'width' => 1920,
                                    'height' => 1120,
                                ],
                            ];
                            if ($media_type === 'image') {
                                $image_url = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['image']['id'], 'main_slider_thumbnail', $settings);
                                if (!$image_url && isset($item['image']['url'])) {
                                    $image_url = $item['image']['url'];
                                }
                                $image_html = '<img class="mwt-elementor-main-slider-image" src="' . esc_attr($image_url) . '" alt="' . esc_attr(\Elementor\Control_Media::get_image_alt($item['image'])) . '" />';
                                echo wp_kses_post($image_html);
                            }
                            //video
                            if ($media_type === 'video') {
                                $video_url = '';
                                if (isset($item['video']['url'])) {
                                    $video_url = $item['video']['url'];
                                }
                            ?>
                                <video class="elementor-video mwt-elementor-main-slider-video" autoplay loop muted style="width:100%; height:100%;">
                                    <source src="<?php echo esc_url($video_url); ?>" type="video/mp4" />
                                    <p class="vjs-no-js"><?php esc_html_e('Please enable JavaScript', 'mwt-addons-for-elementor') ?></p>
                                </video>
                            <?php
                            }
                            $middle_hide_on_tablet = ('yes' === ($item['image_layer_middle_hide_on_tablet'])) ? 'middle-hide-tablet' : '';
                            $middle_hide_on_mobile = ('yes' === ($item['image_layer_middle_hide_on_mobile'])) ? 'middle-hide-mobile' : '';
                            $upper_hide_on_tablet = ('yes' === ($item['image_layer_upper_hide_on_tablet'])) ? 'upper-hide-tablet' : '';
                            $upper_hide_on_mobile = ('yes' === ($item['image_layer_upper_hide_on_mobile'])) ? 'upper-hide-mobile' : '';
                            $slide_image_layer_middle_position = (!empty($item['slide_image_layer_middle_position'])) ? $item['slide_image_layer_middle_position'] : 'layer_middle_center';
                            $slide_image_layer_upper_position = (!empty($item['slide_image_layer_upper_position'])) ? $item['slide_image_layer_upper_position'] : 'layer_middle_center';
                            //image_layer_middle
                            if ('yes' === $item['add_image_layer_middle'] && isset($item['image_layer_middle']['url'])) {
                                $image_middle_url = $item['image_layer_middle']['url'];
                                $image_middle_html = '<img class="mwt-elementor-main-slider-image-middle mwt-elementor-main-slider-image-animation ' . esc_attr($slide_image_layer_middle_position . ' ' . $slide_layer_1_image_animation_duration . ' ' . $middle_hide_on_tablet . ' ' . $middle_hide_on_mobile) . '" src="' . esc_attr($image_middle_url) . '" alt="' . esc_attr(\Elementor\Control_Media::get_image_alt($item['image_layer_middle'])) . '" />';
                                echo wp_kses_post($image_middle_html);
                            }
                            //image_layer_upper
                            if ('yes' === $item['add_image_layer_upper'] && isset($item['image_layer_upper']['url'])) {
                                $image_upper_url = $item['image_layer_upper']['url'];
                                $image_upper_html = '<img class="mwt-elementor-main-slider-image-upper mwt-elementor-main-slider-image-animation ' . esc_attr($slide_image_layer_upper_position . ' ' . $slide_layer_2_image_animation_duration  . ' ' . $upper_hide_on_tablet . ' ' . $upper_hide_on_mobile) . '" src="' . esc_attr($image_upper_url) . '" alt="' . esc_attr(\Elementor\Control_Media::get_image_alt($item['image_layer_upper'])) . '" />';
                                echo wp_kses_post($image_upper_html);
                            }
                            $full_width = ('full_width' === $settings['slider_content_width']) ? '-fluid' : '';
                            ?>
                            <div class="container<?php echo esc_attr($full_width); ?> slider-content intro_layers">
                                <div class="slide_description_wrapper">
                                    <div class="slide_description">
                                        <div class="slide_layers">
                                            <?php
                                            //layer #1
                                            if ($item['slide_layer_1']) {
                                                $layer_1 = $item['slide_layer_1'];
                                                $layer_1_tag = $item['slide_layer_1_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_1_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-1 ' . esc_attr($slide_layer_1_animation_duration) . '">' . wp_kses_post($layer_1) . '</' . \Elementor\Utils::validate_html_tag($layer_1_tag) . '>';
                                            }
                                            //Divider
                                            if ('yes' === $settings['slide_show_divider']) {
                                                echo '<div class="mwt-elementor-main-slider-divider ' . esc_attr($slide_divider_animation_duration) . '"><span class="divider-separator"></span></div>';
                                            }
                                            //layer #2
                                            if ($item['slide_layer_2']) {
                                                $layer_2 = $item['slide_layer_2'];
                                                $layer_2_tag = $item['slide_layer_2_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_2_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-2 ' . esc_attr($slide_layer_2_animation_duration) . '">' . wp_kses_post($layer_2) . '</' . \Elementor\Utils::validate_html_tag($layer_2_tag) . '>';
                                            }
                                            //layer #3
                                            if ($item['slide_layer_3']) {
                                                $layer_3 = $item['slide_layer_3'];
                                                $layer_3_tag = $item['slide_layer_3_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_3_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-3 ' . esc_attr($slide_layer_3_animation_duration) . '">' . wp_kses_post($layer_3) . '</' . \Elementor\Utils::validate_html_tag($layer_3_tag) . '>';
                                            }
                                            //layer #4
                                            if ($item['slide_layer_4']) {
                                                $layer_4 = $item['slide_layer_4'];
                                                $layer_4_tag = $item['slide_layer_4_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_4_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-4 ' . esc_attr($slide_layer_4_animation_duration) . '">' . wp_kses_post($layer_4) . '</' . \Elementor\Utils::validate_html_tag($layer_4_tag) . '>';
                                            }

                                            //layer #5
                                            if ($item['slide_layer_5']) {
                                                $layer_5 = $item['slide_layer_5'];
                                                $layer_5_tag = $item['slide_layer_5_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_5_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-5 ' . esc_attr($slide_layer_5_animation_duration) . '">' . wp_kses_post($layer_5) . '</' . \Elementor\Utils::validate_html_tag($layer_5_tag) . '>';
                                            }

                                            //layer #6
                                            if ($item['slide_layer_6']) {
                                                $layer_6 = $item['slide_layer_6'];
                                                $layer_6_tag = $item['slide_layer_6_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_6_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-6 ' . esc_attr($slide_layer_6_animation_duration) . '">' . wp_kses_post($layer_6) . '</' . \Elementor\Utils::validate_html_tag($layer_6_tag) . '>';
                                            }

                                            //layer #7
                                            if ($item['slide_layer_7']) {
                                                $layer_7 = $item['slide_layer_7'];
                                                $layer_7_tag = $item['slide_layer_7_tag'];
                                                echo '<' . \Elementor\Utils::validate_html_tag($layer_7_tag) . ' ' . 'class="mwt-elementor-main-slider-layer-7 ' . esc_attr($slide_layer_7_animation_duration) . '">' . wp_kses_post($layer_7) . '</' . \Elementor\Utils::validate_html_tag($layer_7_tag) . '>';
                                            }
                                            //button
                                            if ($item['slide_button'] || $item['slide_button_2']) {
                                                echo '<div class="mwt-elementor-main-slider-buttons-wrap ' . esc_attr($slide_button_animation_duration) . '">';
                                                if ($item['slide_button']) {
                                                    echo '<a class="mwt-elementor-main-slider-button ' . esc_attr($settings['slide_button_layout']) . '" href="' . esc_url($item['slide_button_link']['url']) . '">' . esc_html($item['slide_button']) . '</a> ';
                                                }
                                                if ($item['slide_button_2']) {
                                                    echo '<a class="mwt-elementor-main-slider-button-2 ' . esc_attr($settings['slide_button_2_layout']) . '" href="' . esc_url($item['slide_button_2_link']['url']) . '">' . esc_html($item['slide_button_2']) . '</a> ';
                                                }
                                                echo '</div>';
                                            }


                                            //social icons
                                            if ('yes' === $settings['social_icon_in_content']) {
                                                $social_sites = array(
                                                    'facebook'  => 'fa fa-facebook-f',
                                                    'twitter'   => 'fa fa-twitter',
                                                    'linkedin'  => 'fa fa-linkedin',
                                                    'youtube'   => 'fa fa-youtube',
                                                    'instagram' => 'fa fa-instagram',
                                                    'pinterest' => 'fa fa-pinterest',
                                                    'dribbble'  => 'fa fa-dribbble',
                                                    'behance'   => 'fa fa-behance',
                                                    'telegram'  => 'fa fa-telegram',
                                                ); ?>
                                                <ul class="slider-social-list <?php echo esc_attr($social_icons_hide_on_tablet . ' ' . $social_icons_hide_on_mobile) ?>">
                                                    <?php
                                                    foreach ($social_sites as $site => $icon) {
                                                        $value = $settings['icon_' . $site];

                                                        if (!empty($value)) {
                                                            $icon_class = sprintf('elementor-icon slider-list-item icon-%s', $site); ?>
                                                            <li class="<?php echo esc_attr($icon_class); ?>">
                                                                <a href="<?php echo esc_url($value); ?>" target="_blank">
                                                                    <i class="<?php echo esc_attr($icon); ?>"></i>
                                                                </a>
                                                            </li>
                                                    <?php
                                                        }
                                                    } ?>
                                                </ul>
                                            <?php } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php
                            //social icons
                            if ('yes' !== $settings['social_icon_in_content']) {
                                $social_sites = array(
                                    'facebook'  => 'fa fa-facebook-f',
                                    'twitter'   => 'fa fa-twitter',
                                    'linkedin'  => 'fa fa-linkedin',
                                    'youtube'   => 'fa fa-youtube',
                                    'instagram' => 'fa fa-instagram',
                                    'pinterest' => 'fa fa-pinterest',
                                    'dribbble'  => 'fa fa-dribbble',
                                    'behance'   => 'fa fa-behance',
                                    'telegram'  => 'fa fa-telegram',
                                ); ?>
                                <ul class="slider-social-list <?php echo esc_attr($social_icons_hide_on_tablet . ' ' . $social_icons_hide_on_mobile) ?>">
                                    <?php
                                    foreach ($social_sites as $site => $icon) {
                                        $value = $settings['icon_' . $site];

                                        if (!empty($value)) {
                                            $icon_class = sprintf('elementor-icon slider-list-item icon-%s', $site); ?>
                                            <li class="<?php echo esc_attr($icon_class); ?>">
                                                <a href="<?php echo esc_url($value); ?>" target="_blank">
                                                    <i class="<?php echo esc_attr($icon); ?>"></i>
                                                </a>
                                            </li>
                                    <?php
                                        }
                                    } ?>
                                </ul>
                            <?php } ?>
                        </li>
                    <?php } ?>
                </ul>
            </div>
            <?php
            if ('yes' === $settings['scroll_button_show']) {
                if ('layout-1' === $settings['scroll_button_layout']) { ?>
                    <div class="mwt-elementor-main-slider-scroll-icon">
                        <a href="<?php echo esc_url($settings['scroll_button_link']['url']); ?>" class="svg-icon icon-mouse">
                            <svg width="40" height="60" viewBox="0 0 40 60" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M37 20V40C37 49.3888 29.3888 57 20 57C10.6112 57 3 49.3888 3 40V20C3 10.6112 10.6112 3 20 3C29.3888 3 37 10.6112 37 20ZM0 20C0 8.9543 8.95431 0 20 0C31.0457 0 40 8.95431 40 20V40C40 51.0457 31.0457 60 20 60C8.95431 60 0 51.0457 0 40V20ZM22 15C22 13.8954 21.1046 13 20 13C18.8954 13 18 13.8954 18 15V25C18 26.1046 18.8954 27 20 27C21.1046 27 22 26.1046 22 25V15Z"></path>
                            </svg>
                        </a>
                    </div>
                <?php }
                if ('layout-2' === $settings['scroll_button_layout']) { ?>
                    <div class="mwt-elementor-main-slider-scroll-text">
                        <a href="<?php echo esc_url($settings['scroll_button_link']['url']); ?>">
                            <?php echo esc_html($settings['scroll_button_text']) ?>
                        </a>
                    </div>
                <?php }
                if ('layout-3' === $settings['scroll_button_layout']) { ?>
                    <div class="mwt-elementor-main-slider-scroll-icon-chevron">
                        <a href="<?php echo esc_url($settings['scroll_button_link']['url']); ?>" class="svg-icon icon-chevron-down">
                            <svg xmlns="http://www.w3.org/2000/svg" width="1024" height="1024" viewBox="0 0 1024 1024" fill="none">
                                <path d="M879.002 312.781c13.926-13.722 36.301-13.722 50.125 0s13.875 35.891 0 49.613l-404.89 400.896c-13.824 13.722-36.198 13.722-50.125 0l-404.89-400.896c-13.824-13.722-13.824-35.891 0-49.613 13.875-13.722 36.301-13.722 50.125 0l379.853 365.619 379.802-365.619z"></path>
                            </svg>
                        </a>
                    </div>
                <?php } ?>
            <?php
            }
            ?>
        </div>
<?php }
}
