<?php

/**
 * Elementor extended support
 *
 * @package WordPress
 * @subpackage MWT Addons for Elementor
 * @since 1.0.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

////////
//Tabs//
////////
//Create new Tab styles sections
//to remove unneeded sections we can use same action but 'before_section_end' at the end
add_action('elementor/element/tabs/section_tabs_style/after_section_end', function ($element) {

	//Modify title
	$element->start_controls_section(
		'section_tabs_title_style',
		[
			'label' => esc_html__('Title', 'mwt-addons-for-elementor'),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);
	$element->add_responsive_control(
		'title_spacing',
		[
			'label'      => __('Spacing', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-tabs-wrapper'  => 'border-collapse: separate; border-spacing: {{SIZE}}{{UNIT}} 0; margin-left: -{{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .elementor-tab-mobile-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			],
		]
	);
	$element->add_responsive_control(
		'title_nav_padding',
		[
			'label' => esc_html__('Title Nav Bar Padding', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tabs-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_control(
		'title_hover_color',
		[
			'label' => esc_html__('Hover Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title:hover a' => 'color: {{VALUE}};',
				'{{WRAPPER}} .elementor-tab-title:hover' => 'color: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_background_color',
		[
			'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title' => 'background-color: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_hover_background_color',
		[
			'label' => esc_html__('Hover Background Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title:hover' => 'background-color: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_active_background_color',
		[
			'label' => esc_html__('Active Background Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_hover_border_color',
		[
			'label' => esc_html__('Hover Border Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title:hover' => 'border-color: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_active_border_color',
		[
			'label' => esc_html__('Active Border Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title.elementor-active' => 'border-color: {{VALUE}};',
			],
		]
	);
	$element->add_responsive_control(
		'title_padding',
		[
			'label' => esc_html__('Title Padding', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'title_border',
			'selector' => '{{WRAPPER}} .elementor-tab-title',
		]
	);
	$element->add_responsive_control(
		'title_border_radius',
		[
			'label' => esc_html__('Title Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_group_control(
		Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'title_box_shadow',
			'selector' => '{{WRAPPER}} .elementor-tab-title',
		]
	);
	$element->add_responsive_control(
		'title_transition',
		[
			'label'      => __('Transition', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['s'],
			'range' => [
				's' => [
					'min' => 0,
					'max' => 1,
					'step' => 0.1,
				],
			],
			'default' => [
				'unit' => 's',
				'size' => 0.15,
			],
			'selectors'  => [
				'{{WRAPPER}} .elementor-tab-title'  => 'transition: all {{SIZE}}{{UNIT}} linear;',
			],
		]
	);
	$element->end_controls_section();

	//Modify content
	$element->start_controls_section(
		'section_tabs_content_style',
		[
			'label' => esc_html__('Content', 'mwt-addons-for-elementor'),
			'tab' => Controls_Manager::TAB_STYLE,
		]
	);
	$element->add_responsive_control(
		'content_margin',
		[
			'label' => esc_html__('Content Margin', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tabs-content-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_control(
		'content_background_color',
		[
			'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-content' => 'background-color: {{VALUE}};',
			],
		]
	);
	$element->add_responsive_control(
		'content_padding',
		[
			'label' => esc_html__('Content Padding', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'content_border',
			'selector' => '{{WRAPPER}} .elementor-tab-content',
		]
	);
	$element->add_responsive_control(
		'content_border_radius',
		[
			'label' => esc_html__('Content Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				'{{WRAPPER}} .elementor-tabs-content-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_group_control(
		Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'content_box_shadow',
			'selector' => '{{WRAPPER}} .elementor-tab-content',
		]
	);
	$element->end_controls_section();
});

///////////
//Counter//
///////////
//Extend Counter Number
add_action('elementor/element/counter/section_number/before_section_end', function ($element) {
	$element->add_control(
		'prefix_grow',
		[
			'label' => esc_html__('Prefix Grow', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'size_units' => [''],
			'default' => [
				'unit' => '',
				'size' => 1,
			],
			'range' => [
				'' => [
					'min' => 0,
					'max' => 10,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-counter-number-prefix' => 'flex-grow: {{SIZE}};',
			],
		]
	);
	$element->add_control(
		'suffix_grow',
		[
			'label' => esc_html__('Suffix Grow', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'size_units' => [''],
			'default' => [
				'unit' => '',
				'size' => 1,
			],
			'range' => [
				'' => [
					'min' => 0,
					'max' => 10,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-counter-number-suffix' => 'flex-grow: {{SIZE}};',
			],
		]
	);
});
//Extend Counter Title
add_action('elementor/element/counter/section_title/before_section_end', function ($element) {
	$element->add_control(
		'text_align',
		[
			'label' => esc_html__('Text Align', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
					'icon' => 'eicon-text-align-left',
				],
				'center' => [
					'title' => esc_html__('Center', 'mwt-addons-for-elementor'),
					'icon' => 'eicon-text-align-center',
				],
				'right' => [
					'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
					'icon' => 'eicon-text-align-right',
				],
				'justify' => [
					'title' => esc_html__('Justified', 'mwt-addons-for-elementor'),
					'icon' => 'eicon-text-align-justify',
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-counter-title' => 'text-align: {{VALUE}};',
			],
		]
	);
});

/////////////
//Icon List//
/////////////
//Extend Icon List Icon Options
add_action('elementor/element/icon-list/section_icon_list/before_section_end', function ($element) {

	$element->remove_control('space_between');

	$element->add_responsive_control(
		'space_between',
		[
			'label'      => __('Bottom Spacing', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-icon-list-item'  => 'margin-bottom: {{SIZE}}{{UNIT}}',
			],
		]
	);

	$element->add_responsive_control(
		'item_padding',
		[
			'label' => esc_html__('Padding', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'item_border',
			'selector' => '{{WRAPPER}} .elementor-icon-list-item',
		]
	);
	$element->add_responsive_control(
		'item_border_radius',
		[
			'label' => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_control(
		'item_background_color',
		[
			'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-item' => 'background-color: {{VALUE}};',
			],
		]
	);
	$element->add_group_control(
		\Elementor\Group_Control_Box_Shadow::get_type(),
		[
			'name'     => 'outer_item_shadow',
			'selector' => '{{WRAPPER}} .elementor-icon-list-item',
		]
	);
});
add_action('elementor/element/icon-list/section_icon_style/before_section_end', function ($element) {
	$element->add_responsive_control(
		'icon_padding',
		[
			'label' => esc_html__('Icon Padding', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_control(
		'icon_spacing',
		[
			'label' => esc_html__('Spacing', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 60,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
			],
		]
	);
	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'icon_border',
			'selector' => '{{WRAPPER}} .elementor-icon-list-icon',
		]
	);
	$element->add_responsive_control(
		'border_radius',
		[
			'label' => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
	$element->add_control(
		'icon_background_color',
		[
			'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-list-icon' => 'background-color: {{VALUE}};',
			],
		]
	);
});

//////////
//Toggle//
//////////
//Extend Toggle Widget Icon
add_action('elementor/element/toggle/section_toggle_style_icon/before_section_end', function ($element) {
	$element->add_control(
		'icon_size',
		[
			'label' => esc_html__('Size', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-toggle-icon' => 'font-size: {{SIZE}}{{UNIT}};',
			],
		]
	);
});
//Extend Toggle Widget Panel
add_action('elementor/element/toggle/section_toggle_style/before_section_end', function ($element) {
	//remove
	$element->remove_control('border_width');
	$element->remove_control('border_color');

	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'border',
			'selector' => '{{WRAPPER}} .elementor-toggle-item',
		]
	);

	$element->add_responsive_control(
		'border_radius',
		[
			'label' => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-toggle-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
});

/////////////
//Accordion//
/////////////
//Extend Accordion Widget Icon
add_action('elementor/element/accordion/section_toggle_style_icon/before_section_end', function ($element) {
	$element->remove_control('icon_space');
	$element->add_control(
		'icon_size',
		[
			'label' => esc_html__('Size', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion-icon' => 'font-size: {{SIZE}}{{UNIT}};',
			],
		]
	);
	$element->add_responsive_control(
		'icon_margin',
		[
			'label' => esc_html__('Margin', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
});
//Extend Accordion Widget Panel
add_action('elementor/element/accordion/section_title_style/before_section_end', function ($element) {
	//remove
	$element->remove_control('border_width');
	$element->remove_control('border_color');

	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'border',
			'selector' => '{{WRAPPER}} .elementor-accordion-item',
		]
	);

	$element->add_responsive_control(
		'border_radius',
		[
			'label' => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_group_control(
		Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'box_shadow',
			'selector' => '{{WRAPPER}} .elementor-accordion-item',
		]
	);

	$element->add_responsive_control(
		'margin_bottom',
		[
			'label' => esc_html__('Spacing', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 50,
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
			],
		]
	);
});
//Extend Accordion Title Panel
add_action('elementor/element/accordion/section_toggle_style_title/before_section_end', function ($element) {

	$element->add_responsive_control(
		'title_margin',
		[
			'label' => esc_html__('Margin', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'title_border',
			'selector' => '{{WRAPPER}} .elementor-tab-title',
		]
	);

	$element->add_responsive_control(
		'title_border_radius',
		[
			'label' => esc_html__('Border Radius', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::DIMENSIONS,
			'size_units' => ['px', '%', 'em'],
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);

	$element->add_control(
		'title_active_heading',
		[
			'label' => esc_html__('Active State', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::HEADING,
			'separator' => 'before',
		]
	);

	$element->add_control(
		'title_hover_color',
		[
			'label' => esc_html__('Hover Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title:hover .elementor-accordion-title' => 'color: {{VALUE}};',
			],
		]
	);

	$element->add_control(
		'title_hover_background',
		[
			'label' => esc_html__('Hover Background', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title:hover' => 'background-color: {{VALUE}};',
			],
		]
	);

	$element->add_control(
		'title_active_background',
		[
			'label' => esc_html__('Active Background', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title.elementor-active' => 'background-color: {{VALUE}};',
			],
		]
	);

	$element->add_group_control(
		Group_Control_Border::get_type(),
		[
			'name' => 'title_active_border',
			'selector' => '{{WRAPPER}} .elementor-tab-title.elementor-active',
		]
	);

	$element->add_control(
		'title_active_border_radius',
		[
			'label'      => esc_html__('Active Border Radius', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-tab-title.elementor-active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			],
		]
	);
});

//Extend Accordion Title Panel
add_action('elementor/element/accordion/section_title_style/before_section_end', function ($element) {

	$element->add_control(
		'title_icon_plus_minus_heading',
		[
			'label' => esc_html__('Plus/Minus Icon', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::HEADING,
			'separator' => 'before',
		]
	);

	$element->add_control(
		'icon_plus_minus',
		[
			'label' => esc_html__('Show Plus/Minus Icon', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'layout-1',
			'options' => [
				'block' => esc_html__('On', 'mwt-addons-for-elementor'),
				'none' => esc_html__('Off', 'mwt-addons-for-elementor'),
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title:after' => 'display: {{VALUE}};',
			],
		]
	);

	$element->add_control(
		'plus_minus_color',
		[
			'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title:after' => 'color: {{VALUE}};',
			],
			'condition' => [
				'icon_plus_minus' => 'block'
			]
		]
	);

	$element->add_control(
		'plus_minus_hover_color',
		[
			'label' => esc_html__('Hover Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title:hover::after' => 'color: {{VALUE}};',
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title.elementor-active:hover::after' => 'color: {{VALUE}};',
			],
			'condition' => [
				'icon_plus_minus' => 'block'
			]
		]
	);

	$element->add_control(
		'plus_minus_active_color',
		[
			'label' => esc_html__('Active Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title.elementor-active::after' => 'color: {{VALUE}};',
			],
			'condition' => [
				'icon_plus_minus' => 'block'
			]
		]
	);

	$element->add_responsive_control(
		'plus_minus_size',
		[
			'label' => esc_html__('Size', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 32,
				],
			],
			'default'    => [
				'unit' => 'px',
				'size' => 14,
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title:after' => 'font-size: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'icon_plus_minus' => 'block'
			]
		]
	);

	$element->add_responsive_control(
		'plus_minus_width',
		[
			'label' => esc_html__('Width', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::SLIDER,
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 120,
				],
			],
			'default'    => [
				'unit' => 'px',
				'size' => 60,
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title:after' => 'width: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'icon_plus_minus' => 'block'
			]
		]
	);

	$element->add_control(
		'plus_minus_align',
		[
			'label' => esc_html__('Align', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::CHOOSE,
			'options' => [
				'left' => [
					'title' => esc_html__('Left', 'mwt-addons-for-elementor'),
					'icon' => 'eicon-text-align-left',
				],
				'right' => [
					'title' => esc_html__('Right', 'mwt-addons-for-elementor'),
					'icon' => 'eicon-text-align-right',
				],
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-accordion .elementor-tab-title:after' => '{{VALUE}}: 0;',
			],
			'condition' => [
				'icon_plus_minus' => 'block'
			]
		]
	);
});

//Extend Accordion Icon Panel
add_action('elementor/element/accordion/section_toggle_style_icon/before_section_end', function ($element) {

	$element->add_control(
		'icon_hover_color',
		[
			'label' => esc_html__('Hover Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-tab-title:hover .elementor-accordion-icon i:before' => 'color: {{VALUE}};',
				'{{WRAPPER}} .elementor-tab-title.elementor-active:hover .elementor-accordion-icon i:before' => 'color: {{VALUE}};',
				'{{WRAPPER}} .elementor-tab-title:hover .elementor-accordion-icon svg' => 'fill: {{VALUE}};',
				'{{WRAPPER}} .elementor-tab-title.elementor-active:hover .elementor-accordion-icon svg' => 'fill: {{VALUE}};',
			],
		]
	);
});

/////////////
//Container//
/////////////
//Extend Container Height because Spacer Height in percentage don't work
add_action('elementor/element/container/section_layout_container/before_section_end', function ($element) {
	$element->update_control(
		'min_height',
		[
			'size_units' => ['px', 'vh', '%'],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 1440,
				],
				'vh' => [
					'min' => 0,
					'max' => 100,
				],
				'%' => [
					'min' => 1,
					'max' => 100,
				],
			],
		]
	);
});

///////////
//Heading//
//////////
//Create new Heading styles control
add_action('elementor/element/heading/section_title_style/before_section_end', function ($element) {

	//Modify heading
	$element->add_control(
		'title_hover_color',
		[
			'label' => esc_html__('Text Hover Color', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::COLOR,
			'separator' => 'before',
			'selectors' => [
				'{{WRAPPER}} .elementor-heading-title a:hover' => 'color: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_writing_mode',
		[
			'label' => esc_html__('Writing Mode', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'horizontal-tb',
			'options' => [
				'horizontal-tb' => esc_html__('Horizontal', 'mwt-addons-for-elementor'),
				'vertical-rl' => esc_html__('Vertical', 'mwt-addons-for-elementor'),
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-heading-title' => 'writing-mode: {{VALUE}};',
			],
		]
	);
	$element->add_control(
		'title_white_space',
		[
			'label' => esc_html__('White Space', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'normal',
			'options' => [
				'normal' => esc_html__('Default', 'mwt-addons-for-elementor'),
				'nowrap' => esc_html__('Nowrap', 'mwt-addons-for-elementor'),
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-heading-title' => 'white-space: {{VALUE}};',
			],
		]
	);

	$element->add_control(
		'title_text_stroke',
		[
			'label' => esc_html__('Text Stroke', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::SWITCHER,
			'return_value' => 'yes',
			'default' => 'no',
			'separator' => 'before',
		]
	);

	$element->add_control(
		'title_text_stroke_color',
		[
			'label' => esc_html__('Color', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-heading-title' => '-webkit-text-stroke-color: {{VALUE}};',
			],
			'condition' => [
				'title_text_stroke' => 'yes',
			]
		]
	);

	$element->add_control(
		'title_text_stroke_width',
		[
			'label' => esc_html__('Width', 'textdomain'),
			'type' => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['px', 'em', 'rem'],
			'range' => [
				'px' => [
					'min' => 1,
					'max' => 10,
					'step' => 1,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 1,
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-heading-title' => '	-webkit-text-stroke-width: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'title_text_stroke' => 'yes',
			]
		]
	);
});

///////////
//Button//
//////////
//Create new Button control
add_action('elementor/element/button/section_button/before_section_end', function ($element) {

	//Modify button
	$element->add_responsive_control(
		'min_width',
		[
			'label'      => __('Min Width', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'separator' => 'before',
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-button'  => 'min-width: {{SIZE}}{{UNIT}}',
			],
		]
	);
});

add_action('elementor/element/button/section_style/before_section_end', function ($element) {

	//Add Box Hover Shadow
	$element->add_group_control(
		\Elementor\Group_Control_Box_Shadow::get_type(),
		[
			'label' => esc_html__('Box Hover Shadow', 'mwt-addons-for-elementor'),
			'name' => 'button_hover_shadow',
			'selector' => '{{WRAPPER}} .elementor-button:hover',
		]
	);
	$element->add_control(
		'cursor_mode',
		[
			'label' => esc_html__('Cursor', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::SELECT,
			'default' => 'pointer',
			'options' => [
				'pointer' => esc_html__('Pointer', 'mwt-addons-for-elementor'),
				'default' => esc_html__('Default', 'mwt-addons-for-elementor'),
				'not-allowed' => esc_html__('Not-Allowed', 'mwt-addons-for-elementor'),
			],
			'selectors' => [
				'{{WRAPPER}} .elementor-button' => 'cursor: {{VALUE}};',
			],
		]
	);
});

///////////
//Icon Box//
//////////
//Create new Icon Box control
add_action('elementor/element/icon-box/section_style_content/before_section_end', function ($element) {

	//Modify icon box
	$element->add_control(
		'title_hover_color',
		[
			'label' => esc_html__('Title Hover Color', 'elementor'),
			'type' => Controls_Manager::COLOR,
			'separator' => 'before',
			'selectors' => [
				'{{WRAPPER}} .elementor-icon-box-title a:hover' => 'color: {{VALUE}};',
			],
		]
	);
});

///////////
//Image Box//
//////////
//Create new Image Box control
add_action('elementor/element/image-box/section_style_content/before_section_end', function ($element) {

	//Modify image box
	$element->add_control(
		'title_hover_color',
		[
			'label' => esc_html__('Title Hover Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'separator' => 'before',
			'selectors' => [
				'{{WRAPPER}} .elementor-image-box-title a:hover' => 'color: {{VALUE}};',
			],
		]
	);
});

add_action('elementor/element/image-box/section_style_image/before_section_end', function ($element) {

	$element->remove_control('image_size');
	//Modify image box
	$element->add_responsive_control(
		'image_width',
		[
			'label'      => __('Width', 'mwt-addons-for-elementor'),
			'type'       => Controls_Manager::SLIDER,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-image-box-wrapper .elementor-image-box-img'  => 'width: {{SIZE}}{{UNIT}};',
			],
		]
	);
});

/////////
//Icon//
////////
//Create new Box control
add_action('elementor/element/icon/section_style_icon/before_section_end', function ($element) {

	//Modify icon
	$element->add_group_control(
		Group_Control_Box_Shadow::get_type(),
		[
			'name' => 'icon_box_shadow',
			'selector' => '{{WRAPPER}} .elementor-icon',
		]
	);
});

/////////
//Video//
////////
//Create new Play Icon control
add_action('elementor/element/video/section_video_style/before_section_end', function ($element) {

	//Modify play icon
	$element->add_control(
		'play_icon_hover_color',
		[
			'label' => esc_html__('Hover Color', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-custom-embed-play:hover i' => 'color: {{VALUE}}; transition: all 0.2s ease-in-out 0s;',
			],
		]
	);

	$element->add_control(
		'play_icon_bg_size',
		[
			'label'      => __('Background Size', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-custom-embed-play i::before'  => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; display: flex; align-items: center; justify-content: center; transition: all 0.2s ease-in-out 0s;',
			],
		]
	);

	$element->add_control(
		'play_icon_border_radius',
		[
			'label'      => __('Border Radius', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['px', 'em', '%'],
			'selectors'  => [
				'{{WRAPPER}} .elementor-custom-embed-play i::before'  => 'border-radius: {{SIZE}}{{UNIT}};',
			],
		]
	);

	$element->add_control(
		'play_icon_bg_color',
		[
			'label' => esc_html__('Background Color', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-custom-embed-play i::before' => 'background-color: {{VALUE}};',
			],
		]
	);

	$element->add_control(
		'play_icon_bg_hover_color',
		[
			'label' => esc_html__('Background Hover Color', 'mwt-addons-for-elementor'),
			'type' => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-custom-embed-play:hover i::before' => 'background-color: {{VALUE}};',
			],
		]
	);
});

//////////
//Column//
/////////
//Create new Column control
add_action('elementor/element/column/section_border/before_section_end', function ($element) {

	//Modify Column
	$element->add_control(
		'column_hover_transition',
		[
			'label' => esc_html__('Transition Duration', 'elementor'),
			'type' => Controls_Manager::SLIDER,
			'separator' => 'before',
			'default' => [
				'size' => 0.3,
			],
			'range' => [
				'px' => [
					'max' => 3,
					'step' => 0.1,
				],
			],
			'selectors' => [
				'{{WRAPPER}} > .elementor-element-populated' => 'transition: border {{SIZE}}s, border-radius {{SIZE}}s, box-shadow {{SIZE}}s',
			],
		]
	);
});

//////////////////
//Image Carousel//
/////////////////
//Create new Image Carousel control
add_action('elementor/element/image-carousel/section_style_navigation/before_section_end', function ($element) {

	//Modify navigation
	$element->add_control(
		'arrows_active_heading',
		[
			'label' => esc_html__('Active Arrows', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::HEADING,
			'separator' => 'before',
		]
	);

	$element->add_control(
		'arrows_color_hover',
		[
			'label' => esc_html__('Hover Color', 'mwt-addons-for-elementor'),
			'type' => Controls_Manager::COLOR,
			'selectors' => [
				'{{WRAPPER}} .elementor-swiper-button.elementor-swiper-button-prev:hover, .elementor-swiper-button.elementor-swiper-button-next:hover' => 'color: {{VALUE}};',
			],
			'condition' => [
				'navigation' => ['arrows', 'both'],
			]
		]
	);

	$element->add_control(
		'arrows_transition',
		[
			'label'      => __('Transition', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['s'],
			'range' => [
				's' => [
					'min' => 0,
					'max' => 1,
					'step' => 0.1,
				],
			],
			'default' => [
				'unit' => 's',
				'size' => 0.15,
			],
			'selectors'  => [
				'{{WRAPPER}} .elementor-swiper-button.elementor-swiper-button-prev, .elementor-swiper-button.elementor-swiper-button-next'  => 'transition: all {{SIZE}}{{UNIT}} linear;',
			],
			'condition' => [
				'navigation' => ['arrows', 'both'],
			]
		]
	);

	$element->add_responsive_control(
		'arrows_offset',
		[
			'label'      => esc_html__('Arrows Offset', 'mwt-addons-for-elementor'),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => ['px', '%'],
			'range' => [
				'px' => [
					'min' => 0,
					'max' => 500,
					'step' => 1,
				],
				'%' => [
					'min' => 0,
					'max' => 100,
				],
			],
			'default' => [
				'unit' => 'px',
				'size' => 0,
			],
			'selectors'  => [
				'{{WRAPPER}} .elementor-swiper-button.elementor-swiper-button-prev'  => 'left: {{SIZE}}{{UNIT}};',
				'{{WRAPPER}} .elementor-swiper-button.elementor-swiper-button-next'  => 'right: {{SIZE}}{{UNIT}};',
			],
			'condition' => [
				'navigation' => ['arrows', 'both'],
			]
		]
	);
});
