<?php

/**
 * Single Event Meta (Organizer) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/organizer.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 */

$organizer_ids = tribe_get_organizer_ids();
$multiple = count($organizer_ids) > 1;

$phone = tribe_get_organizer_phone();
$email = tribe_get_organizer_email();
$website = tribe_get_organizer_website_link();
$website_title = tribe_events_get_organizer_website_title();
?>

<div class="tribe-events-meta-group tribe-events-meta-group-organizer">
	<h2 class="tribe-events-single-section-title"><?php echo tribe_get_organizer_label(!$multiple); ?></h2>
	<?php
	do_action('tribe_events_single_meta_organizer_section_start');

	foreach ($organizer_ids as $organizer) {
		if (!$organizer) {
			continue;
		}

	?>
		<div class="tribe-organizer">
			<?php echo tribe_get_organizer_link($organizer) ?>
		</div>
		<?php
	}

	if (!$multiple) { // only show organizer details if there is one
		if (!empty($phone)) {
		?>
			<div class="event-organizer-wrap">
				<strong class="tribe-organizer-tel-label">
					<?php esc_html_e('Phone:', 'the-events-calendar') ?>
				</strong>
				<span class="tribe-organizer-tel">
					<?php echo esc_html($phone); ?>
				</span>
			</div>
		<?php
		} //end if

		if (!empty($email)) {
		?>
			<div class="event-organizer-wrap">
				<strong class="tribe-organizer-email-label">
					<?php esc_html_e('Email:', 'the-events-calendar') ?>
				</strong>
				<span class="tribe-organizer-email">
					<?php echo esc_html($email); ?>
				</span>
			</div>
		<?php
		} //end if

		if (!empty($website)) {
		?>
			<?php if (!empty($website_title)) : ?>
				<span class="tribe-organizer-url-label">
					<?php echo esc_html($website_title) ?>
				</span>
			<?php endif; ?>
			<span class="tribe-organizer-url">
				<?php echo $website; ?>
			</span>
	<?php
		} //end if
	} //end if

	do_action('tribe_events_single_meta_organizer_section_end');
	?>
</div>