<?php

/**
 * The template for displaying all single posts.
 * Also used in the Customizer preview
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

if (have_posts()) :

	/* Start the Loop */
	while (have_posts()) :
		the_post();

		$flicker_layout = flicker_get_post_layout();
?>
		<div id="layout" class="layout-<?php echo esc_attr($flicker_layout); ?>">
			<?php
			get_template_part('template-parts/post/content-single', $flicker_layout);
			?>
		</div><!-- #layout -->
<?php

	endwhile; // End of the loop.

else :

	// If no content, include the "No posts found" template.
	get_template_part('template-parts/content', 'none');

endif; //have_posts
