<?php

/**
 * The template for displaying all default single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	flicker_post_thumbnail('flicker-default-post');
	?>
	<div class="item-content content-padding with-background bottom-rounded">

		<div class="entry-meta post-meta small-text greylinks">
			<?php
			if (
				!empty(flicker_option('blog_show_date'))
				|| !empty(flicker_option('blog_show_views'))
			) :
			?>
				<div class="meta-left">
					<?php
					flicker_entry_meta(true, false, false, false, false, true, true);
					?>
				</div>
			<?php
			endif;
			?>
			<?php
			if (
				!empty(flicker_option('blog_share_facebook', true))
				||
				!empty(flicker_option('blog_share_twitter', true))
				||
				!empty(flicker_option('blog_share_telegram', true))
				||
				!empty(flicker_option('blog_share_pinterest', true))
				||
				!empty(flicker_option('blog_share_linkedin', true))
			) :
				if (function_exists('flicker_share_this')) {
			?>
					<div class="entry-blog-share">
						<?php
						flicker_share_this();
						?>
					</div>
			<?php
				}
			endif;
			?>
		</div><!-- .entry-meta -->
		<header class="entry-header">
			<?php
			$flicker_show_title = !flicker_option('title_show_title', '') && get_the_title();
			if ($flicker_show_title) :
			?>
				<?php the_title('<h1 class="entry-title" itemprop="headline"><span>', '</span></h1>'); ?>
			<?php
			else :
				echo '<h4 class="hidden" itemscope="itemscope" itemprop="headline" itemtype="https://schema.org/Text">' . esc_html(get_the_title()) . '</h4>';
			endif; //show_title
			?>
			<hr>
			<div class="entry-meta ">
				<?php
				if (
					!empty(flicker_option('blog_show_author'))
					|| !empty(flicker_option('blog_show_categories'))
					|| !empty(flicker_option('blog_show_comments_link'))
				) :
				?>
					<?php
					flicker_entry_meta(false, true, true, false, true, false, false);
					?>
				<?php
				endif;
				?>
			</div><!-- .entry-meta -->
		</header><!-- .entry-header -->
		<div class="entry-content" itemprop="text">
			<?php
			the_content();

			wp_link_pages(
				flicker_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
		<?php
		if (!empty(flicker_option('blog_single_show_tags'))) : ?>
			<div class="entry-meta post-meta-footer">
				<?php flicker_entry_meta(false, false, false, true, false, false, false); ?>
			</div>
		<?php endif; ?>
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->
<?php

flicker_post_nav();

//bio
get_template_part('template-parts/post/bio');

flicker_related_posts(get_the_ID());


// If comments are open or we have at least one comment, load up the comment template.
if (comments_open() || get_comments_number()) {
	comments_template();
}
?>