<?php

/**
 * The template to display post author bio
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_author_id = get_the_author_meta('ID');

$flicker_show_bio   = flicker_option('blog_single_show_author_bio', true);
$flicker_author_bio = get_the_author_meta('description', $flicker_author_id);

if (empty($flicker_show_bio) || empty($flicker_author_bio)) {
	return;
}

//SEO additional fields
$flicker_twitter_url 	  = get_the_author_meta('twitter', $flicker_author_id);
$flicker_facebook_url     = get_the_author_meta('facebook', $flicker_author_id);
$flicker_linkedin_url     = get_the_author_meta('linkedin', $flicker_author_id);
$flicker_instagram_url    = get_the_author_meta('instagram', $flicker_author_id);
$flicker_youtube_url      = get_the_author_meta('youtube', $flicker_author_id);
$flicker_custom_image_url = get_the_author_meta('custom_profile_image', $flicker_author_id);
?>
<div class="author-meta content-padding with-background">
	<div class="side-item has-post-thumbnail">
		<div class="item-media">
			<?php
			if (!empty($flicker_custom_image_url)) {
				echo '<img src="' . esc_url($flicker_custom_image_url) . '" alt="' . esc_attr(get_the_author_meta('display_name', $flicker_author_id)) . '">';
			} else {
				echo get_avatar($flicker_author_id, 700);
			}
			?>
		</div><!-- eof .item-media -->
		<div class="item-content">
			<?php
			$flicker_about_word = flicker_option('blog_single_author_bio_about_word');
			if (!empty($flicker_about_word)) :
			?>
				<p class="about-author-heading">
					<?php echo esc_html($flicker_about_word); ?>
				</p>
			<?php endif; ?>
			<h5 class="author-name mt-0">
				<?php
				the_author();
				//echo wp_kses_post( get_the_author_meta( 'display_name', $flicker_author_id ) );
				?>
			</h5>
			<?php if (!empty($flicker_author_bio)) : ?>
				<p class="author-bio">
					<?php echo wp_kses_post($flicker_author_bio); ?>
				</p>
			<?php
			endif; //author_bio
			if ($flicker_twitter_url || $flicker_facebook_url || $flicker_linkedin_url || $flicker_instagram_url || $flicker_youtube_url) :
			?>
				<span class="social-links author-social">
					<?php

					if ($flicker_facebook_url) :
						flicker_social_link_2('facebook', $flicker_facebook_url, '');
					endif;
					if ($flicker_twitter_url) :
						flicker_social_link_2('twitter', $flicker_twitter_url, '');
					endif;
					if ($flicker_instagram_url) :
						flicker_social_link_2('instagram', $flicker_instagram_url, '');
					endif;
					if ($flicker_linkedin_url) :
						flicker_social_link_2('linkedin', $flicker_linkedin_url, '');
					endif;
					if ($flicker_youtube_url) :
						flicker_social_link_2('youtube', $flicker_youtube_url, '');
					endif;
					?>
				</span><!-- eof .author-social -->
			<?php endif; //author social 
			?>
		</div><!-- eof .item-content -->
	</div><!-- eof author-meta -->
</div>
<?php
