<?php

/**
 * The main template file
 * Also used in the Customizer preview
 * It contains the index.php file but without header and footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_show_title = flicker_get_feed_shot_title();
$flicker_layout     = flicker_get_feed_layout();
$flicker_layout_gap = flicker_get_feed_gap();

//layout may contain columns count separated by space and 'masonry' word after columns count
$flicker_layout         = explode(' ', $flicker_layout);
$flicker_columns_number = (!empty($flicker_layout[1])) ? absint($flicker_layout[1]) : '';
$flicker_masonry        = (!empty($flicker_layout[2]) && 'masonry' === $flicker_layout[2]) ? true : false;
$flicker_grid_class     = (!empty($flicker_masonry)) ? 'masonry' : 'grid-wrapper';
$flicker_layout         = $flicker_layout[0];
$flicker_columns        = (!empty($flicker_columns_number)) ? true : false;

//additional css classes for #layout div element
$flicker_layout_class  = 'layout-' . $flicker_layout;
$flicker_layout_class .= !empty($flicker_columns) ? ' layout-cols-' . $flicker_columns_number : ' layout-cols-1';
$flicker_layout_class .= !empty($flicker_layout_gap) ? ' layout-gap-' . $flicker_layout_gap : ' layout-gap-default';

if (!empty($flicker_masonry)) {
	flicker_enqueue_masonry_action();
}

if (have_posts()) :
?>
	<div id="layout" class="<?php echo esc_attr($flicker_layout_class); ?>">
		<?php if (!empty($flicker_show_title)) : ?>
			<h1 class="archive-title">
				<span><?php get_template_part('template-parts/title/title-text'); ?></span>
			</h1>
		<?php
		endif; //show_title

		if (is_category()) :
			$flicker_category_description = category_description();
			if (!empty($flicker_category_description)) {
				echo '<div class="category-description">' . wp_kses_post($flicker_category_description) . '</div><!-- .category-description -->';
			}
		endif; //is_category

		if (!empty($flicker_columns)) :
			// read about masonry layout here:
			// https://masonry.desandro.com/options.html
			// https://github.com/desandro/masonry/issues/549
		?>
			<div class="grid-columns-wrapper">
				<div class="<?php echo esc_attr($flicker_grid_class); ?>">
					<div class="grid-sizer"></div>
				<?php
			endif; //columns

			// Load posts loop.
			while (have_posts()) :

				the_post();
				get_template_part('template-parts/blog/' . $flicker_layout . '/content', get_post_format());

			endwhile;

			if (!empty($flicker_columns)) :
				?>
				</div><!-- .<?php echo esc_html($flicker_grid_class); ?>-->
			</div><!-- .grid-columns-wrapper -->
		<?php
			endif; //columns 
		?>
		<?php
		// Previous/next page navigation.
		the_posts_pagination(
			flicker_get_the_posts_pagination_atts()
		);
		?> <?php
			?>
	</div><!-- #layout -->
<?php
else :

	// If no content, include the "No posts found" template.
	get_template_part('template-parts/content', 'none');

endif; //have_posts
