<?php

/**
 * The intro section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_intro_layout      = flicker_option('intro_layout', '');
$flicker_intro_fullscreen  = flicker_option('intro_fullscreen', '');
$flicker_intro_heading     = flicker_option('intro_heading', '');
$flicker_intro_description = flicker_option('intro_description', '');
$flicker_intro_shortcode   = flicker_option('intro_shortcode', '');

$flicker_extra_padding_top    = flicker_option('intro_extra_padding_top', '');
$flicker_extra_padding_bottom = flicker_option('intro_extra_padding_bottom', '');
$flicker_intro_background     = flicker_option('intro_background', '');
$flicker_intro_alignment      = flicker_option('intro_alignment', '');
$flicker_font_size            = flicker_option('intro_font_size', '');
$flicker_background_image     = flicker_section_background_image_array('intro');
$flicker_image            = flicker_option('intro_image', '');

$flicker_intro_background_image_scale_class = flicker_option('intro_background_image_scale', '') ? 'image-scale' : '';
$flicker_intro_background_image_absolute_class = flicker_option('intro_image_absolute', '') ? 'image-absolute' : '';

//buttons
$flicker_intro_button_text_first  = flicker_option('intro_button_text_first', '');
$flicker_intro_button_url_first   = flicker_option('intro_button_url_first', '');
$flicker_intro_button_text_second = flicker_option('intro_button_text_second', '');
$flicker_intro_button_url_second  = flicker_option('intro_button_url_second', '');

//animation
$flicker_intro_image_animation = flicker_option('intro_image_animation', '') ? 'animate an__' . flicker_option('intro_image_animation') : '';

//not showing intro if no content specified
if (
	empty($flicker_intro_heading)
	&&
	empty($flicker_intro_description)
	&&
	empty($flicker_intro_shortcode)
	&&
	empty($flicker_intro_button_text_first)
	&&
	empty($flicker_intro_button_text_second)
	&&
	empty($flicker_background_image['url'])
) {
	return;
}
//if fullscreen - adding class to font size
if (!empty($flicker_intro_fullscreen)) {
	$flicker_font_size .= ' screen';
}

//default layout is background image
switch ($flicker_intro_layout):
		//side image layout
	case 'image-left':
	case 'image-right':
?>
		<section id="intro" class="intro intro-section layout-gap-30 <?php echo esc_attr($flicker_font_size . ' ' . $flicker_intro_background . ' ' . $flicker_intro_alignment . ' ' . $flicker_intro_layout . ' ' . $flicker_intro_background_image_scale_class . ' ' . $flicker_intro_background_image_absolute_class . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (flicker_option('intro_social_links')) {
				flicker_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
				<div class="d-grid grid-2-cols">
					<div class="column">
						<?php if (!empty($flicker_image)) : ?>
							<div class="img-wrap">
								<img src="<?php echo esc_url($flicker_image); ?>" alt="<?php echo esc_attr($flicker_intro_heading); ?>" class="intro-image <?php echo esc_attr($flicker_intro_image_animation); ?>">
							</div>
						<?php endif; ?>
					</div>
					<div class="column intro-section-text">
						<?php
						get_template_part('template-parts/header/intro-text');
						?>
					</div><!-- .column -->
				</div><!-- .d-grid -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;

	case 'image-top':
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($flicker_font_size . ' ' . $flicker_intro_background . ' ' . $flicker_intro_alignment . ' ' . $flicker_intro_layout . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (flicker_option('intro_social_links')) {
				flicker_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
				<div class="column">
					<?php if (!empty($flicker_image)) : ?>
						<img src="<?php echo esc_url($flicker_image); ?>" alt="<?php echo esc_attr($flicker_intro_heading); ?>" class="intro-image <?php echo esc_attr($flicker_intro_image_animation); ?>">
					<?php endif; ?>
				</div>
				<div class="column intro-section-text">
					<?php
					get_template_part('template-parts/header/intro-text');
					?>
				</div><!-- .column -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;
	case 'image-bottom':
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($flicker_font_size . ' ' . $flicker_intro_background . ' ' . $flicker_intro_alignment . ' ' . $flicker_intro_layout . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (flicker_option('intro_social_links')) {
				flicker_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
				<div class="column intro-section-text">
					<?php
					get_template_part('template-parts/header/intro-text');
					?>
				</div><!-- .column -->
				<div class="column">
					<?php if (!empty($flicker_image)) : ?>
						<img src="<?php echo esc_url($flicker_image); ?>" alt="<?php echo esc_attr($flicker_intro_heading); ?>" class="intro-image <?php echo esc_attr($flicker_intro_image_animation); ?>">
					<?php endif; ?>
				</div><!-- .column -->
			</div><!-- .container -->
		</section><!-- #intro -->
	<?php
		break;
		//background image
	default:
	?>
		<section id="intro" class="intro intro-section <?php echo esc_attr($flicker_font_size . ' ' . $flicker_intro_background . ' ' . $flicker_intro_alignment . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
			<?php
			if (flicker_option('intro_social_links')) {
				flicker_social_links('intro-social-links-absolute');
			}
			?>
			<div class="container <?php echo esc_attr($flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
				<?php
				get_template_part('template-parts/header/intro-text');
				?>
			</div><!-- .container -->
		</section><!-- #intro -->
<?php
endswitch;//$flicker_intro_layout
