<?php

/**
 * The intro section text template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//text
$flicker_intro_pre_heading = flicker_option('intro_pre_heading', '');
$flicker_intro_heading     = flicker_option('intro_heading', '');
$flicker_intro_description = flicker_option('intro_description', '');
$flicker_intro_shortcode   = flicker_option('intro_shortcode', '');

//buttons
$flicker_intro_button_text_first  = flicker_option('intro_button_text_first', '');
$flicker_intro_button_url_first   = flicker_option('intro_button_url_first', '');
$flicker_intro_button_text_second = flicker_option('intro_button_text_second', '');
$flicker_intro_button_url_second  = flicker_option('intro_button_url_second', '');

//animation
//animate an__XXX
//intro_heading_animation
//intro_description_animation
//intro_button_first_animation
//intro_button_second_animation
//intro_shortcode_animation
$flicker_intro_pre_heading_animation   = flicker_option('intro_pre_heading_animation', '') ? 'animate an__' . flicker_option('intro_pre_heading_animation') : '';
$flicker_intro_heading_animation       = flicker_option('intro_heading_animation', '') ? 'animate an__' . flicker_option('intro_heading_animation') : '';
$flicker_intro_description_animation   = flicker_option('intro_description_animation', '') ? 'animate an__' . flicker_option('intro_description_animation') : '';
$flicker_intro_button_first_animation  = flicker_option('intro_button_first_animation', '') ? 'animate an__' . flicker_option('intro_button_first_animation') : '';
$flicker_intro_button_second_animation = flicker_option('intro_button_second_animation', '') ? 'animate an__' . flicker_option('intro_button_second_animation') : '';
$flicker_intro_shortcode_animation     = flicker_option('intro_shortcode_animation', '') ? 'animate an__' . flicker_option('intro_shortcode_animation') : '';


//not showing intro if no content specified
if (
	empty($flicker_intro_pre_heading)
	&&
	empty($flicker_intro_heading)
	&&
	empty($flicker_intro_description)
	&&
	empty($flicker_intro_shortcode)
	&&
	empty($flicker_intro_button_text_first)
	&&
	empty($flicker_intro_button_text_second)
) {
	return;
}

if (flicker_option('intro_social_links')) {
	flicker_social_links('intro-social-links');
}

if (!empty($flicker_intro_pre_heading)) :
	$flicker_intro_pre_heading_mt = flicker_option('intro_pre_heading_mt', '');
	$flicker_intro_pre_heading_mb = flicker_option('intro_pre_heading_mb', '');
?>
	<div class="intro-pre-heading <?php echo esc_attr($flicker_intro_pre_heading_animation . ' ' . $flicker_intro_pre_heading_mt . ' ' . $flicker_intro_pre_heading_mb); ?>">
		<?php echo wp_kses_post($flicker_intro_pre_heading); ?>
	</div>
<?php
endif; //intro_heading

if (!empty($flicker_intro_heading)) :
	$flicker_intro_heading_mt = flicker_option('intro_heading_mt', '');
	$flicker_intro_heading_mb = flicker_option('intro_heading_mb', '');
?>
	<h1 class="intro-heading <?php echo esc_attr($flicker_intro_heading_animation . ' ' . $flicker_intro_heading_mt . ' ' . $flicker_intro_heading_mb); ?>">
		<?php echo wp_kses_post($flicker_intro_heading); ?>
		<span class="intro-heading-duplicate d-none <?php echo esc_attr($flicker_intro_heading_animation . ' ' . $flicker_intro_heading_mt . ' ' . $flicker_intro_heading_mb); ?>">
			<?php echo wp_kses_post($flicker_intro_heading); ?>
		</span>
	</h1>

<?php
endif; //intro_heading

if (!empty($flicker_intro_description)) :
	$flicker_intro_description_mt = flicker_option('intro_description_mt', '');
	$flicker_intro_description_mb = flicker_option('intro_description_mb', '');
?>
	<div class="intro-description grey <?php echo esc_attr($flicker_intro_description_animation . ' ' . $flicker_intro_description_mt . ' ' . $flicker_intro_description_mb); ?>">
		<?php echo wp_kses_post($flicker_intro_description); ?>
	</div>
<?php
endif; //intro_description

if (!empty($flicker_intro_button_text_first) || !empty($flicker_intro_button_text_second)) :
	$flicker_intro_buttons_mt = flicker_option('intro_buttons_mt', '');
	$flicker_intro_buttons_mb = flicker_option('intro_buttons_mb', '');
?>
	<div class="intro-buttons <?php echo esc_attr($flicker_intro_buttons_mt . ' ' . $flicker_intro_buttons_mb); ?>">
		<?php if (!empty($flicker_intro_button_text_first)) : ?>
			<a class="theme_button wide_button color1 <?php echo esc_attr($flicker_intro_button_first_animation); ?>" href="<?php echo esc_url($flicker_intro_button_url_first); ?>"><?php echo esc_html($flicker_intro_button_text_first); ?></a>
		<?php endif; //intro_button_text_first 
		?>
		<?php if (!empty($flicker_intro_button_text_second)) : ?>
			<a class="theme_button wide_button color2 <?php echo esc_attr($flicker_intro_button_second_animation); ?>" href="<?php echo esc_url($flicker_intro_button_url_second); ?>"><?php echo esc_html($flicker_intro_button_text_second); ?></a>
		<?php endif; //intro_button_text_second 
		?>
	</div>
<?php
endif; //intro_heading
if (!empty($flicker_intro_shortcode)) :
	$flicker_intro_shortcode_mt = flicker_option('intro_shortcode_mt', '');
	$flicker_intro_shortcode_mb = flicker_option('intro_shortcode_mb', '');
?>
	<div class="intro-shortcode <?php echo esc_attr($flicker_intro_shortcode_animation . ' ' . $flicker_intro_shortcode_mt . ' ' . $flicker_intro_shortcode_mb); ?>">
		<?php echo do_shortcode($flicker_intro_shortcode); ?>
	</div>
<?php
endif; //intro_shortcode
