<?php

/**
 * The header template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
//options
$flicker_fluid             = flicker_option('header_fluid') ? '-fluid' : '';
$flicker_transparent       = flicker_option('header_transparent') ? 'transparent' : '';
$flicker_absolute          = flicker_option('header_absolute') ? 'absolute' : '';
$flicker_header_top_tall   = flicker_option('header_top_tall') ? 'header-tall' : '';
$flicker_sticky            = flicker_option('header_sticky');
$flicker_header_background = flicker_option('header_background', '');
$flicker_header_topline_bg = flicker_option('header_topline_background', 'l');
$flicker_font_size         = flicker_option('header_font_size', '');

$flicker_border_top    = flicker_option('header_border_top', '');
$flicker_border_bottom = flicker_option('header_border_bottom', '');

$flicker_toggler_side_in_header = flicker_option('header_toggler_menu_side', true);
$flicker_toggler_main_in_header = flicker_option('header_toggler_menu_main', true);

$flicker_header_align_main_menu = flicker_option('header_align_main_menu', '');
$flicker_header_has_menu_class  = has_nav_menu('primary') ? 'has-menu' : 'no-menu';

//button
$flicker_button_text    = flicker_option('header_button_text', '');
$flicker_button_url     = flicker_option('header_button_url', '');

$flicker_background_image = flicker_section_background_image_array('header');

?>
<?php
if (!empty($flicker_sticky)) :
?>
    <div id="header-affix-wrap" class="header-wrap <?php echo esc_attr($flicker_header_background . ' ' . $flicker_transparent . ' ' . $flicker_absolute); ?>">
    <?php endif; //$flicker_sticky 
    ?>
    <div id="overlay"></div>
    <header id="header" class="header header-1 <?php echo esc_attr($flicker_header_background . ' ' . $flicker_font_size . ' ' . $flicker_header_align_main_menu . ' ' . $flicker_sticky . ' ' . $flicker_transparent . ' ' . $flicker_absolute . ' ' . $flicker_header_top_tall . ' ' . $flicker_header_has_menu_class . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
        <?php
        if ('full' === $flicker_border_top) {
            echo wp_kses_post('<hr class="section-hr">');
        }
        ?>
        <?php
        if ('container' === $flicker_border_top) {
            echo wp_kses_post('<hr class="section-hr container">');
        }
        ?>
        <div class="container<?php echo esc_attr($flicker_fluid); ?>">
            <?php if (!empty($flicker_toggler_side_in_header) && (has_nav_menu('side') || is_active_sidebar('sidebar-side'))) : ?>
                <button id="nav_side_toggle" class="nav-btn" aria-controls="nav_side" aria-expanded="false" aria-label="<?php esc_attr_e('Side Menu Toggler', 'flicker'); ?>">
                    <span></span>
                </button>
            <?php
            endif; //toggler_side_in_header
            ?>
            <div class="logo-wrap">
                <?php
                get_template_part('template-parts/header/logo/logo', flicker_template_part('logo', '1'));
                ?>
            </div>
            <?php
            if (has_nav_menu('primary')) :
            ?>
                <nav id="nav_top" class="top-nav" aria-label="<?php esc_attr_e('Top Menu', 'flicker'); ?>">
                    <?php
                    if (has_nav_menu('primary')) :
                        $flicker_menu_css_class = flicker_get_menu_class_based_on_top_items_count('primary');
                        wp_nav_menu(
                            array(
                                'theme_location' => 'primary',
                                'menu_class'     => 'top-menu ' . $flicker_menu_css_class,
                                'container'      => false,
                            )
                        );
                    endif; //has_nav_menu
                    if (empty($flicker_toggler_main_in_header)) :
                    ?>
                        <button id="nav_toggle" class="nav-btn" aria-controls="nav_top" aria-expanded="false" aria-label="<?php esc_attr_e('Top Menu Toggler', 'flicker'); ?>">
                            <span></span>
                        </button>
                    <?php
                    //echo closing button if main button is inside header section
                    else :
                    ?>
                        <button id="nav_close" class="nav-btn" aria-controls="nav_top" aria-expanded="true" aria-label="<?php esc_attr_e('Top Menu Close', 'flicker'); ?>">
                            <span></span>
                        </button>
                    <?php endif; //toggler_main_in_header 
                    ?>
                </nav><!-- .top-nav -->
            <?php
            endif; //has_nav_menu 
            ?>
            <?php
            if ($flicker_button_text) : ?>
                <div class="btn-wrap">
                    <a href="<?php echo esc_attr($flicker_button_url) ?>" target="_self" class="theme_button color1 hidden-lg">
                        <span><?php echo esc_html($flicker_button_text); ?></span>
                    </a>
                </div>
            <?php endif;
            if (!empty($flicker_toggler_main_in_header) && has_nav_menu('primary')) :
            ?>
                <button id="nav_toggle" class="nav-btn" aria-controls="nav_top" aria-expanded="false" aria-label="<?php esc_attr_e('Top Menu Toggler', 'flicker'); ?>">
                    <span></span>
                </button>
            <?php endif; //toggler_main_in_header 
            ?>
        </div><!-- .container -->
        <?php
        if ('container' === $flicker_border_bottom) {
            echo wp_kses_post('<hr class="section-hr container">');
        }
        if ('full' === $flicker_border_bottom) {
            echo wp_kses_post('<hr class="section-hr">');
        }
        ?>
    </header><!-- #header -->
    <?php if (!empty($flicker_sticky)) : ?>
    </div>
    <!--#header-affix-wrap-->
<?php endif; //$flicker_sticky 
?>