<?php

/**
 * The footer top section template file
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

//text
$flicker_footer_top_heading     = flicker_option('footer_top_heading', '');
$flicker_footer_top_description = flicker_option('footer_top_description', '');
$flicker_footer_top_widget   = is_active_sidebar('sidebar-footer-top');
$flicker_footer_top_shortcode   = flicker_option('footer_top_shortcode', '');

if (
	empty($flicker_footer_top_heading)
	&&
	empty($flicker_footer_top_description)
	&&
	empty($flicker_footer_top_widget)
	&&
	empty($flicker_footer_top_shortcode)
) {
	return;
}

$flicker_fluid = flicker_option('footer_fluid') ? '-fluid' : '';

$flicker_footer_top_background = flicker_option('footer_top_background', '');
$flicker_extra_padding_top     = flicker_option('footer_top_extra_padding_top', '');
$flicker_extra_padding_bottom  = flicker_option('footer_top_extra_padding_bottom', '');

$flicker_border_top    = flicker_option('footer_top_border_top', '');
$flicker_border_bottom = flicker_option('footer_top_border_bottom', '');
$flicker_font_size     = flicker_option('footer_top_font_size', '');

$flicker_background_image = flicker_section_background_image_array('footer_top');

//animation
//animate an__XXX
//footer_top_heading_animation
//footer_top_description_animation
//footer_top_button_first_animation
//footer_top_button_second_animation
//footer_top_shortcode_animation
$flicker_footer_top_heading_animation       = flicker_option('footer_top_heading_animation', '') ? 'animate an__' . flicker_option('footer_top_heading_animation') : '';
$flicker_footer_top_description_animation   = flicker_option('footer_top_description_animation', '') ? 'animate an__' . flicker_option('footer_top_description_animation') : '';
$flicker_footer_top_button_first_animation  = flicker_option('footer_top_button_first_animation', '') ? 'animate an__' . flicker_option('footer_top_button_first_animation') : '';
$flicker_footer_top_button_second_animation = flicker_option('footer_top_button_second_animation', '') ? 'animate an__' . flicker_option('footer_top_button_second_animation') : '';
$flicker_footer_top_shortcode_animation     = flicker_option('footer_top_shortcode_animation', '') ? 'animate an__' . flicker_option('footer_top_shortcode_animation') : '';

?>
<section id="footer-top" class="footer-top footer-top-1 <?php echo esc_attr($flicker_footer_top_background . ' ' . $flicker_font_size . ' ' . $flicker_background_image['class']); ?>" <?php echo (!empty($flicker_background_image['url'])) ? 'style="background-image: url(' . esc_url($flicker_background_image['url']) . ');"' : ''; ?>>
	<?php
	if ('full' === $flicker_border_top) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
	<div class="container<?php echo esc_attr($flicker_fluid . ' ' . $flicker_extra_padding_top . ' ' . $flicker_extra_padding_bottom); ?>">
		<?php
		if ('container' === $flicker_border_top) {
			echo wp_kses_post('<hr class="section-hr">');
		}

		if (!empty($flicker_footer_top_heading)) :
			$flicker_footer_top_heading_mt = flicker_option('footer_top_heading_mt', '');
			$flicker_footer_top_heading_mb = flicker_option('footer_top_heading_mb', '');
		?>
			<h3 class="footer_top-heading has-medium-font-size <?php echo esc_attr($flicker_footer_top_heading_animation . ' ' . $flicker_footer_top_heading_mt . ' ' . $flicker_footer_top_heading_mb); ?>">
				<?php echo wp_kses_post($flicker_footer_top_heading); ?>
			</h3>
		<?php
		endif; //footer_top_heading

		if (!empty($flicker_footer_top_description)) :
			$flicker_footer_top_description_mt = flicker_option('footer_top_description_mt', '');
			$flicker_footer_top_description_mb = flicker_option('footer_top_description_mb', '');
		?>
			<div class="footer_top-description <?php echo esc_attr($flicker_footer_top_description_animation . ' ' . $flicker_footer_top_description_mt . ' ' . $flicker_footer_top_description_mb); ?>">
				<?php echo wp_kses_post($flicker_footer_top_description); ?>
			</div>
		<?php
		endif; //footer_top_description
		?>

		<div class="footer-top-widgets layout-gap-30">
			<div class="layout-cols-3 grid-wrapper">
				<?php
				dynamic_sidebar('sidebar-footer-top');
				?>
			</div>
		</div><!-- .footer-top-widgets> -->

		<?php
		if (!empty($flicker_footer_top_shortcode)) :
			$flicker_footer_top_shortcode_mt = flicker_option('footer_top_shortcode_mt', '');
			$flicker_footer_top_shortcode_mb = flicker_option('footer_top_shortcode_mb', '');
		?>
			<div class="footer_top-shortcode <?php echo esc_attr($flicker_footer_top_shortcode_animation . ' ' . $flicker_footer_top_shortcode_mt . ' ' . $flicker_footer_top_shortcode_mb); ?>">
				<?php echo do_shortcode($flicker_footer_top_shortcode); ?>
			</div>
		<?php
		endif; //footer_top_shortcode

		if ('container' === $flicker_border_bottom) {
			echo wp_kses_post('<hr class="section-hr">');
		}
		?>
	</div><!-- .container -->
	<?php
	if ('full' === $flicker_border_bottom) {
		echo wp_kses_post('<hr class="section-hr">');
	}
	?>
</section><!-- #footer -->