<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

$flicker_side_item = (!flicker_has_post_thumbnail()) ? '' : 'side-item content-padding with_background';

?>
<article id="post-<?php the_ID(); ?>" <?php post_class($flicker_side_item); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	flicker_post_thumbnail('flicker-square');
	?>
	<div class="item-content">
		<?php
		if (!empty(flicker_option('blog_show_date')) || !empty(flicker_option('blog_show_author')) || !empty(flicker_option('blog_show_comments_link')) || !empty(flicker_option('blog_show_views')) || !empty(flicker_option('blog_show_categories'))) :
		?>
			<div class="entry-footer entry-footer-top">
				<?php flicker_entry_meta(true, true, true, false, true, true); ?>
			</div>
			<!-- .entry-footer -->
		<?php endif; ?>
		<?php if (get_the_title()) : ?>
			<header class="entry-header">
				<?php
				the_title(sprintf('<h3 class="entry-title big" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
				?>
			</header><!-- .entry-header -->
		<?php endif; //get_the_title 
		?>
		<div class="entry-content" itemprop="text">
			<?php
			$flicker_show_full_text = flicker_option('blog_show_full_text', false);

			if (empty($flicker_show_full_text)) :

				the_excerpt();

			else :

				the_content(
					flicker_read_more_inside_link_markup()
				);

			endif; // show_full_text

			wp_link_pages(
				flicker_get_wp_link_pages_atts()
			);
			?>
			<?php
			if (
				!empty(flicker_option('blog_show_tags'))
				||
				!empty(flicker_option('blog_share_facebook', true))
				||
				!empty(flicker_option('blog_share_twitter', true))
				||
				!empty(flicker_option('blog_share_telegram', true))
				||
				!empty(flicker_option('blog_share_pinterest', true))
				||
				!empty(flicker_option('blog_share_linkedin', true))
			) :
			?>
				<div class="entry-footer entry-footer-bottom">
					<?php
					if (!empty(flicker_option('blog_show_tags'))) {
					?>
						<div class="meta-tags">
							<?php
							flicker_entry_meta(false, false, false, true, false, false);
							?>
						</div>
					<?php } ?>
					<?php
					if (function_exists('flicker_share_this')) {
						flicker_share_this();
					}
					?>
				</div>
				<!-- .entry-footer -->
			<?php endif; ?>
		</div><!-- .entry-content -->

	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->