<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package WordPress
 * @subpackage Flicker
 * @since 0.0.1
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

?>
<article id="post-<?php the_ID(); ?>" <?php post_class('vertical-item'); ?> itemtype="https://schema.org/Article" itemscope="itemscope">
	<?php
	flicker_post_thumbnail('flicker-default-post');
	?>

	<div class="item-content content-padding with-background">
		<div class="entry-meta post-meta small-text">
			<?php
			if (
				!empty(flicker_option('blog_show_date'))
				|| !empty(flicker_option('blog_show_tags'))
				|| !empty(flicker_option('blog_show_views'))
			) :
			?>
				<div class="meta-left greylinks">
					<?php
					flicker_entry_meta(true, false, false, true, false, true, true);
					?>
				</div>
			<?php
			endif;
			?>
			<?php
			if (
				!empty(flicker_option('blog_show_categories'))
			) :
			?>
				<div class="highlightlinks">
					<?php
					flicker_entry_meta(false, false, true, false, false, false, false);
					?>
				</div>
			<?php
			endif;
			?>
		</div><!-- .entry-meta -->
		<?php if (get_the_title()) : ?>
			<header class="entry-header">
				<?php
				the_title(sprintf('<h3 class="entry-title" itemprop="headline"><a href="%s" rel="bookmark">', esc_url(get_permalink())), '</a></h3>');
				?>
			</header><!-- .entry-header -->
		<?php endif; //get_the_title 
		?>
		<div class="entry-content" itemprop="text">
			<?php
			$flicker_show_full_text = flicker_option('blog_show_full_text', false);

			the_content(
				flicker_read_more_inside_link_markup()
			);

			wp_link_pages(
				flicker_get_wp_link_pages_atts()
			);
			?>
		</div><!-- .entry-content -->
	</div><!-- .item-content -->
</article><!-- #post-<?php the_ID(); ?> -->