<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}

require_once FLICKER_THEME_PATH . '/inc/customizer/class-mwt-block-heading-control.php';
require_once FLICKER_THEME_PATH . '/inc/customizer/class-mwt-dropdown-category-control.php';
require_once FLICKER_THEME_PATH . '/inc/customizer/class-mwt-google-font-control.php';
require_once FLICKER_THEME_PATH . '/inc/customizer/class-mwt-hidden-customize-control.php';
require_once FLICKER_THEME_PATH . '/inc/customizer/class-mwt-customizer.php';
require_once FLICKER_THEME_PATH . '/inc/customizer/customizer-helpers.php';
require_once FLICKER_THEME_PATH . '/inc/customizer/customizer-woocommerce.php';


//cutsomizer theme settings
if (!function_exists('flicker_customizer_settings_array')) :
	function flicker_customizer_settings_array()
	{
		return apply_filters(
			'flicker_customizer_options',
			//panels -> sections -> settings
			array(
				//////////////////////
				//registering panels//
				//////////////////////
				'panel_theme'                           => array(
					'type'            => 'panel',
					'label'           => esc_html__('Theme options', 'flicker'),
					'description'     => esc_html__('Theme specific options', 'flicker'),
					'priority'        => 130,
					'active_callback' => '',
				),
				////////////////////////
				//registering sections//
				////////////////////////

				/*
				make sure that you have appropriate panel registered above
				otherwise do not pass 'panel' key
				*/

				//global settings preset. It will change multiple options over 'Theme options' panel
				'section_layout'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Theme Layout', 'flicker'),
					'description' => esc_html__('Site layout options', 'flicker'),
					'priority'    => 100,
				),
				'section_meta'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Theme Meta', 'flicker'),
					'description' => esc_html__('Email, phone, address etc. Appears in various template parts depending from choosen sections layout', 'flicker'),
					'priority'    => 100,
				),

				//template parts layout sections
				'section_header'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Header Section', 'flicker'),
					'description' => esc_html__('Choose header options', 'flicker'),
					'priority'    => 100,
				),
				'section_title'                         => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Title Section', 'flicker'),
					'description' => esc_html__('Choose title options. Yoast SEO plugin required for breadcrumbs', 'flicker'),
					'priority'    => 100,
				),
				'section_main'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Main Section', 'flicker'),
					'description' => esc_html__('Choose main section options', 'flicker'),
					'priority'    => 100,
				),
				'section_404'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('404 Section', 'flicker'),
					'description' => esc_html__('Choose 404 section options', 'flicker'),
					'priority'    => 100,
				),
				'section_footer_top'                    => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Top Footer Section', 'flicker'),
					'description' => esc_html__('Choose top footer section options', 'flicker'),
					'priority'    => 100,
				),
				'section_footer'                        => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Footer Section', 'flicker'),
					'description' => esc_html__('Choose footer options', 'flicker'),
					'priority'    => 100,
				),
				'section_copyright'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Copyright Section', 'flicker'),
					'description' => esc_html__('Choose copyright options', 'flicker'),
					'priority'    => 100,
				),
				'section_blog'                          => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Blog', 'flicker'),
					'description' => esc_html__('Blog display options', 'flicker'),
					'priority'    => 100,
				),
				'section_blog_post'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Single Post', 'flicker'),
					'description' => esc_html__('Single post display options', 'flicker'),
					'priority'    => 100,
				),
				'section_fonts'                         => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Fonts', 'flicker'),
					'description' => esc_html__('Choose Google fonts', 'flicker'),
					'priority'    => 100,
				),
				'section_special_categories'            => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Services, Portfolio, Team', 'flicker'),
					'description' => esc_html__('Choose separate categories for displaying Services, Portfolio, Team. They will be removed from regular blog displaying', 'flicker'),
					'priority'    => 100,
				),
				'section_animation'                     => array(
					'type'        => 'section',
					'panel'       => 'panel_theme',
					'label'       => esc_html__('Animation', 'flicker'),
					'description' => esc_html__('You can select elements that you want to animate on your page', 'flicker'),
					'priority'    => 100,
				),

				///////////////////////
				//registering options//
				///////////////////////
				/*
				make sure that you have registered appropriate section above
				or used default sections as 'section' key's value:
					'title_tagline' - Site Title & Tagline
					'colors' - Colors
					'header_image' - Header Image
					'background_image' - Background Image
					'nav' - Navigation
					'static_front_page' - Static Front Page
				*/
				/*
				available types:
					'checkbox'
					'color'
					'dropdown-pages'
					'file'
					'image'
					'radio'
					'select'
					'text'
					'textarea'
					'url'
					'dropdown-category' - our custom dropdown
					'block-heading' - our custom block heading
					'hidden-option' - our custom hidden option
				make sure that you have provide an array with 'choices' key for 'select' and 'radio':
					'choices' => array(
						'choice_1' => esc_html__( 'Choice 1', 'flicker' ),
						...
					)
				*/

				//////////////////////
				//Hidden Demo Number//
				//////////////////////
				'demo_number'                           => array(
					'type'    => 'hidden-option',
					'section' => 'section_presets',
					'default' => flicker_option('demo_number', ''),
				),

				//////////
				//colors//
				//////////
				//see _variables.scss
				//see options.php for defaults
				// colorLight
				// colorFont
				// colorFontDark
				// colorBackground
				// colorBackgroundDark
				// colorBorder
				// colorBorderDark
				// colorDark
				// colorDarkGrey
				// colorGrey
				// colorMain
				// colorMain2
				// colorMain3
				'colorLight'                            => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Light color', 'flicker'),
					'default'     => flicker_option('colorLight', '#ffffff'),
					'description' => esc_html__('Using as a background for light sections and as a headings color in inversed sections.', 'flicker'),
				),
				'colorFont'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Font color', 'flicker'),
					'default'     => flicker_option('colorFont', '#818181'),
					'description' => esc_html__('Using as a font color.', 'flicker'),
				),
				'colorFontDark'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark font color', 'flicker'),
					'default'     => flicker_option('colorFontDark', '#b2b2b2'),
					'description' => esc_html__('Using as a font color in inversed sections.', 'flicker'),
				),
				'colorBackground'                       => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Light grey background color', 'flicker'),
					'default'     => flicker_option('colorBackground', '#f5f5f5'),
					'description' => esc_html__('Background color for elements in light section.', 'flicker'),
				),
				'colorBackgroundDark'                       => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark background color', 'flicker'),
					'default'     => flicker_option('colorBackgroundDark', '#292929'),
					'description' => esc_html__('Background color for elements in inversed section.', 'flicker'),
				),
				'colorBorder'                           => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Grey border color', 'flicker'),
					'default'     => flicker_option('colorBorder', '#e6e6e6'),
					'description' => esc_html__('Using as a border color.', 'flicker'),
				),
				'colorBorderDark'                           => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark border color', 'flicker'),
					'default'     => flicker_option('colorBorderDark', '#989898'),
					'description' => esc_html__('Using as a border color in inversed section.', 'flicker'),
				),
				'colorDark'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark color', 'flicker'),
					'default'     => flicker_option('colorDark', '#1a1a1a'),
					'description' => esc_html__('Using as a background for inversed sections.', 'flicker'),
				),
				'colorDarkGrey'                        => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Dark grey color', 'flicker'),
					'default'     => flicker_option('colorDarkGrey', '#222222'),
					'description' => esc_html__('Using as headings color and a background for inversed sections.', 'flicker'),
				),
				'colorGrey'                        => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Grey color', 'flicker'),
					'default'     => flicker_option('colorGrey', '#f5f5f5'),
					'description' => esc_html__('Using as a background for light muted sections.', 'flicker'),
				),
				'colorMain'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Accent color', 'flicker'),
					'default'     => flicker_option('colorMain', '#dd4377'),
					'description' => esc_html__('Using as a main accent color.', 'flicker'),
				),
				'colorMain2'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Accent color 2', 'flicker'),
					'default'     => flicker_option('colorMain2', '#10316d'),
					'description' => esc_html__('Using as a accent color.', 'flicker'),
				),
				'colorMain3'                             => array(
					'type'        => 'color',
					'section'     => 'colors',
					'label'       => esc_html__('Accent color 3', 'flicker'),
					'default'     => flicker_option('colorMain3', '#634255'),
					'description' => esc_html__('Using as a accent color.', 'flicker'),
				),
				'color_meta_icons'                      => array(
					'type'    => 'select',
					'section' => 'colors',
					'label'   => esc_html__('Color for icons in post meta', 'flicker'),
					'default' => flicker_option('color_meta_icons', ''),
					'choices' => array(
						''                      => esc_html__('Default', 'flicker'),
						'meta-icons-main'       => esc_html__('Accent color', 'flicker'),
						'meta-icons-border'     => esc_html__('Borders color', 'flicker'),
						'meta-icons-dark'       => esc_html__('Dark color', 'flicker'),
						'meta-icons-dark-muted' => esc_html__('Darker color', 'flicker'),
					),
				),

				//////////////////////////
				//homepage intro section//
				//////////////////////////

				// static_front_page
				'intro_block_heading'                   => array(
					'type'        => 'block-heading',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Intro Section', 'flicker'),
					'description' => esc_html__('Set your settings for homepage intro section. Leave blank if not needed.', 'flicker'),
				),
				'intro_position'                        => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Position', 'flicker'),
					'default' => flicker_option('intro_position', ''),
					'choices' => array(
						''       => esc_html__('Hidden', 'flicker'),
						'before' => esc_html__('Before header', 'flicker'),
						'after'  => esc_html__('After header', 'flicker'),
					),
				),
				'intro_layout'                          => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Layout', 'flicker'),
					'default' => flicker_option('intro_layout', ''),
					'choices' => array(
						''             => esc_html__('Background image', 'flicker'),
						'image-left'   => esc_html__('Left side image', 'flicker'),
						'image-right'  => esc_html__('Right side image', 'flicker'),
						'image-top'    => esc_html__('Top image', 'flicker'),
						'image-bottom' => esc_html__('Bottom image', 'flicker'),
					),
				),
				'intro_fullscreen'                      => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Full Screen Intro Height', 'flicker'),
					'default' => flicker_option('intro_fullscreen', false),
				),
				'intro_background'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Background', 'flicker'),
					'default' => flicker_option('intro_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'intro_background_image'                => array(
					'type'    => 'image',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Background Image', 'flicker'),
					'default' => flicker_option('intro_background_image', ''),
				),
				'intro_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('intro_background_image_cover', false),
				),
				'intro_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('intro_background_image_fixed', false),
				),
				'intro_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('intro_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),
				'intro_image'                => array(
					'type'    => 'image',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Image', 'flicker'),
					'default' => flicker_option('intro_image', ''),
				),
				'intro_background_image_scale' => array(
					'type'        => 'checkbox',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Make image bigger on large screen', 'flicker'),
					'description' => esc_html__('Scale image for large screens', 'flicker'),
					'default'     => flicker_option('intro_background_image_scale', false),
				),
				'intro_image_absolute' => array(
					'type'        => 'checkbox',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Make image position absolute on large screen', 'flicker'),
					'description' => esc_html__('Scale image for large screens (only for left/right side image layout)', 'flicker'),
					'default'     => flicker_option('intro_image_absolute', false),
				),
				'intro_image_animation'                 => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro image', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_image_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_pre_heading'                         => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Pre Heading text', 'flicker'),
					'default' => flicker_option('intro_pre_heading', ''),
				),
				'intro_pre_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Pre Heading top margin', 'flicker'),
					'default' => flicker_option('intro_pre_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_pre_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Pre Heading bottom margin', 'flicker'),
					'default' => flicker_option('intro_pre_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_pre_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for pre intro heading', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_pre_heading_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_heading'                         => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Heading text', 'flicker'),
					'default' => flicker_option('intro_heading', ''),
				),
				'intro_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Heading top margin', 'flicker'),
					'default' => flicker_option('intro_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Heading bottom margin', 'flicker'),
					'default' => flicker_option('intro_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro heading', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_heading_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_description'                     => array(
					'type'    => 'textarea',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section description text', 'flicker'),
					'default' => flicker_option('intro_description', ''),
				),
				'intro_description_mt'                  => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Description top margin', 'flicker'),
					'default' => flicker_option('intro_description_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Description bottom margin', 'flicker'),
					'default' => flicker_option('intro_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_description_animation'           => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro description text', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_description_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_button_text_first'               => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Primary Action Button Text', 'flicker'),
					'default' => flicker_option('intro_button_text_first', ''),
				),
				'intro_button_url_first'                => array(
					'type'    => 'url',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Primary Action Button URL', 'flicker'),
					'default' => flicker_option('intro_button_url_first', ''),
				),
				'intro_button_first_animation'          => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for first intro button', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_button_first_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_button_text_second'              => array(
					'type'    => 'text',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Secondary Action Button Text', 'flicker'),
					'default' => flicker_option('intro_button_text_second', ''),
				),
				'intro_button_url_second'               => array(
					'type'    => 'url',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Secondary Action Button URL', 'flicker'),
					'default' => flicker_option('intro_button_url_second', ''),
				),
				'intro_button_second_animation'         => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for second intro button', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_button_second_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_buttons_mt'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Buttons top margin', 'flicker'),
					'default' => flicker_option('intro_buttons_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_buttons_mb'                      => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Buttons bottom margin', 'flicker'),
					'default' => flicker_option('intro_buttons_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Intro Section Shortcode', 'flicker'),
					'description' => esc_html__('You can put shortcode here. It will appear below Intro description', 'flicker'),
					'default'     => flicker_option('intro_shortcode', ''),
				),
				'intro_shortcode_mt'                    => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Shortcode top margin', 'flicker'),
					'default' => flicker_option('intro_shortcode_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'intro_shortcode_mb'                    => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Shortcode bottom margin', 'flicker'),
					'default' => flicker_option('intro_shortcode_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'intro_shortcode_animation'             => array(
					'type'        => 'select',
					'section'     => 'static_front_page',
					'label'       => esc_html__('Animation for intro shortcode', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('intro_shortcode_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'intro_alignment'                       => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro Section Text Alignment', 'flicker'),
					'default' => flicker_option('intro_alignment', 'text-left'),
					'choices' => array(
						'text-left'   => esc_html__('Left', 'flicker'),
						'text-center' => esc_html__('Centered', 'flicker'),
						'text-right'  => esc_html__('Right', 'flicker'),
					),
				),
				'intro_extra_padding_top'               => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section top padding', 'flicker'),
					'default' => flicker_option('intro_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
					),
				),
				'intro_extra_padding_bottom'            => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section bottom padding', 'flicker'),
					'default' => flicker_option('intro_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
					),
				),
				'intro_social_links'                    => array(
					'type'    => 'checkbox',
					'section' => 'static_front_page',
					'label'   => esc_html__('Show social links if they set', 'flicker'),
					'default' => flicker_option('intro_social_links', false),
				),
				'intro_font_size'                       => array(
					'type'    => 'select',
					'section' => 'static_front_page',
					'label'   => esc_html__('Intro section font size', 'flicker'),
					'default' => flicker_option('intro_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),

				////////
				//logo//
				////////

				//to existing 'title_tagline' section
				'logo_image_inverse'                => array(
					'type'    => 'image',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Inverse', 'flicker'),
					'default' => flicker_option('logo_image_inverse', ''),
				),
				'logo'                                  => array(
					'type'    => 'select',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Layout', 'flicker'),
					'default' => flicker_option('logo', ''),
					'choices' => array(
						'1' => esc_html__('Left image and right text', 'flicker'),
						'2' => esc_html__('Top image and bottom text', 'flicker'),
						'3' => esc_html__('Image between text', 'flicker'),
					),
				),
				'logo_primary_text'                     => array(
					'type'    => 'text',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Primary Text', 'flicker'),
					'default' => flicker_option('logo_primary_text', ''),
				),
				'logo_text_secondary'                   => array(
					'type'    => 'text',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Secondary Text', 'flicker'),
					'default' => flicker_option('logo_text_secondary', ''),
				),
				'header_top_tall'                       => array(
					'type'        => 'checkbox',
					'section'     => 'title_tagline',
					'label'       => esc_html__('Logo additional vertical padding', 'flicker'),
					'description' => esc_html__('Will make header taller in top position', 'flicker'),
					'default'     => flicker_option('header_top_tall', false),
				),
				'logo_background'                       => array(
					'type'    => 'select',
					'section' => 'title_tagline',
					'label'   => esc_html__('Logo Background', 'flicker'),
					'default' => flicker_option('logo_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'logo_padding_horizontal'               => array(
					'type'        => 'checkbox',
					'section'     => 'title_tagline',
					'label'       => esc_html__('Logo additional horizontal padding', 'flicker'),
					'description' => esc_html__('This will add an extra horizontal padding for logo', 'flicker'),
					'default'     => flicker_option('logo_padding_horizontal', false),
				),

				//////////
				//layout//
				//////////
				'preset'                                => array(
					'type'    => 'select',
					'section' => 'section_presets',
					'label'   => esc_html__('Select global preset of Theme options', 'flicker'),
					'default' => flicker_option('preset', ''),
					'choices' => array(
						''  => esc_html__('No preset', 'flicker'),
						'1' => esc_html__('First preset', 'flicker'),
						'2' => esc_html__('Second preset', 'flicker'),
					),
				),
				'main_container_width'                  => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Global container max width', 'flicker'),
					'default' => flicker_option('main_container_width', '1170'),
					'choices' => array(
						'1520' => esc_html__('1520px', 'flicker'),
						'1170' => esc_html__('1170px', 'flicker'),
						'960'  => esc_html__('960px', 'flicker'),
						'720'  => esc_html__('720px', 'flicker'),
					),
				),
				'blog_container_width'                  => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Archive container max width', 'flicker'),
					'default' => flicker_option('blog_container_width', ''),
					'choices' => array(
						''     => esc_html__('Inherit from Global', 'flicker'),
						'1520' => esc_html__('1520px', 'flicker'),
						'1170' => esc_html__('1170px', 'flicker'),
						'960'  => esc_html__('960px', 'flicker'),
						'720'  => esc_html__('720px', 'flicker'),
					),
				),
				'blog_single_container_width'           => array(
					'type'    => 'radio',
					'section' => 'section_layout',
					'label'   => esc_html__('Single post container max width', 'flicker'),
					'default' => flicker_option('blog_single_container_width', ''),
					'choices' => array(
						''     => esc_html__('Inherit from Global', 'flicker'),
						'1520' => esc_html__('1520px', 'flicker'),
						'1170' => esc_html__('1170px', 'flicker'),
						'960'  => esc_html__('960px', 'flicker'),
						'720'  => esc_html__('720px', 'flicker'),
					),
				),
				'boxed'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_layout',
					'label'   => esc_html__('Boxed', 'flicker'),
					'default' => flicker_option('boxed', false),
				),
				'preloader'                             => array(
					'type'     => 'select',
					'section'  => 'section_layout',
					'label'    => esc_html__('Page preloader', 'flicker'),
					'default'  => flicker_option('preloader', ''),
					'priority' => 200,
					'choices'  => array(
						''       => esc_html__('No preloader', 'flicker'),
						'cover'  => esc_html__('Cover page preloader', 'flicker'),
						'corner' => esc_html__('Corner page preloader', 'flicker'),
					),
				),
				'box_fade_in'                           => array(
					'type'     => 'checkbox',
					'section'  => 'section_layout',
					'label'    => esc_html__('Fade in page on load', 'flicker'),
					'default'  => flicker_option('box_fade_in', ''),
					'priority' => 200,
				),
				'totop'                                 => array(
					'type'     => 'checkbox',
					'section'  => 'section_layout',
					'label'    => esc_html__('Enable page \'to top\' button', 'flicker'),
					'default'  => flicker_option('totop', ''),
					'priority' => 200,
				),
				'assets_min'                            => array(
					'type'        => 'checkbox',
					'section'     => 'section_layout',
					'label'       => esc_html__('Use minified version of CSS files', 'flicker'),
					'description' => esc_html__('You can use compressed versions of your static files for best performance', 'flicker'),
					'default'     => flicker_option('assets_min', ''),
					'priority'    => 200,
				),
				'jquery_to_footer'                      => array(
					'type'        => 'checkbox',
					'section'     => 'section_layout',
					'label'       => esc_html__('Put jQuery script to footer for guest users', 'flicker'),
					'description' => esc_html__('If some plugins requires jQuery, it will be loaded in the footer section', 'flicker'),
					'default'     => flicker_option('jquery_to_footer', ''),
					'priority'    => 200,
				),

				////////
				//meta//
				////////
				'meta_email'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email', 'flicker'),
					'default' => flicker_option('meta_email', ''),
				),
				'meta_email_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Email label', 'flicker'),
					'default' => flicker_option('meta_email_label', ''),
				),
				'meta_phone'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone', 'flicker'),
					'default' => flicker_option('meta_phone', ''),
				),
				'meta_phone_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Phone label', 'flicker'),
					'default' => flicker_option('meta_phone_label', ''),
				),
				'meta_website'                            => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Website', 'flicker'),
					'default' => flicker_option('meta_website', ''),
				),
				'meta_website_label'                      => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Website label', 'flicker'),
					'default' => flicker_option('meta_website_label', ''),
				),
				'meta_address'                          => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Address', 'flicker'),
					'default' => flicker_option('meta_address', ''),
				),
				'meta_address_label'                    => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Address label', 'flicker'),
					'default' => flicker_option('meta_address_label', ''),
				),
				'meta_opening_hours'                    => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Opening hours', 'flicker'),
					'default' => flicker_option('meta_opening_hours', ''),
				),
				'meta_opening_hours_label'              => array(
					'type'    => 'text',
					'section' => 'section_meta',
					'label'   => esc_html__('Opening hours label', 'flicker'),
					'default' => flicker_option('meta_opening_hours_label', ''),
				),
				//social links
				'meta_facebook'                         => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Facebook URL', 'flicker'),
					'default' => flicker_option('meta_facebook', ''),
				),
				'meta_twitter'                          => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Twitter URL', 'flicker'),
					'default' => flicker_option('meta_twitter', ''),
				),
				'meta_instagram'                        => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Instagram URL', 'flicker'),
					'default' => flicker_option('meta_instagram', ''),
				),
				'meta_linkedin'                         => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('LinkedIn URL', 'flicker'),
					'default' => flicker_option('meta_linkedin', ''),
				),
				'meta_youtube'                          => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('YouTube URL', 'flicker'),
					'default' => flicker_option('meta_youtube', ''),
				),
				'meta_pinterest'                        => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('Pinterest URL', 'flicker'),
					'default' => flicker_option('meta_pinterest', ''),
				),
				'meta_github'                           => array(
					'type'    => 'url',
					'section' => 'section_meta',
					'label'   => esc_html__('GitHub URL', 'flicker'),
					'default' => flicker_option('meta_github', ''),
				),

				//////////
				//header//
				//////////

				//header image options
				//section 'header_image'
				'header_image_background_image_cover'   => array(
					'type'    => 'checkbox',
					'section' => 'header_image',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('header_image_background_image_cover', false),
				),
				'header_image_background_image_fixed'   => array(
					'type'    => 'checkbox',
					'section' => 'header_image',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('header_image_background_image_fixed', false),
				),
				'header_image_background_image_overlay' => array(
					'type'    => 'select',
					'section' => 'header_image',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('header_image_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),

				//header
				'header'                                => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Layout', 'flicker'),
					'default' => flicker_option('header', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'flicker'),
						'1' => esc_html__('Logo, menu and button', 'flicker'),
						'2' => esc_html__('Top logo and meta, bottom menu', 'flicker'),
						'3' => esc_html__('Header Side Left', 'flicker'),
						'4' => esc_html__('Header Side Right', 'flicker'),
						'5' => esc_html__('Header Side Left Sticked', 'flicker'),
						'6' => esc_html__('Header Side Right Sticked', 'flicker'),
					),
				),
				'header_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Full Width Header', 'flicker'),
					'default' => flicker_option('header_fluid', true),
				),
				'header_background'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Background', 'flicker'),
					'default' => flicker_option('header_background', 'l'),
					'choices' => flicker_customizer_backgrounds_array(true),
				),
				'header_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_header',
					'label'   => esc_html__('Background Image', 'flicker'),
					'default' => flicker_option('header_background_image', ''),
				),
				'header_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('header_background_image_cover', false),
				),
				'header_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('header_background_image_fixed', false),
				),
				'header_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('header_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),
				'header_toplogo'                         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Toplogo Section in Header', 'flicker'),
					'description' => esc_html__('If header layout contains it', 'flicker'),
					'default' => flicker_option('header_toplogo', false),
				),
				'header_toplogo_background'             => array(
					'type'        => 'select',
					'section'     => 'section_header',
					'label'       => esc_html__('Header Logo Section background', 'flicker'),
					'default'     => flicker_option('header_toplogo_background', 'l'),
					'choices'     => flicker_customizer_backgrounds_array(true),
				),
				'header_toplogo_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Logo Section font size', 'flicker'),
					'default' => flicker_option('header_toplogo_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'header_meta'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show meta in Header', 'flicker'),
					'default' => flicker_option('header_meta', false),
				),
				'header_align_main_menu'                => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Align main menu', 'flicker'),
					'default' => flicker_option('header_align_main_menu', true),
					'choices' => array(
						''            => esc_html__('Default', 'flicker'),
						'menu-right'  => esc_html__('Right', 'flicker'),
						'menu-center' => esc_html__('Center', 'flicker'),
					),
				),
				// TODO why commented out?
				'header_toggler_menu_main'              => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Put main menu mobile toggler in header', 'flicker'),
					'default' => flicker_option('header_toggler_menu_main', true),
				),
				'header_absolute_home_page'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Position absolute header (Home Page)', 'flicker'),
					'default' => flicker_option('header_absolute_home_page', false),
				),
				'header_absolute'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Position absolute header', 'flicker'),
					'default' => flicker_option('header_absolute', false),
				),
				'header_transparent'                    => array(
					'type'        => 'checkbox',
					'section'     => 'section_header',
					'label'       => esc_html__('Remove background color', 'flicker'),
					'description' => esc_html__('Make header transparent', 'flicker'),
					'default'     => flicker_option('header_transparent', false),
				),
				'header_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Top border', 'flicker'),
					'default' => flicker_option('header_border_top', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'header_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Bottom border', 'flicker'),
					'default' => flicker_option('header_border_bottom', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'header_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header section font size', 'flicker'),
					'default' => flicker_option('header_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'header_sticky'                         => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Sticky Header', 'flicker'),
					'default' => flicker_option('header_sticky', false),
					'choices' => array(
						''                 => esc_html__('Disabled', 'flicker'),
						'always-sticky'    => esc_html__('Always visible', 'flicker'),
						'scrolltop-sticky' => esc_html__('Visible on scrolling to top', 'flicker'),
					),
				),
				'header_button_text'                         => array(
					'type'    => 'text',
					'section' => 'section_header',
					'label'   => esc_html__('Header button text', 'flicker'),
					'default' => flicker_option('header_button_text', ''),
				),
				'header_button_url'                         => array(
					'type'    => 'text',
					'section' => 'section_header',
					'label'   => esc_html__('Header button URL', 'flicker'),
					'default' => flicker_option('header_button_url', ''),
				),
				//topline in header
				'header_topline_options_heading'        => array(
					'type'        => 'block-heading',
					'section'     => 'section_header',
					'label'       => esc_html__('Header topline options', 'flicker'),
					'description' => esc_html__('You need to fill theme meta options to show them in header topline.', 'flicker'),
				),
				'topline'                               => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Topline Layout', 'flicker'),
					'default' => flicker_option('topline', ''),
					'choices' => array(
						''  => esc_html__('Disabled', 'flicker'),
						'1' => esc_html__('Left social icons and right meta', 'flicker'),
						'2' => esc_html__('Left social icons, right login/register, sopping cart and search', 'flicker'),
						'3' => esc_html__('Left meta, center social icons and right search', 'flicker'),
					),
				),
				'topline_fluid'                         => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Full Width Header Topline', 'flicker'),
					'default' => flicker_option('topline_fluid', true),
				),
				'topline_background'                    => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Header Topline Background', 'flicker'),
					'default' => flicker_option('topline_background', 'l'),
					'choices' => flicker_customizer_backgrounds_array(true),
				),
				'topline_font_size'                     => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Topline section font size', 'flicker'),
					'default' => flicker_option('topline_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'topline_meta_address'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Address', 'flicker'),
					'description' => esc_html__('Appears on the first topline layouts', 'flicker'),
					'default' => flicker_option('topline_meta_address', false),
				),
				'topline_meta_phone'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Phone', 'flicker'),
					'description' => esc_html__('Appears on the first topline layouts', 'flicker'),
					'default' => flicker_option('topline_meta_phone', false),
				),
				'topline_meta_mail'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Mail', 'flicker'),
					'description' => esc_html__('Appears on the first topline layouts', 'flicker'),
					'default' => flicker_option('topline_meta_mail', false),
				),
				'topline_meta_opening_hours'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_header',
					'label'   => esc_html__('Show Meta Opening Hours', 'flicker'),
					'description' => esc_html__('Appears on the first topline layouts', 'flicker'),
					'default' => flicker_option('topline_meta_opening_hours', false),
				),
				'header_search'                         => array(
					'type'    => 'select',
					'section' => 'section_header',
					'label'   => esc_html__('Show Search', 'flicker'),
					'description' => esc_html__('Appears on the second/third topline layouts', 'flicker'),
					'default' => flicker_option('header_search', ''),
					'choices' => array(
						''       => esc_html__('Disabled', 'flicker'),
						'button' => esc_html__('Search Modal button', 'flicker'),
						'button2' => esc_html__('Search Modal button alt', 'flicker'),
						'form'   => esc_html__('Search Form', 'flicker'),
					),
				),

				/////////
				//title//
				/////////
				'title'                                 => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title Layout', 'flicker'),
					'default' => flicker_option('title', '1'),
					'choices' => array(
						'1' => esc_html__('Title above breadcrumbs', 'flicker'),
						'2' => esc_html__('Title above breadcrumbs centered', 'flicker'),
						'5' => esc_html__('Title above breadcrumbs centered alt', 'flicker'),
						'3' => esc_html__('Title inline with breadcrumbs', 'flicker'),
						'6' => esc_html__('Title inline with breadcrumbs alt', 'flicker'),
						'4' => esc_html__('Title above breadcrumbs bottom', 'flicker'),
					),
				),
				'title_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Full Width Title', 'flicker'),
					'default' => flicker_option('title_fluid', true),
				),
				'title_show_title'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show title in title section instead of content area', 'flicker'),
					'default' => flicker_option('title_show_title', ''),
				),
				'title_show_breadcrumbs'                => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Show breadcrumbs (Yoast SEO or Rank Math plugins required)', 'flicker'),
					'default' => flicker_option('title_show_breadcrumbs', true),
				),
				'title_background'                      => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title Background', 'flicker'),
					'default' => flicker_option('title_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'title_border_top'                      => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Top border', 'flicker'),
					'default' => flicker_option('title_border_top', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'title_border_bottom'                   => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Bottom border', 'flicker'),
					'default' => flicker_option('title_border_bottom', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'title_extra_padding_top'               => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Top padding', 'flicker'),
					'default' => flicker_option('title_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
					),
				),
				'title_extra_padding_bottom'            => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Bottom padding', 'flicker'),
					'default' => flicker_option('title_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
					),
				),
				'title_font_size'                       => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Title section font size', 'flicker'),
					'default' => flicker_option('title_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'title_hide_taxonomy_name'              => array(
					'type'        => 'checkbox',
					'section'     => 'section_title',
					'label'       => esc_html__('Hide taxonomy name', 'flicker'),
					'description' => esc_html__('You can hide a taxonomy name on taxonomy archives page', 'flicker'),
					'default'     => flicker_option('title_hide_taxonomy_name', false),
				),
				'title_background_image'                => array(
					'type'    => 'image',
					'section' => 'section_title',
					'label'   => esc_html__('Title Section Background Image', 'flicker'),
					'default' => flicker_option('title_background_image', ''),
				),
				'title_background_image_cover'          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('title_background_image_cover', false),
				),
				'title_background_image_fixed'          => array(
					'type'    => 'checkbox',
					'section' => 'section_title',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('title_background_image_fixed', false),
				),
				'title_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'section_title',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('title_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),

				////////////////
				//main section//
				////////////////
				'main_sidebar_width'                    => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar width on big screens', 'flicker'),
					'default' => flicker_option('main_sidebar_width', ''),
					'choices' => array(
						'33' => esc_html__('Default - 1/3 - 33%', 'flicker'),
						'25' => esc_html__('1/4 - 25%', 'flicker'),
						'30' => esc_html__('30% - 70%', 'flicker'),
					),
				),
				'main_gap_width'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar gap width', 'flicker'),
					'default' => flicker_option('main_gap_width', ''),
					'choices' => array(
						''  => esc_html__('Default', 'flicker'),
						'1' => esc_html__('1em', 'flicker'),
						'2' => esc_html__('2em', 'flicker'),
						'3' => esc_html__('3em', 'flicker'),
						'4' => esc_html__('4em', 'flicker'),
					),
				),
				'main_sidebar_margin_right'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar margin', 'flicker'),
					'default' => flicker_option('main_sidebar_margin_right', ''),
					'choices' => array(
						''  => esc_html__('Default', 'flicker'),
						'10' => esc_html__('10px', 'flicker'),
						'15' => esc_html__('15px', 'flicker'),
						'20' => esc_html__('20px', 'flicker'),
						'30' => esc_html__('30px', 'flicker'),
						'40' => esc_html__('40px', 'flicker'),
						'50' => esc_html__('50px', 'flicker'),
						'60' => esc_html__('60px', 'flicker'),
						'70' => esc_html__('70px', 'flicker'),
						'80' => esc_html__('80px', 'flicker'),
					),
				),
				'main_sidebar_sticky'                   => array(
					'type'    => 'checkbox',
					'section' => 'section_main',
					'label'   => esc_html__('Sticky sidebar', 'flicker'),
					'default' => flicker_option('main_sidebar_sticky', false),
				),
				'main_extra_padding_top'                => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Top padding', 'flicker'),
					'default' => flicker_option('main_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
					),
				),
				'main_extra_padding_bottom'             => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Bottom padding', 'flicker'),
					'default' => flicker_option('main_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
					),
				),
				'main_font_size'                        => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Main section font size', 'flicker'),
					'default' => flicker_option('main_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'sidebar_font_size'                     => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Sidebar font size', 'flicker'),
					'default' => flicker_option('sidebar_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'main_version'             => array(
					'type'    => 'select',
					'section' => 'section_main',
					'label'   => esc_html__('Theme Version', 'flicker'),
					'description' => esc_html__('Light or dark version (not working for Elementor pages)', 'flicker'),
					'default' => flicker_option('main_version', ''),
					'choices' => array(
						'l m' => esc_html__('Light', 'flicker'),
						'i m'  => esc_html__('Dark', 'flicker'),
					),
				),
				///////
				//404//
				///////
				'404_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_404',
					'label'   => esc_html__('404', 'flicker'),
					'default' => flicker_option('404_heading', ''),
				),
				'404_text_bottom_line'                         => array(
					'type'    => 'text',
					'section' => 'section_404',
					'label'   => esc_html__('404 Text', 'flicker'),
					'default' => flicker_option('404_text_bottom_line', ''),
				),
				'404_background'                      => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('404 Page Background', 'flicker'),
					'default' => flicker_option('404_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'404_background_image'                => array(
					'type'    => 'image',
					'section' => 'section_404',
					'label'   => esc_html__('404 Page Background Image', 'flicker'),
					'default' => flicker_option('404_background_image', ''),
				),
				'404_background_image_overlay'        => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('404_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),
				'404_extra_padding_top'                => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Top padding', 'flicker'),
					'default' => flicker_option('404_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
						'pt-11' => esc_html__('11em', 'flicker'),
					),
				),
				'404_extra_padding_bottom'             => array(
					'type'    => 'select',
					'section' => 'section_404',
					'label'   => esc_html__('Bottom padding', 'flicker'),
					'default' => flicker_option('404_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
						'pb-11' => esc_html__('11em', 'flicker'),
					),
				),
				//////////////
				//footer_top//
				//////////////
				'footer_top'                                => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Layout', 'flicker'),
					'default' => flicker_option('footer_top', ''),
					'choices' => array(
						''  => esc_html__('Disabled', 'flicker'),
						'1' => esc_html__('Single column', 'flicker'),
						'2' => esc_html__('Single column centered', 'flicker'),
						'3' => esc_html__('Two columns', 'flicker'),
					),
				),
				'footer_top_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Full Width Section', 'flicker'),
					'default' => flicker_option('footer_top_fluid', false),
				),
				'footer_top_subtitle_top'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top subtitle text', 'flicker'),
					'default' => flicker_option('footer_top_subtitle_top', ''),
					'description' => esc_html__('Used only for \'Single column centered\' layouts', 'flicker'),
				),
				'footer_top_subtitle'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Subtitle text', 'flicker'),
					'default' => flicker_option('footer_top_subtitle', ''),
					'description' => esc_html__('Used only for \'Single column centered\' layouts', 'flicker'),
				),
				'footer_top_subtitle_mt'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Subtitle top margin', 'flicker'),
					'default' => flicker_option('footer_top_subtitle_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_subtitle_mb'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Subtitle bottom margin', 'flicker'),
					'default' => flicker_option('footer_top_subtitle_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_subtitle_animation'               => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top subtitle', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('footer_top_subtitle_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),


				'footer_top_heading'                         => array(
					'type'    => 'text',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading text', 'flicker'),
					'default' => flicker_option('footer_top_heading', ''),
				),
				'footer_top_heading_mt'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading top margin', 'flicker'),
					'default' => flicker_option('footer_top_heading_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_heading_mb'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Heading bottom margin', 'flicker'),
					'default' => flicker_option('footer_top_heading_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_heading_animation'               => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top heading', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('footer_top_heading_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'footer_top_description'                     => array(
					'type'    => 'textarea',
					'section' => 'section_footer_top',
					'label'   => esc_html__('description text', 'flicker'),
					'default' => flicker_option('footer_top_description', ''),
				),
				'footer_top_description_mt'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description top margin', 'flicker'),
					'default' => flicker_option('footer_top_description_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_description_mb'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Description bottom margin', 'flicker'),
					'default' => flicker_option('footer_top_description_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_description_animation'           => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for footer_top description text', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('footer_top_description_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'footer_top_shortcode'                       => array(
					'type'        => 'text',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Shortcode', 'flicker'),
					'description' => esc_html__('You can put shortcode here. It will appear below description', 'flicker'),
					'default'     => flicker_option('footer_top_shortcode', ''),
				),
				'footer_top_shortcode_mt'                    => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Shortcode top margin', 'flicker'),
					'default' => flicker_option('footer_top_shortcode_mt', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mt-0'  => '0',
						'mt-05' => '0.5em',
						'mt-1'  => '1em',
						'mt-2'  => '2em',
						'mt-3'  => '3em',
						'mt-4'  => '4em',
						'mt-5'  => '5em',
					),
				),
				'footer_top_shortcode_mb'                    => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Shortcode bottom margin', 'flicker'),
					'default' => flicker_option('footer_top_shortcode_mb', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'mb-0'  => '0',
						'mb-05' => '0.5em',
						'mb-1'  => '1em',
						'mb-2'  => '2em',
						'mb-3'  => '3em',
						'mb-4'  => '4em',
						'mb-5'  => '5em',
					),
				),
				'footer_top_shortcode_animation'             => array(
					'type'        => 'select',
					'section'     => 'section_footer_top',
					'label'       => esc_html__('Animation for shortcode', 'flicker'),
					'description' => esc_html__('Animation should be enabled', 'flicker'),
					'default'     => flicker_option('footer_top_shortcode_animation', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'footer_top_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background', 'flicker'),
					'default' => flicker_option('footer_top_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'footer_top_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top border', 'flicker'),
					'default' => flicker_option('footer_top_border_top', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'footer_top_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom border', 'flicker'),
					'default' => flicker_option('footer_top_border_bottom', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'footer_top_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Top padding', 'flicker'),
					'default' => flicker_option('footer_top_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
					),
				),
				'footer_top_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Bottom padding', 'flicker'),
					'default' => flicker_option('footer_top_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
					),
				),
				'footer_top_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Font Size', 'flicker'),
					'default' => flicker_option('footer_top_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'footer_top_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Background Image', 'flicker'),
					'default' => flicker_option('footer_top_background_image', ''),
				),
				'footer_top_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('footer_top_background_image_cover', false),
				),
				'footer_top_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('footer_top_background_image_fixed', false),
				),
				'footer_top_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer_top',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('footer_top_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),

				//////////
				//footer//
				//////////
				'footer'                                => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Layout', 'flicker'),
					'default' => flicker_option('footer', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'flicker'),
						'1' => esc_html__('Equal columns', 'flicker'),
						'2' => esc_html__('First one half column', 'flicker'),
						'3' => esc_html__('Second one half column', 'flicker'),
						'4' => esc_html__('Full Width', 'flicker'),
						'5' => esc_html__('Full Width centered', 'flicker'),
						'6' => esc_html__('Full Width centered narrow', 'flicker'),
						'7' => esc_html__('Second and third narrow columns', 'flicker'),
						'8' => esc_html__('Full Width centered (top corner body)', 'flicker'),
						'9' => esc_html__('First column 75%', 'flicker'),
						'10' => esc_html__('Equal columns (top border body)', 'flicker'),
						'11' => esc_html__('First one half column alt', 'flicker'),
					),
				),
				'footer_layout_gap'                     => array(
					'type'        => 'select',
					'section'     => 'section_footer',
					'label'       => esc_html__('Footer widgets gap', 'flicker'),
					'description' => esc_html__('Used only for multiple columns layouts', 'flicker'),
					'default'     => flicker_option('footer_layout_gap', ''),
					'choices'     => flicker_get_feed_layout_gap_options(),
				),
				'footer_fluid'                          => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Full Width Footer', 'flicker'),
					'default' => flicker_option('footer_fluid', false),
				),
				'footer_background'                     => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Background', 'flicker'),
					'default' => flicker_option('footer_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'footer_border_top'                     => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Top border', 'flicker'),
					'default' => flicker_option('footer_border_top', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'footer_border_bottom'                  => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Bottom border', 'flicker'),
					'default' => flicker_option('footer_border_bottom', ''),
					'choices' => flicker_customizer_borders_array(),
				),
				'footer_extra_padding_top'              => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Top padding', 'flicker'),
					'default' => flicker_option('footer_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
					),
				),
				'footer_extra_padding_bottom'           => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Bottom padding', 'flicker'),
					'default' => flicker_option('footer_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
					),
				),
				'footer_font_size'                      => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Section Font Size', 'flicker'),
					'default' => flicker_option('footer_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'footer_background_image'               => array(
					'type'    => 'image',
					'section' => 'section_footer',
					'label'   => esc_html__('Footer Section Background Image', 'flicker'),
					'default' => flicker_option('footer_background_image', ''),
				),
				'footer_background_image_cover'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('footer_background_image_cover', false),
				),
				'footer_background_image_fixed'         => array(
					'type'    => 'checkbox',
					'section' => 'section_footer',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('footer_background_image_fixed', false),
				),
				'footer_background_image_overlay'       => array(
					'type'    => 'select',
					'section' => 'section_footer',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('footer_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),

				/////////////
				//copyright//
				/////////////
				'copyright'                             => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Layout', 'flicker'),
					'default' => flicker_option('copyright', '1'),
					'choices' => array(
						''  => esc_html__('Disabled', 'flicker'),
						'1' => esc_html__('Only copyright (centered)', 'flicker'),
						'2' => esc_html__('Only copyright (left aligned)', 'flicker'),
						'3' => esc_html__('Left copyright and right menu', 'flicker'),
						'4' => esc_html__('Left copyright and right social icons', 'flicker'),
						'5' => esc_html__('Left copyright, menu and right social icons', 'flicker'),
						'6' => esc_html__('Top copyright and bottom social icons (centered)', 'flicker'),
					),
				),
				'copyright_text'                        => array(
					'type'        => 'textarea',
					'section'     => 'section_copyright',
					'label'       => esc_html__('Copyright text', 'flicker'),
					'description' => esc_html__('Site name will be displayed, if leave empty', 'flicker'),
					'default'     => flicker_option('copyright_text', ''),
				),
				'copyright_fluid'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Full Width copyright', 'flicker'),
					'default' => flicker_option('copyright_fluid', true),
				),
				'copyright_background'                  => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Background', 'flicker'),
					'default' => flicker_option('copyright_background', ''),
					'choices' => flicker_customizer_backgrounds_array(),
				),
				'copyright_extra_padding_top'           => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Top padding', 'flicker'),
					'default' => flicker_option('copyright_extra_padding_top', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pt-0'  => esc_html__('0', 'flicker'),
						'pt-1'  => esc_html__('1em', 'flicker'),
						'pt-2'  => esc_html__('2em', 'flicker'),
						'pt-3'  => esc_html__('3em', 'flicker'),
						'pt-4'  => esc_html__('4em', 'flicker'),
						'pt-5'  => esc_html__('5em', 'flicker'),
						'pt-6'  => esc_html__('6em', 'flicker'),
						'pt-7'  => esc_html__('7em', 'flicker'),
						'pt-8'  => esc_html__('8em', 'flicker'),
						'pt-9'  => esc_html__('9em', 'flicker'),
						'pt-10' => esc_html__('10em', 'flicker'),
					),
				),
				'copyright_extra_padding_bottom'        => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Bottom padding', 'flicker'),
					'default' => flicker_option('copyright_extra_padding_bottom', ''),
					'choices' => array(
						''      => esc_html__('Default', 'flicker'),
						'pb-0'  => esc_html__('0', 'flicker'),
						'pb-1'  => esc_html__('1em', 'flicker'),
						'pb-2'  => esc_html__('2em', 'flicker'),
						'pb-3'  => esc_html__('3em', 'flicker'),
						'pb-4'  => esc_html__('4em', 'flicker'),
						'pb-5'  => esc_html__('5em', 'flicker'),
						'pb-6'  => esc_html__('6em', 'flicker'),
						'pb-7'  => esc_html__('7em', 'flicker'),
						'pb-8'  => esc_html__('8em', 'flicker'),
						'pb-9'  => esc_html__('9em', 'flicker'),
						'pb-10' => esc_html__('10em', 'flicker'),
					),
				),
				'copyright_font_size'                   => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright section font size', 'flicker'),
					'default' => flicker_option('copyright_font_size', ''),
					'choices' => flicker_customizer_font_size_array(),
				),
				'copyright_background_image'            => array(
					'type'    => 'image',
					'section' => 'section_copyright',
					'label'   => esc_html__('Copyright Section Background Image', 'flicker'),
					'default' => flicker_option('copyright_background_image', ''),
				),
				'copyright_background_image_cover'      => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Cover background image', 'flicker'),
					'default' => flicker_option('copyright_background_image_cover', false),
				),
				'copyright_background_image_fixed'      => array(
					'type'    => 'checkbox',
					'section' => 'section_copyright',
					'label'   => esc_html__('Fixed background image', 'flicker'),
					'default' => flicker_option('copyright_background_image_fixed', false),
				),
				'copyright_background_image_overlay'    => array(
					'type'    => 'select',
					'section' => 'section_copyright',
					'label'   => esc_html__('Overlay for background image', 'flicker'),
					'default' => flicker_option('footer_background_image_overlay', ''),
					'choices' => flicker_customizer_background_overlay_array(),
				),

				/////////
				//fonts//
				/////////
				'font_body_heading'                     => array(
					'type'        => 'block-heading',
					'section'     => 'section_fonts',
					'label'       => esc_html__('Body font options', 'flicker'),
					'description' => esc_html__('You can use CMD (CTRL) key for select multiple variants and subsets.', 'flicker'),
				),
				'font_body'                             => array(
					'type'    => 'google-font',
					'section' => 'section_fonts',
					'label'   => esc_html__('Body Custom Font', 'flicker'),
					'default' => flicker_option('font_body', '{"font":"","variant": [],"subset":[]}'),
				),
				'font_headings_heading'                 => array(
					'type'        => 'block-heading',
					'section'     => 'section_fonts',
					'label'       => esc_html__('Secondary font options', 'flicker'),
					'description' => esc_html__('You can use CMD (CTRL) key for select multiple variants and subsets.', 'flicker'),
				),
				'font_headings'                         => array(
					'type'    => 'google-font',
					'section' => 'section_fonts',
					'label'   => esc_html__('Secondary Custom Font', 'flicker'),
					'default' => flicker_option('font_headings', '{"font":"","variant": [],"subset":[]}'),
				),

				////////
				//blog//
				////////
				'blog_layout'                           => array(
					'type'    => 'select',
					'section' => 'section_blog',
					'label'   => esc_html__('Blog feed layout', 'flicker'),
					'default' => flicker_option('blog_layout', ''),
					'choices' => flicker_get_feed_layout_options(),
				),
				'blog_layout_gap'                       => array(
					'type'        => 'select',
					'section'     => 'section_blog',
					'label'       => esc_html__('Blog feed layout gap', 'flicker'),
					'description' => esc_html__('Used only for grid and masonry layouts', 'flicker'),
					'default'     => flicker_option('blog_layout_gap', ''),
					'choices'     => flicker_get_feed_layout_gap_options(),
				),
				'blog_sidebar_position'                 => array(
					'type'        => 'radio',
					'section'     => 'section_blog',
					'label'       => esc_html__('Blog sidebar position', 'flicker'),
					'description' => esc_html__('Can be overriden for certain category on category edit page', 'flicker'),
					'default'     => flicker_option('blog_sidebar_position', 'right'),
					'choices'     => flicker_get_sidebar_position_options(),
				),
				'blog_page_name'                        => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Blog page name. Default: \'Blog\'', 'flicker'),
					'default' => flicker_option('blog_page_name', esc_html__('Blog', 'flicker')),
				),
				'blog_show_full_text'                   => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show full text instead of excerpt', 'flicker'),
					'default' => flicker_option('blog_show_full_text', false),
				),
				'blog_excerpt_length'                   => array(
					'type'        => 'number',
					'section'     => 'section_blog',
					'label'       => esc_html__('Custom excerpt length', 'flicker'),
					'description' => esc_html__('Words amount', 'flicker'),
					'default'     => flicker_option('blog_excerpt_length', 40),
				),
				'blog_read_more_text'                   => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('\'Read More\' text. Leave blank to hide', 'flicker'),
					'default' => flicker_option('blog_read_more_text', ''),
				),
				'blog_hide_taxonomy_type_name'          => array(
					'type'        => 'checkbox',
					'section'     => 'section_blog',
					'label'       => esc_html__('Hide taxonomy type name in title section', 'flicker'),
					'default'     => flicker_option('blog_hide_taxonomy_type_name', false),
					'description' => esc_html__('You can hide taxonomy name (ex. \'Tag:\') word if you want.', 'flicker'),
				),
				'blog_meta_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog',
					'label'       => esc_html__('Post meta options', 'flicker'),
					'description' => esc_html__('Select what post meta you want to show in blog feed. Not all layouts will show post meta even if it is checked.', 'flicker'),
				),
				'blog_hide_meta_icons'                  => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Hide icons in the post meta', 'flicker'),
					'default' => flicker_option('blog_hide_meta_icons', false),
				),
				'blog_show_author'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show author', 'flicker'),
					'default' => flicker_option('blog_show_author', true),
				),
				'blog_show_author_avatar'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show author avatar', 'flicker'),
					'default' => flicker_option('blog_show_author_avatar', false),
				),
				'blog_before_author_word'               => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before author', 'flicker'),
					'default' => flicker_option('blog_before_author_word', ''),
				),
				'blog_show_date'                        => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show date', 'flicker'),
					'default' => flicker_option('blog_show_date', true),
				),
				'blog_before_date_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before date', 'flicker'),
					'default' => flicker_option('blog_before_date_word', ''),
				),
				'blog_show_categories'                  => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show categories', 'flicker'),
					'default' => flicker_option('blog_show_categories', true),
				),
				'blog_before_categories_word'           => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before categories', 'flicker'),
					'default' => flicker_option('blog_before_categories_word', ''),
				),
				'blog_show_tags'                        => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show tags', 'flicker'),
					'default' => flicker_option('blog_show_tags', true),
				),
				'blog_before_tags_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before tags', 'flicker'),
					'default' => flicker_option('blog_before_tags_word', ''),
				),
				'blog_show_views'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show views', 'flicker'),
					'default' => flicker_option('blog_show_views', true),
				),
				'blog_before_views_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before views', 'flicker'),
					'default' => flicker_option('blog_before_views_word', ''),
				),
				'blog_show_likes'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show likes', 'flicker'),
					'default' => flicker_option('blog_show_likes', true),
				),
				'blog_before_likes_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog',
					'label'   => esc_html__('Text before likes', 'flicker'),
					'default' => flicker_option('blog_before_likes_word', ''),
				),
				'blog_show_comments_link'               => array(
					'type'    => 'select',
					'section' => 'section_blog',
					'label'   => esc_html__('Show comments count', 'flicker'),
					'default' => flicker_option('blog_show_comments_link', true),
					'choices' => array(
						''       => esc_html__('None', 'flicker'),
						'text'   => esc_html__('Comments number with text', 'flicker'),
						'number' => esc_html__('Only comments number', 'flicker'),
					),
				),
				'blog_share_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog',
					'label'       => esc_html__('Share buttons', 'flicker'),
				),
				'blog_share_facebook'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button facebook', 'flicker'),
					'default' => flicker_option('blog_share_facebook', true),
				),
				'blog_share_twitter'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button twitter', 'flicker'),
					'default' => flicker_option('blog_share_twitter', true),
				),
				'blog_share_telegram'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button telegram', 'flicker'),
					'default' => flicker_option('blog_share_telegram', true),
				),
				'blog_share_pinterest'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button pinterest', 'flicker'),
					'default' => flicker_option('blog_share_pinterest', true),
				),
				'blog_share_linkedin'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog',
					'label'   => esc_html__('Show share button linkedin', 'flicker'),
					'default' => flicker_option('blog_share_linkedin', true),
				),

				////////
				//post//
				////////
				//same as blog (except post nav and author bio)
				'blog_single_sidebar_position'          => array(
					'type'        => 'radio',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Blog post sidebar position', 'flicker'),
					'description' => esc_html__('Can be overriden for certain post by selecting appropriate post template', 'flicker'),
					'default'     => flicker_option('blog_single_sidebar_position', 'right'),
					'choices'     => flicker_get_sidebar_position_options(),
				),
				'blog_single_show_author_bio'           => array(
					'type'        => 'checkbox',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Show Author Bio', 'flicker'),
					'description' => esc_html__('You need to fill Biographical Info to display author bio', 'flicker'),
					'default'     => flicker_option('blog_single_show_author_bio', true),
				),
				'blog_single_author_bio_about_word'     => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'About author\' intro word', 'flicker'),
					'description' => esc_html__('Leave blank if not needed', 'flicker'),
					'default'     => flicker_option('blog_single_author_bio_about_word', ''),
				),
				'blog_single_post_nav_heading'          => array(
					'type'    => 'block-heading',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Posts navigation settings', 'flicker'),
				),
				'blog_single_post_nav'                  => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Posts Navigation', 'flicker'),
					'default' => flicker_option('blog_single_post_nav', ''),
					'choices' => array(
						''          => esc_html__('Disabled', 'flicker'),
						'title'     => esc_html__('Only title', 'flicker'),
						'arrow'     => esc_html__('Only next/previous word', 'flicker'),
						'bg'        => esc_html__('Background featured image', 'flicker'),
						'thumbnail' => esc_html__('Thumbnail featured image', 'flicker'),
					),
				),
				'blog_single_post_nav_word_prev'        => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'Previous post\' word', 'flicker'),
					'description' => esc_html__('Post navigation has to be chosen', 'flicker'),
					'default'     => flicker_option('blog_single_post_nav_word_prev', esc_html__('Prev', 'flicker')),
				),
				'blog_single_post_nav_word_next'        => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('\'Next post\' word', 'flicker'),
					'description' => esc_html__('Post navigation has to be chosen', 'flicker'),
					'default'     => flicker_option('blog_single_post_nav_word_next', esc_html__('Next', 'flicker')),
				),
				'blog_single_related_posts_heading'     => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts settings', 'flicker'),
					'description' => esc_html__('Related posts are based on post tags', 'flicker'),
				),
				'blog_single_related_posts'             => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Related posts', 'flicker'),
					'default' => flicker_option('blog_single_related_posts', ''),
					'choices' => array(
						''                => esc_html__('Hidden', 'flicker'),
						'list'            => esc_html__('Simple list', 'flicker'),
						'list-thumbnails' => esc_html__('List with thumbnails', 'flicker'),
						'grid'            => esc_html__('Posts grid', 'flicker'),
					),
				),
				'blog_single_related_posts_title'       => array(
					'type'        => 'text',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts title', 'flicker'),
					'default'     => flicker_option('blog_single_related_posts_title', ''),
					'description' => esc_html__('Related posts heading title', 'flicker'),
				),
				'blog_single_related_posts_number'      => array(
					'type'        => 'number',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Related posts number', 'flicker'),
					'default'     => flicker_option('blog_single_related_posts_number', ''),
					'description' => esc_html__('Related posts layout has to be chosen', 'flicker'),
				),
				'blog_single_meta_options_heading'      => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Single post meta options', 'flicker'),
					'description' => esc_html__('Select what post meta you want to show in single post. Not all layouts will show post meta even if it is checked.', 'flicker'),
				),
				'blog_single_hide_meta_icons'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Hide icons in the post meta', 'flicker'),
					'default' => flicker_option('blog_single_hide_meta_icons', false),
				),
				'blog_single_show_author'               => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show author', 'flicker'),
					'default' => flicker_option('blog_single_show_author', true),
				),
				'blog_single_show_author_avatar'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show author avatar', 'flicker'),
					'default' => flicker_option('blog_single_show_author_avatar', false),
				),
				'blog_single_before_author_word'        => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before author', 'flicker'),
					'default' => flicker_option('blog_single_before_author_word', ''),
				),
				'blog_single_show_date'                 => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show date', 'flicker'),
					'default' => flicker_option('blog_single_show_date', true),
				),
				'blog_single_before_date_word'          => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before date', 'flicker'),
					'default' => flicker_option('blog_single_before_date_word', ''),
				),
				'blog_single_show_categories'           => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show categories', 'flicker'),
					'default' => flicker_option('blog_single_show_categories', true),
				),
				'blog_single_before_categories_word'    => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before categories', 'flicker'),
					'default' => flicker_option('blog_single_before_categories_word', ''),
				),
				'blog_single_show_tags'                 => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show tags', 'flicker'),
					'default' => flicker_option('blog_single_show_tags', true),
				),
				'blog_single_before_tags_word'          => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before tags', 'flicker'),
					'default' => flicker_option('blog_single_before_tags_word', ''),
				),
				'blog_single_show_views'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show views', 'flicker'),
					'default' => flicker_option('blog_single_show_views', true),
				),
				'blog_single_before_views_word'                 => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Text before views', 'flicker'),
					'default' => flicker_option('blog_single_before_views_word', ''),
				),
				'blog_single_show_likes'                       => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show likes', 'flicker'),
					'default' => flicker_option('blog_single_show_likes', true),
				),
				'blog_single_show_comments_link'        => array(
					'type'    => 'select',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show comments count', 'flicker'),
					'default' => flicker_option('blog_single_show_comments_link', true),
					'choices' => array(
						''       => esc_html__('None', 'flicker'),
						'text'   => esc_html__('Comments number with text', 'flicker'),
						'number' => esc_html__('Only comments number', 'flicker'),
					),
				),
				'blog_single_comments_title_reply'      => array(
					'type'    => 'text',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Comments form title', 'flicker'),
					'default' => flicker_option('blog_single_comments_title_reply', ''),
				),
				'blog_single_share_options_heading'             => array(
					'type'        => 'block-heading',
					'section'     => 'section_blog_post',
					'label'       => esc_html__('Share buttons', 'flicker'),
				),
				'blog_single_share_facebook'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button facebook', 'flicker'),
					'default' => flicker_option('blog_single_share_facebook', true),
				),
				'blog_single_share_twitter'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button twitter', 'flicker'),
					'default' => flicker_option('blog_single_share_twitter', true),
				),
				'blog_single_share_telegram'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button telegram', 'flicker'),
					'default' => flicker_option('blog_single_share_telegram', true),
				),
				'blog_single_share_pinterest'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button pinterest', 'flicker'),
					'default' => flicker_option('blog_single_share_pinterest', true),
				),
				'blog_single_share_linkedin'                      => array(
					'type'    => 'checkbox',
					'section' => 'section_blog_post',
					'label'   => esc_html__('Show share button linkedin', 'flicker'),
					'default' => flicker_option('blog_single_share_linkedin', true),
				),

				///////////////
				// animation //
				///////////////
				'animation_enabled'                     => array(
					'type'        => 'checkbox',
					'section'     => 'section_animation',
					'label'       => esc_html__('Enable CSS animation for elements', 'flicker'),
					'default'     => flicker_option('animation_enabled', false),
					'description' => esc_html__('Please note that additional JS file (2 kB) and CSS file (25 kB) will be loaded if enabled', 'flicker'),
				),
				'animation_sidebar_widgets'             => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for main sidebar widgets', 'flicker'),
					'description' => esc_html__('If you want to animate main sidebar widgets - select one of predefined animation type', 'flicker'),
					'default'     => flicker_option('animation_sidebar_widgets', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'animation_footer_top_widgets'              => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for footer top widgets', 'flicker'),
					'description' => esc_html__('If you want to animate footer top widgets - select one of predefined animation type', 'flicker'),
					'default'     => flicker_option('animation_footer_top_widgets', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'animation_footer_widgets'              => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for footer widgets', 'flicker'),
					'description' => esc_html__('If you want to animate footer widgets - select one of predefined animation type', 'flicker'),
					'default'     => flicker_option('animation_footer_widgets', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'animation_feed_posts'                  => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for posts in posts feed', 'flicker'),
					'description' => esc_html__('If you want to animate blog feed posts - select one of predefined animation type', 'flicker'),
					'default'     => flicker_option('animation_feed_posts', ''),
					'choices'     => flicker_get_animation_options(),
				),
				'animation_feed_posts_thumbnail'        => array(
					'type'        => 'select',
					'section'     => 'section_animation',
					'label'       => esc_html__('Animation for posts thumbnails in posts feed', 'flicker'),
					'description' => esc_html__('If you want to animate blog feed posts thumbnail - select one of predefined animation type', 'flicker'),
					'default'     => flicker_option('animation_feed_posts_thumbnail', ''),
					'choices'     => flicker_get_animation_options(),
				),
			) //options array
		); //apply_filters
	}
endif;

//init customizer with 'flicker_customizer_settings_array' settings filter
add_action('init', 'flicker_init_customizer_class');
if (!function_exists('flicker_init_customizer_class')) :
	function flicker_init_customizer_class()
	{
		$flicker_customizer = new Flicker_Customizer(
			flicker_customizer_settings_array()
		);
	}
endif;
